/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.visualization;

import vtk.vtkAxes;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkFloatArray;
import vtk.vtkLODActor;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkTubeFilter;

public class Axes {
    private static final double axesScale = 1.0;
    private vtkAxes axes;
    private vtkLODActor axesActor;

    public Axes() {
        this.addCoordinateSystem();
    }

    public Axes(double scale, int viewport) {
        this.addCoordinateSystem(scale, viewport);
    }

    public Axes(double scale, float x, float y, float z, int viewport) {
        this.addCoordinateSystem(scale, x, y, z, viewport);
    }

    public Axes(double scale, double x, double y, double z, int viewport) {
        this.addCoordinateSystem(scale, x, y, z, viewport);
    }

    private void addCoordinateSystem(double scale, double x, double y, double z, int viewport2) {
        this.axes = new vtkAxes();
        this.axes.SetOrigin(x, y, z);
        this.axes.SetScaleFactor(scale);
        vtkFloatArray axesColors = new vtkFloatArray();
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(1.0);
        axesColors.InsertNextValue(1.0);
        vtkPolyData axesPolyData = this.axes.GetOutput();
        axesPolyData.Update();
        axesPolyData.GetPointData().SetScalars((vtkDataArray)axesColors);
        vtkTubeFilter axesTubes = new vtkTubeFilter();
        axesTubes.SetInput((vtkDataObject)axesPolyData);
        axesTubes.SetRadius(this.axes.GetScaleFactor() / 50.0);
        axesTubes.SetNumberOfSides(8);
        vtkPolyDataMapper axesMapper = new vtkPolyDataMapper();
        axesMapper.SetScalarModeToUsePointData();
        axesMapper.SetInputConnection(axesTubes.GetOutputPort());
        this.setAxesActor(new vtkLODActor());
        this.getAxesActor().SetMapper((vtkMapper)axesMapper);
    }

    private void addCoordinateSystem() {
        this.axes = new vtkAxes();
        this.axes.SetOrigin(0.0, 0.0, 0.0);
        this.axes.SetScaleFactor(1.0);
        vtkFloatArray axesColors = new vtkFloatArray();
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(1.0);
        axesColors.InsertNextValue(1.0);
        vtkPolyData axesPolyData = this.axes.GetOutput();
        axesPolyData.Update();
        axesPolyData.GetPointData().SetScalars((vtkDataArray)axesColors);
        vtkTubeFilter axesTubes = new vtkTubeFilter();
        axesTubes.SetInput((vtkDataObject)axesPolyData);
        axesTubes.SetRadius(this.axes.GetScaleFactor() / 50.0);
        axesTubes.SetNumberOfSides(8);
        vtkPolyDataMapper axesMapper = new vtkPolyDataMapper();
        axesMapper.SetScalarModeToUsePointData();
        axesMapper.SetInput(axesTubes.GetOutput());
        this.setAxesActor(new vtkLODActor());
        this.getAxesActor().SetMapper((vtkMapper)axesMapper);
    }

    private void addCoordinateSystem(double scale, int viewport) {
        this.axes = new vtkAxes();
        this.axes.SetOrigin(0.0, 0.0, 0.0);
        this.axes.SetScaleFactor(scale);
        vtkFloatArray axesColors = new vtkFloatArray();
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(1.0);
        axesColors.InsertNextValue(1.0);
        vtkPolyData axesPolyData = this.axes.GetOutput();
        axesPolyData.Update();
        axesPolyData.GetPointData().SetScalars((vtkDataArray)axesColors);
        vtkTubeFilter axesTubes = new vtkTubeFilter();
        axesTubes.SetInput((vtkDataObject)axesPolyData);
        axesTubes.SetRadius(this.axes.GetScaleFactor() / 50.0);
        axesTubes.SetNumberOfSides(6);
        vtkPolyDataMapper axesMapper = new vtkPolyDataMapper();
        axesMapper.SetScalarModeToUsePointData();
        axesMapper.SetInput(axesTubes.GetOutput());
        this.setAxesActor(new vtkLODActor());
        this.getAxesActor().SetMapper((vtkMapper)axesMapper);
    }

    private void addCoordinateSystem(double scale, float x, float y, float z, int viewport) {
        this.axes = new vtkAxes();
        this.axes.SetOrigin((double)x, (double)y, (double)z);
        this.axes.SetScaleFactor(scale);
        vtkFloatArray axesColors = new vtkFloatArray();
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.0);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(0.5);
        axesColors.InsertNextValue(1.0);
        axesColors.InsertNextValue(1.0);
        vtkPolyData axesPolyData = this.axes.GetOutput();
        axesPolyData.Update();
        axesPolyData.GetPointData().SetScalars((vtkDataArray)axesColors);
        vtkTubeFilter axesTubes = new vtkTubeFilter();
        axesTubes.SetInput((vtkDataObject)axesPolyData);
        axesTubes.SetRadius(this.axes.GetScaleFactor() / 50.0);
        axesTubes.SetNumberOfSides(6);
        vtkPolyDataMapper axesMapper = new vtkPolyDataMapper();
        axesMapper.SetScalarModeToUsePointData();
        axesMapper.SetInput(axesTubes.GetOutput());
        this.setAxesActor(new vtkLODActor());
        this.getAxesActor().SetMapper((vtkMapper)axesMapper);
    }

    public vtkLODActor getAxesActor() {
        return this.axesActor;
    }

    private void setAxesActor(vtkLODActor axesActor) {
        this.axesActor = axesActor;
    }
}

