/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.visualization;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.utils.Utils;
import vtk.vtkActorCollection;
import vtk.vtkCanvas;
import vtk.vtkMapper;
import vtk.vtkUnsignedCharArray;

public class Canvas
extends vtkCanvas {
    private static final long serialVersionUID = 5165188310777500794L;
    private vtkUnsignedCharArray buffer = new vtkUnsignedCharArray();
    private int bufferWidth;
    private int bufferHeight = 0;

    public Canvas() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
    }

    public void RenderSecured() {
        if (!this.isWindowSet()) {
            return;
        }
        Utils.goToAWTThread(new Runnable(){

            @Override
            public void run() {
                Canvas.this.Render();
            }
        });
    }

    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.ren.VisibleActorCount() == 0) {
                this.rendering = false;
                return;
            }
            if (this.rw != null) {
                if (this.windowset == 0) {
                    if (this.lightingset == 0) {
                        this.ren.AddLight(this.lgt);
                        this.lightingset = 1;
                    }
                    this.RenderCreate(this.rw);
                    this.Lock();
                    this.rw.SetSize(this.getWidth(), this.getHeight());
                    this.UnLock();
                    this.windowset = 1;
                }
                this.UpdateLight();
                this.Lock();
                this.rw.Render();
                this.UnLock();
                this.rendering = false;
            }
        }
    }

    public void lock() {
        if (this.isWindowSet()) {
            super.lock();
        }
    }

    public void unlock() {
        if (this.isWindowSet()) {
            super.unlock();
        }
    }

    public void setImmediateRenderingMode(boolean mode) {
        vtkActorCollection listOfActors = this.GetRenderer().GetActors();
        int nbActors = listOfActors.GetNumberOfItems();
        listOfActors.InitTraversal();
        for (int i = 0; i < nbActors; ++i) {
            vtkMapper mapper = listOfActors.GetNextActor().GetMapper();
            mapper.SetImmediateModeRendering(Utils.booleanToInt(mode));
        }
    }

    public void UpdateLight() {
        if (this.LightFollowCamera == 0) {
            return;
        }
        this.cam = this.GetRenderer().GetActiveCamera();
        super.UpdateLight();
    }

    public void Report() {
        Runnable updateAComponent = new Runnable(){

            @Override
            public void run() {
                Canvas.this.lock();
                NeptusLog.pub().info((Object)("direct rendering = " + (Canvas.this.GetRenderWindow().IsDirect() == 1)));
                NeptusLog.pub().info((Object)("opengl supported = " + (Canvas.this.GetRenderWindow().SupportsOpenGL() == 1)));
                NeptusLog.pub().info((Object)("report = " + Canvas.this.GetRenderWindow().ReportCapabilities()));
                Canvas.this.unlock();
            }
        };
        SwingUtilities.invokeLater(updateAComponent);
    }

    public void paint(Graphics g) {
        if (this.windowset == 0 || this.bufferWidth != this.getWidth() || this.bufferHeight != this.getHeight()) {
            this.Render();
        } else {
            this.lock();
            this.rw.SetPixelData(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.buffer, 1);
            this.unlock();
        }
    }

    public int getCtrlPressed() {
        return this.ctrlPressed;
    }

    public void setCtrlPressed(int ctrlPressed) {
        this.ctrlPressed = ctrlPressed;
    }

    public int getShiftPressed() {
        return this.shiftPressed;
    }

    public void setShiftPressed(int shiftPressed) {
        this.shiftPressed = shiftPressed;
    }

    public int getLastX() {
        return this.lastX;
    }

    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    public int getLastY() {
        return this.lastY;
    }

    public void setLastY(int lastY) {
        this.lastY = this.lastX;
    }
}

