/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.visualization;

import java.text.DecimalFormat;
import vtk.vtkTextActor;

public class InfoPointcloud2DText {
    private Boolean captionEnabled = false;
    private int xPosScreen;
    private int YPosScreen;
    private int numberOfPoints;
    private String cloudName;
    private double[] bounds;
    private int memorySize;
    private vtkTextActor captionNumberOfPointsActor;
    private vtkTextActor captionCloudNameActor;
    private vtkTextActor captionCloudBoundsActor;
    private vtkTextActor captionMemorySizeActor;
    private vtkTextActor captionLatLonActor;

    public InfoPointcloud2DText(int xPosScreen, int yPosScreen, int numberOfPoints, String cloudName, double[] bounds, int memorySize) {
        this.xPosScreen = xPosScreen;
        this.YPosScreen = yPosScreen;
        this.numberOfPoints = numberOfPoints;
        this.cloudName = cloudName;
        this.bounds = bounds;
        this.memorySize = memorySize;
        this.setCaptionNumberOfPointsActor(new vtkTextActor());
        this.setCaptionCloudNameActor(new vtkTextActor());
        this.setCaptionCloudBoundsActor(new vtkTextActor());
        this.setCaptionLatLonActor(new vtkTextActor());
        this.setCaptionMemorySizeActor(new vtkTextActor());
        this.buildCaptionActor();
        this.setCaptionEnabled(true);
    }

    private void buildCaptionActor() {
        try {
            this.captionNumberOfPointsActor.GetTextProperty().BoldOn();
            this.captionNumberOfPointsActor.GetTextProperty().ItalicOn();
            this.captionNumberOfPointsActor.GetTextProperty().SetFontSize(9);
            this.captionNumberOfPointsActor.GetTextProperty().SetColor(1.0, 0.0, 0.0);
            this.captionNumberOfPointsActor.SetDisplayPosition(this.xPosScreen, this.YPosScreen);
            this.captionNumberOfPointsActor.SetInput("Number of Points: " + String.valueOf(this.numberOfPoints));
            this.captionCloudNameActor.GetTextProperty().BoldOn();
            this.captionCloudNameActor.GetTextProperty().ItalicOn();
            this.captionCloudNameActor.GetTextProperty().SetFontSize(9);
            this.captionCloudNameActor.GetTextProperty().SetColor(1.0, 0.0, 0.0);
            this.captionCloudNameActor.SetDisplayPosition(this.xPosScreen, this.YPosScreen - 14);
            this.captionCloudNameActor.SetInput("Point Cloud Name: " + this.cloudName);
            this.captionMemorySizeActor.GetTextProperty().BoldOn();
            this.captionMemorySizeActor.GetTextProperty().ItalicOn();
            this.captionMemorySizeActor.GetTextProperty().SetFontSize(9);
            this.captionMemorySizeActor.GetTextProperty().SetColor(1.0, 0.0, 0.0);
            this.captionMemorySizeActor.SetDisplayPosition(this.xPosScreen, this.YPosScreen - 30);
            this.captionMemorySizeActor.SetInput("Memory Size (kB): " + String.valueOf(this.memorySize));
            this.captionCloudBoundsActor.GetTextProperty().ItalicOn();
            this.captionCloudBoundsActor.GetTextProperty().BoldOn();
            this.captionCloudBoundsActor.GetTextProperty().SetFontSize(9);
            this.captionCloudBoundsActor.GetTextProperty().SetColor(1.0, 0.0, 0.0);
            this.captionCloudBoundsActor.SetDisplayPosition(this.xPosScreen, this.YPosScreen - 72);
            DecimalFormat f = new DecimalFormat("##.00");
            this.captionCloudBoundsActor.SetInput("Bounds (meters): \nminX: " + f.format(this.bounds[0]) + "     maxX: " + f.format(this.bounds[1]) + "\n" + "minY: " + f.format(this.bounds[2]) + "     maxY: " + f.format(this.bounds[3]) + "\n" + "minZ: " + f.format(this.bounds[4]) + "     maxZ: " + f.format(this.bounds[5]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public vtkTextActor getCaptionNumberOfPointsActor() {
        return this.captionNumberOfPointsActor;
    }

    private void setCaptionNumberOfPointsActor(vtkTextActor captionNumberOfPointsActor) {
        this.captionNumberOfPointsActor = captionNumberOfPointsActor;
    }

    public vtkTextActor getCaptionCloudNameActor() {
        return this.captionCloudNameActor;
    }

    private void setCaptionCloudNameActor(vtkTextActor captionCloudNameActor) {
        this.captionCloudNameActor = captionCloudNameActor;
    }

    public vtkTextActor getCaptionCloudBoundsActor() {
        return this.captionCloudBoundsActor;
    }

    private void setCaptionCloudBoundsActor(vtkTextActor captionCloudBoundsActor) {
        this.captionCloudBoundsActor = captionCloudBoundsActor;
    }

    public vtkTextActor getCaptionLatLonActor() {
        return this.captionLatLonActor;
    }

    private void setCaptionLatLonActor(vtkTextActor captionLatLonActor) {
        this.captionLatLonActor = captionLatLonActor;
    }

    public vtkTextActor getCaptionMemorySizeActor() {
        return this.captionMemorySizeActor;
    }

    private void setCaptionMemorySizeActor(vtkTextActor captionMemorySizeActor) {
        this.captionMemorySizeActor = captionMemorySizeActor;
    }

    public Boolean getCaptionEnabled() {
        return this.captionEnabled;
    }

    public void setCaptionEnabled(Boolean captionEnabled) {
        this.captionEnabled = captionEnabled;
    }
}

