/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.visualization;

import pt.lsts.neptus.i18n.I18n;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkTextProperty;

public class ScalarBar {
    private vtkScalarBarActor scalarBarActor;
    private String scalarBarTitle;

    public ScalarBar() {
        this(I18n.text((String)"Color Map"));
    }

    public ScalarBar(String title) {
        this.setScalarBarActor(new vtkScalarBarActor());
        this.setScalarBarTitle(title);
    }

    public void setScalarBarHorizontalProperties() {
        this.getScalarBarActor().SetOrientationToHorizontal();
        this.getScalarBarActor().SetPosition(0.15, 0.01);
        this.getScalarBarActor().SetWidth(0.7);
        this.getScalarBarActor().SetHeight(0.1);
        this.getScalarBarActor().SetNumberOfLabels(9);
        this.getScalarBarActor().UseOpacityOn();
        this.getScalarBarActor().SetTitle(this.scalarBarTitle);
        vtkTextProperty textProp = new vtkTextProperty();
        textProp = this.getScalarBarActor().GetLabelTextProperty();
        textProp.SetFontFamilyToArial();
        textProp.BoldOn();
        textProp.ItalicOn();
        textProp.SetOpacity(0.9);
        textProp.SetFontSize(8);
        textProp.ShadowOn();
        this.getScalarBarActor().SetLabelTextProperty(textProp);
        this.getScalarBarActor().SetTitleTextProperty(textProp);
    }

    public void setScalarBarVerticalProperties() {
        this.getScalarBarActor().SetOrientationToVertical();
        this.getScalarBarActor().SetPosition(0.9, 0.1);
        this.getScalarBarActor().SetWidth(0.1);
        this.getScalarBarActor().SetHeight(0.8);
        this.getScalarBarActor().SetNumberOfLabels(9);
        this.getScalarBarActor().UseOpacityOn();
        this.getScalarBarActor().SetTitle(this.scalarBarTitle);
        vtkTextProperty textProp = new vtkTextProperty();
        textProp = this.getScalarBarActor().GetLabelTextProperty();
        textProp.SetFontFamilyToArial();
        textProp.BoldOn();
        textProp.ItalicOn();
        textProp.SetOpacity(0.9);
        textProp.SetFontSize(8);
        textProp.ShadowOn();
        this.getScalarBarActor().SetLabelTextProperty(textProp);
        this.getScalarBarActor().SetTitleTextProperty(textProp);
    }

    public void setUpScalarBarLookupTable(vtkScalarsToColors lut) {
        this.getScalarBarActor().SetLookupTable(lut);
        this.getScalarBarActor().Modified();
    }

    public vtkScalarBarActor getScalarBarActor() {
        return this.scalarBarActor;
    }

    private void setScalarBarActor(vtkScalarBarActor scalarBarActor) {
        this.scalarBarActor = scalarBarActor;
    }

    public String getScalarBarTitle() {
        return this.scalarBarTitle;
    }

    public void setScalarBarTitle(String scalarBarTitle) {
        this.scalarBarTitle = scalarBarTitle;
    }
}

