/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLUniformData;
import jogamp.opengl.Debug;

public class ShaderState {
    public static final boolean DEBUG = Debug.isPropertyDefined("jogl.debug.GLSLState", true);
    private static final String currentStateKey = "jogamp.opengl.glsl.ShaderState";
    private boolean verbose = DEBUG;
    private ShaderProgram shaderProgram = null;
    private HashMap<String, Boolean> activedAttribEnabledMap = new HashMap();
    private HashMap<String, Integer> activeAttribLocationMap = new HashMap();
    private HashMap<String, GLArrayData> activeAttribDataMap = new HashMap();
    private ArrayList<GLArrayData> managedAttributes = new ArrayList();
    private HashMap<String, Integer> activeUniformLocationMap = new HashMap();
    private HashMap<String, GLUniformData> activeUniformDataMap = new HashMap();
    private ArrayList<GLUniformData> managedUniforms = new ArrayList();
    private HashMap<String, Object> attachedObjectsByString = new HashMap();
    private IntObjectHashMap attachedObjectsByInt = new IntObjectHashMap();
    private boolean resetAllShaderData = false;

    public boolean verbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public static ShaderState getCurrentShaderState() {
        return ShaderState.getShaderState(GLContext.getCurrentGL());
    }

    public static ShaderState getShaderState(GL gL) {
        return (ShaderState)gL.getContext().getAttachedObject(currentStateKey);
    }

    public final ShaderState setShaderState(GL gL) {
        return (ShaderState)gL.getContext().attachObject(currentStateKey, (Object)this);
    }

    public final Object getAttachedObject(String string) {
        return this.attachedObjectsByString.get(string);
    }

    public final Object attachObject(String string, Object object) {
        return this.attachedObjectsByString.put(string, object);
    }

    public final Object detachObject(String string) {
        return this.attachedObjectsByString.remove(string);
    }

    public final Object getAttachedObject(int n) {
        return this.attachedObjectsByInt.get(n);
    }

    public final Object attachObject(int n, Object object) {
        return this.attachedObjectsByInt.put(n, object);
    }

    public final Object detachObject(int n) {
        return this.attachedObjectsByInt.remove(n);
    }

    public synchronized void useProgram(GL2ES2 gL2ES2, boolean bl) throws GLException {
        if (null == this.shaderProgram) {
            throw new GLException("No program is attached");
        }
        if (bl) {
            this.setShaderState(gL2ES2);
            if (this.shaderProgram.linked()) {
                this.shaderProgram.useProgram(gL2ES2, true);
                if (this.resetAllShaderData) {
                    this.resetAllAttributes(gL2ES2);
                    this.resetAllUniforms(gL2ES2);
                }
            } else {
                if (this.resetAllShaderData) {
                    this.setAllAttributes(gL2ES2);
                }
                if (!this.shaderProgram.link(gL2ES2, System.err)) {
                    throw new GLException("could not link program: " + this.shaderProgram);
                }
                this.shaderProgram.useProgram(gL2ES2, true);
                if (this.resetAllShaderData) {
                    this.resetAllUniforms(gL2ES2);
                }
            }
            this.resetAllShaderData = false;
        } else {
            this.shaderProgram.useProgram(gL2ES2, false);
        }
    }

    public boolean linked() {
        return null != this.shaderProgram ? this.shaderProgram.linked() : false;
    }

    public boolean inUse() {
        return null != this.shaderProgram ? this.shaderProgram.inUse() : false;
    }

    public synchronized void attachShaderProgram(GL2ES2 gL2ES2, ShaderProgram shaderProgram, boolean bl) throws GLException {
        if (DEBUG) {
            int n = null != this.shaderProgram ? this.shaderProgram.id() : -1;
            int n2 = null != shaderProgram ? shaderProgram.id() : -1;
            System.err.println("Info: attachShaderProgram: " + n + " -> " + n2 + " (enable: " + bl + ")\n\t" + this.shaderProgram + "\n\t" + shaderProgram);
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: attachShaderProgram: Trace");
                throwable.printStackTrace();
            }
        }
        if (null != this.shaderProgram) {
            if (this.shaderProgram.equals(shaderProgram)) {
                if (DEBUG) {
                    System.err.println("Info: attachShaderProgram: NOP: equal id: " + this.shaderProgram.id());
                }
                return;
            }
            if (this.shaderProgram.inUse()) {
                if (null != shaderProgram && bl) {
                    this.shaderProgram.programInUse = false;
                } else {
                    this.useProgram(gL2ES2, false);
                }
            }
            this.resetAllShaderData = true;
        }
        this.shaderProgram = shaderProgram;
        if (null != this.shaderProgram && (this.resetAllShaderData || bl)) {
            this.useProgram(gL2ES2, true);
            if (!bl) {
                this.useProgram(gL2ES2, false);
            }
        }
        if (DEBUG) {
            System.err.println("Info: attachShaderProgram: END");
        }
    }

    public ShaderProgram shaderProgram() {
        return this.shaderProgram;
    }

    public synchronized void destroy(GL2ES2 gL2ES2) {
        this.release(gL2ES2, true, true, true);
        this.attachedObjectsByString.clear();
        this.attachedObjectsByInt.clear();
    }

    public synchronized void releaseAllData(GL2ES2 gL2ES2) {
        this.release(gL2ES2, false, false, false);
    }

    public synchronized void release(GL2ES2 gL2ES2, boolean bl, boolean bl2, boolean bl3) {
        if (null != this.shaderProgram) {
            this.shaderProgram.useProgram(gL2ES2, false);
        }
        if (bl) {
            Iterator<GLArrayData> iterator = this.managedAttributes.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy(gL2ES2);
            }
        }
        this.releaseAllAttributes(gL2ES2);
        this.releaseAllUniforms(gL2ES2);
        if (null != this.shaderProgram && bl2) {
            this.shaderProgram.release(gL2ES2, bl3);
        }
    }

    public int getCachedAttribLocation(String string) {
        Integer n = this.activeAttribLocationMap.get(string);
        return null != n ? n : -1;
    }

    public GLArrayData getAttribute(String string) {
        return this.activeAttribDataMap.get(string);
    }

    public void ownAttribute(GLArrayData gLArrayData, boolean bl) {
        if (bl) {
            int n = this.getCachedAttribLocation(gLArrayData.getName());
            if (0 <= n) {
                gLArrayData.setLocation(n);
            }
            this.managedAttributes.add(this.managedAttributes.size(), gLArrayData);
        } else {
            this.managedAttributes.remove(gLArrayData);
        }
    }

    public boolean ownsAttribute(GLArrayData gLArrayData) {
        return this.managedAttributes.contains(gLArrayData);
    }

    public void bindAttribLocation(GL2ES2 gL2ES2, int n, String string) {
        if (null == this.shaderProgram) {
            throw new GLException("No program is attached");
        }
        if (this.shaderProgram.linked()) {
            throw new GLException("Program is already linked");
        }
        Integer n2 = new Integer(n);
        this.activeAttribLocationMap.put(string, n2);
        gL2ES2.glBindAttribLocation(this.shaderProgram.program(), n, string);
    }

    public void bindAttribLocation(GL2ES2 gL2ES2, int n, GLArrayData gLArrayData) {
        this.bindAttribLocation(gL2ES2, n, gLArrayData.getName());
        gLArrayData.setLocation(n);
        this.activeAttribDataMap.put(gLArrayData.getName(), gLArrayData);
    }

    public int getAttribLocation(GL2ES2 gL2ES2, String string) {
        if (null == this.shaderProgram) {
            throw new GLException("No program is attached");
        }
        int n = this.getCachedAttribLocation(string);
        if (0 > n) {
            if (!this.shaderProgram.linked()) {
                throw new GLException("Program is not linked");
            }
            n = gL2ES2.glGetAttribLocation(this.shaderProgram.program(), string);
            if (0 <= n) {
                Integer n2 = new Integer(n);
                this.activeAttribLocationMap.put(string, n2);
                if (DEBUG) {
                    System.err.println("Info: glGetAttribLocation: " + string + ", loc: " + n);
                }
            } else if (this.verbose) {
                Throwable throwable = new Throwable("Info: glGetAttribLocation failed, no location for: " + string + ", loc: " + n);
                throwable.printStackTrace();
            }
        }
        return n;
    }

    public int getAttribLocation(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        int n = this.getAttribLocation(gL2ES2, gLArrayData.getName());
        gLArrayData.setLocation(n);
        this.activeAttribDataMap.put(gLArrayData.getName(), gLArrayData);
        return n;
    }

    public final boolean isVertexAttribArrayEnabled(String string) {
        Boolean bl = this.activedAttribEnabledMap.get(string);
        return null != bl && bl != false;
    }

    public final boolean isVertexAttribArrayEnabled(GLArrayData gLArrayData) {
        return this.isVertexAttribArrayEnabled(gLArrayData.getName());
    }

    private boolean enableVertexAttribArray(GL2ES2 gL2ES2, String string, int n) {
        this.activedAttribEnabledMap.put(string, Boolean.TRUE);
        if (0 > n && 0 > (n = this.getAttribLocation(gL2ES2, string))) {
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: glEnableVertexAttribArray failed, no index for: " + string);
                throwable.printStackTrace();
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("Info: glEnableVertexAttribArray: " + string + ", loc: " + n);
        }
        gL2ES2.glEnableVertexAttribArray(n);
        return true;
    }

    public boolean enableVertexAttribArray(GL2ES2 gL2ES2, String string) {
        return this.enableVertexAttribArray(gL2ES2, string, -1);
    }

    public boolean enableVertexAttribArray(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        if (0 > gLArrayData.getLocation()) {
            this.getAttribLocation(gL2ES2, gLArrayData);
        } else {
            this.activeAttribDataMap.put(gLArrayData.getName(), gLArrayData);
        }
        return this.enableVertexAttribArray(gL2ES2, gLArrayData.getName(), gLArrayData.getLocation());
    }

    private boolean disableVertexAttribArray(GL2ES2 gL2ES2, String string, int n) {
        this.activedAttribEnabledMap.put(string, Boolean.FALSE);
        if (0 > n && 0 > (n = this.getAttribLocation(gL2ES2, string))) {
            if (this.verbose) {
                Throwable throwable = new Throwable("Info: glDisableVertexAttribArray failed, no index for: " + string);
                throwable.printStackTrace();
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("Info: glDisableVertexAttribArray: " + string);
        }
        gL2ES2.glDisableVertexAttribArray(n);
        return true;
    }

    public boolean disableVertexAttribArray(GL2ES2 gL2ES2, String string) {
        return this.disableVertexAttribArray(gL2ES2, string, -1);
    }

    public boolean disableVertexAttribArray(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        if (0 > gLArrayData.getLocation()) {
            this.getAttribLocation(gL2ES2, gLArrayData);
        }
        return this.disableVertexAttribArray(gL2ES2, gLArrayData.getName(), gLArrayData.getLocation());
    }

    public boolean vertexAttribPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        int n = gLArrayData.getLocation();
        if (0 > n) {
            n = this.getAttribLocation(gL2ES2, gLArrayData);
        }
        if (0 <= n) {
            if (DEBUG) {
                System.err.println("Info: glVertexAttribPointer: " + gLArrayData);
            }
            gL2ES2.glVertexAttribPointer(gLArrayData);
            return true;
        }
        return false;
    }

    public void releaseAllAttributes(GL2ES2 gL2ES2) {
        if (null != this.shaderProgram) {
            Iterator<Object> iterator = this.activeAttribDataMap.values().iterator();
            while (iterator.hasNext()) {
                this.disableVertexAttribArray(gL2ES2, iterator.next());
            }
            iterator = this.activedAttribEnabledMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.disableVertexAttribArray(gL2ES2, (String)iterator.next());
            }
        }
        this.activeAttribDataMap.clear();
        this.activedAttribEnabledMap.clear();
        this.activeAttribLocationMap.clear();
        this.managedAttributes.clear();
    }

    public void disableAllVertexAttributeArrays(GL2ES2 gL2ES2, boolean bl) {
        for (String string : this.activedAttribEnabledMap.keySet()) {
            int n;
            if (bl) {
                this.activedAttribEnabledMap.remove(string);
            }
            if (0 > (n = this.getAttribLocation(gL2ES2, string))) continue;
            gL2ES2.glDisableVertexAttribArray(n);
        }
    }

    private final void relocateAttribute(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        String string = gLArrayData.getName();
        int n = this.getAttribLocation(gL2ES2, string);
        gLArrayData.setLocation(n);
        if (0 <= n) {
            if (this.isVertexAttribArrayEnabled(string)) {
                gL2ES2.glEnableVertexAttribArray(n);
            }
            if (gLArrayData.isVBO()) {
                gL2ES2.glBindBuffer(34962, gLArrayData.getVBOName());
            }
            gL2ES2.glVertexAttribPointer(gLArrayData);
        }
    }

    private final void resetAllAttributes(GL2ES2 gL2ES2) {
        if (!this.shaderProgram.linked()) {
            throw new GLException("Program is not linked");
        }
        this.activeAttribLocationMap.clear();
        Iterator<GLArrayData> iterator = this.managedAttributes.iterator();
        while (iterator.hasNext()) {
            iterator.next().setLocation(-1);
        }
        iterator = this.activeAttribDataMap.values().iterator();
        while (iterator.hasNext()) {
            this.relocateAttribute(gL2ES2, iterator.next());
        }
    }

    private final void setAttribute(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        String string = gLArrayData.getName();
        int n = gLArrayData.getLocation();
        if (0 <= n) {
            this.bindAttribLocation(gL2ES2, n, string);
            if (this.isVertexAttribArrayEnabled(string)) {
                gL2ES2.glEnableVertexAttribArray(n);
            }
            if (gLArrayData.isVBO()) {
                gL2ES2.glBindBuffer(34962, gLArrayData.getVBOName());
            }
            gL2ES2.glVertexAttribPointer(gLArrayData);
        }
    }

    private final void setAllAttributes(GL2ES2 gL2ES2) {
        Iterator<GLArrayData> iterator = this.activeAttribDataMap.values().iterator();
        while (iterator.hasNext()) {
            this.setAttribute(gL2ES2, iterator.next());
        }
    }

    public final int getCachedUniformLocation(String string) {
        Integer n = this.activeUniformLocationMap.get(string);
        return null != n ? n : -1;
    }

    public void ownUniform(GLUniformData gLUniformData) {
        int n = this.getCachedUniformLocation(gLUniformData.getName());
        if (0 <= n) {
            gLUniformData.setLocation(n);
        }
        this.activeUniformDataMap.put(gLUniformData.getName(), gLUniformData);
        this.managedUniforms.add(gLUniformData);
    }

    public boolean ownsUniform(GLUniformData gLUniformData) {
        return this.managedUniforms.contains(gLUniformData);
    }

    public final int getUniformLocation(GL2ES2 gL2ES2, String string) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        int n = this.getCachedUniformLocation(string);
        if (0 > n) {
            n = gL2ES2.glGetUniformLocation(this.shaderProgram.program(), string);
            if (0 <= n) {
                Integer n2 = new Integer(n);
                this.activeUniformLocationMap.put(string, n2);
            } else if (this.verbose) {
                Throwable throwable = new Throwable("Info: glUniform failed, no location for: " + string + ", index: " + n);
                throwable.printStackTrace();
            }
        }
        return n;
    }

    public int getUniformLocation(GL2ES2 gL2ES2, GLUniformData gLUniformData) {
        int n = this.getUniformLocation(gL2ES2, gLUniformData.getName());
        gLUniformData.setLocation(n);
        this.activeUniformDataMap.put(gLUniformData.getName(), gLUniformData);
        return n;
    }

    public boolean uniform(GL2ES2 gL2ES2, GLUniformData gLUniformData) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        int n = gLUniformData.getLocation();
        if (0 > n) {
            n = this.getUniformLocation(gL2ES2, gLUniformData);
        }
        if (0 <= n) {
            if (DEBUG) {
                System.err.println("Info: glUniform: " + gLUniformData);
            }
            gL2ES2.glUniform(gLUniformData);
        }
        return true;
    }

    public GLUniformData getUniform(String string) {
        return this.activeUniformDataMap.get(string);
    }

    public void releaseAllUniforms(GL2ES2 gL2ES2) {
        this.activeUniformDataMap.clear();
        this.activeUniformLocationMap.clear();
        this.managedUniforms.clear();
    }

    private final void resetAllUniforms(GL2ES2 gL2ES2) {
        if (!this.shaderProgram.inUse()) {
            throw new GLException("Program is not in use");
        }
        this.activeUniformLocationMap.clear();
        Iterator<GLUniformData> iterator = this.managedUniforms.iterator();
        while (iterator.hasNext()) {
            iterator.next().setLocation(-1);
        }
        for (GLUniformData gLUniformData : this.activeUniformDataMap.values()) {
            gLUniformData.setLocation(-1);
            this.uniform(gL2ES2, gLUniformData);
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("ShaderState[ ");
        stringBuilder.append(Platform.getNewline()).append(" ");
        if (null != this.shaderProgram) {
            this.shaderProgram.toString(stringBuilder);
        } else {
            stringBuilder.append("ShaderProgram: null");
        }
        stringBuilder.append(Platform.getNewline()).append(" enabledAttributes [");
        Iterator<Object> iterator = this.activedAttribEnabledMap.keySet().iterator();
        Iterator<Boolean> iterator2 = this.activedAttribEnabledMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("  ").append(iterator.next()).append(": ").append(iterator2.next());
        }
        stringBuilder.append(Platform.getNewline()).append(" ],").append(" activeAttributes [");
        iterator = this.activeAttribDataMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("  ").append(iterator.next());
        }
        stringBuilder.append(Platform.getNewline()).append(" ],").append(" managedAttributes [");
        iterator = this.managedAttributes.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("  ").append(iterator.next());
        }
        stringBuilder.append(Platform.getNewline()).append(" ],").append(" activeUniforms [");
        iterator = this.activeUniformDataMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("  ").append(iterator.next());
        }
        stringBuilder.append(Platform.getNewline()).append(" ],").append(" managedUniforms [");
        iterator = this.managedUniforms.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("  ").append(iterator.next());
        }
        stringBuilder.append(Platform.getNewline()).append(" ]").append(Platform.getNewline()).append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

