/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.locks.RecursiveLock;
import java.io.PrintStream;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.FPSCounter;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;
import jogamp.opengl.FPSCounterImpl;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;

public abstract class GLAutoDrawableBase
implements GLAutoDrawable,
FPSCounter {
    public static final boolean DEBUG = Debug.debug("GLAutoDrawable");
    protected final GLDrawableHelper helper = new GLDrawableHelper();
    protected final FPSCounterImpl fpsCounter = new FPSCounterImpl();
    protected volatile GLDrawableImpl drawable;
    protected GLContextImpl context;
    protected final boolean ownDevice;
    protected int additionalCtxCreationFlags = 0;
    protected volatile boolean sendReshape = false;
    protected volatile boolean sendDestroy = false;
    protected final Runnable defaultInitAction = new Runnable(){

        @Override
        public final void run() {
            GLAutoDrawableBase.this.helper.init(GLAutoDrawableBase.this);
            GLAutoDrawableBase.this.resetFPSCounter();
        }
    };
    protected final Runnable defaultDisplayAction = new Runnable(){

        @Override
        public final void run() {
            if (GLAutoDrawableBase.this.sendReshape) {
                GLAutoDrawableBase.this.helper.reshape(GLAutoDrawableBase.this, 0, 0, GLAutoDrawableBase.this.getWidth(), GLAutoDrawableBase.this.getHeight());
                GLAutoDrawableBase.this.sendReshape = false;
            }
            GLAutoDrawableBase.this.helper.display(GLAutoDrawableBase.this);
            GLAutoDrawableBase.this.fpsCounter.tickFPS();
        }
    };
    protected final Runnable defaultSwapAction = new Runnable(){

        @Override
        public final void run() {
            GLAutoDrawableBase.this.drawable.swapBuffers();
        }
    };

    public GLAutoDrawableBase(GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, boolean bl) {
        this.drawable = gLDrawableImpl;
        this.context = gLContextImpl;
        this.ownDevice = bl;
        this.resetFPSCounter();
    }

    protected abstract RecursiveLock getLock();

    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    protected final void defaultWindowRepaintOp() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl && gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimating()) {
            this.display();
        }
    }

    protected final void defaultWindowResizedOp() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            if (DEBUG) {
                System.err.println("GLAutoDrawableBase.sizeChanged: (" + Thread.currentThread().getName() + "): " + this.getWidth() + "x" + this.getHeight() + " - surfaceHandle 0x" + Long.toHexString(this.getNativeSurface().getSurfaceHandle()));
            }
            this.sendReshape = true;
            if (gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimating()) {
                this.display();
            }
        }
    }

    protected final void defaultWindowDestroyNotifyOp() {
        NativeSurface nativeSurface = this.getNativeSurface();
        boolean bl = nativeSurface instanceof WindowClosingProtocol ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == ((WindowClosingProtocol)((Object)nativeSurface)).getDefaultCloseOperation() : true;
        if (bl) {
            this.destroyAvoidAwareOfLocking();
        }
    }

    protected final void destroyAvoidAwareOfLocking() {
        NativeSurface nativeSurface = this.getNativeSurface();
        GLAnimatorControl gLAnimatorControl = this.helper.getAnimator();
        if (this.helper.isAnimatorRunningOnOtherThread()) {
            boolean bl = gLAnimatorControl.pause();
            this.destroy();
            if (bl) {
                gLAnimatorControl.resume();
            }
        } else if (null != nativeSurface && nativeSurface.isSurfaceLockedByOtherThread()) {
            this.sendDestroy = true;
        } else {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultDestroy() {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            this.destroyImplInLock();
        }
        finally {
            recursiveLock.unlock();
        }
    }

    protected void destroyImplInLock() {
        GLContextImpl gLContextImpl = this.context;
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            if (gLDrawableImpl.isRealized()) {
                if (null != gLContextImpl && gLContextImpl.isCreated()) {
                    try {
                        this.helper.disposeGL(this, gLDrawableImpl, gLContextImpl, null);
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                }
                gLDrawableImpl.setRealized(false);
            }
            if (this.ownDevice) {
                gLDrawableImpl.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice().close();
            }
        }
        this.context = null;
        this.drawable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultSwapBuffers() throws GLException {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (this.drawable != null && this.context != null) {
                this.drawable.swapBuffers();
                this.helper.invokeGL(this.drawable, this.context, this.defaultSwapAction, this.defaultInitAction);
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultDisplay() {
        if (this.sendDestroy) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (null != this.context) {
                this.helper.invokeGL(this.drawable, this.context, this.defaultDisplayAction, this.defaultInitAction);
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext setContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            boolean bl = this.helper.switchContext(this.drawable, gLContextImpl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            if (bl) {
                this.context.makeCurrent();
            }
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GL getGL() {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl == null) {
            return null;
        }
        return ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public final GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl != null) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public final void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public final void removeGLEventListener(GLEventListener gLEventListener) {
        this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.removeGLEventListener(n);
    }

    @Override
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public final GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final boolean invoke(boolean bl, GLRunnable gLRunnable) {
        return this.helper.invoke(this, bl, gLRunnable);
    }

    @Override
    public final void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    @Override
    public final boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public final void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public int getWidth() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getWidth() : 0;
    }

    @Override
    public int getHeight() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHeight() : 0;
    }

    @Deprecated
    public void setSkipContextReleaseThread(Thread thread) {
        this.helper.setSkipContextReleaseThread(thread);
    }

    @Deprecated
    public Thread getSkipContextReleaseThread() {
        return this.helper.getSkipContextReleaseThread();
    }

    @Override
    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : null;
    }

    @Override
    public final GLProfile getGLProfile() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getGLProfile() : null;
    }

    @Override
    public final NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public final long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHandle() : 0L;
    }
}

