/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.WrappedSurface;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLOnscreenDrawable;
import jogamp.opengl.egl.EGLPbufferDrawable;
import jogamp.opengl.egl.EGLUpstreamSurfaceHook;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    static final boolean QUERY_EGL_ES = !Debug.isPropertyDefined("jogl.debug.EGLDrawableFactory.DontQuery", true);
    static final boolean QUERY_EGL_ES_NATIVE_TK = Debug.isPropertyDefined("jogl.debug.EGLDrawableFactory.QueryNativeTK", true);
    private static GLDynamicLookupHelper eglES1DynamicLookupHelper = null;
    private static GLDynamicLookupHelper eglES2DynamicLookupHelper = null;
    private static boolean isANGLE = false;
    private HashMap<String, SharedResource> sharedMap = new HashMap();
    private EGLGraphicsDevice defaultDevice;
    private static final ProxySurface.UpstreamSurfaceHook dummySurfaceLifecycleHook = new ProxySurface.UpstreamSurfaceHook(){

        @Override
        public final void create(ProxySurface proxySurface) {
            if (0L == proxySurface.getSurfaceHandle()) {
                EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)proxySurface.getGraphicsConfiguration().getScreen().getDevice();
                if (0L == eGLGraphicsDevice.getHandle()) {
                    eGLGraphicsDevice.open();
                    proxySurface.setImplBitfield(128);
                }
                EGLDrawableFactory.createPBufferSurfaceImpl(proxySurface, false);
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.dummySurfaceLifecycleHook.create: " + proxySurface);
                }
            }
        }

        @Override
        public final void destroy(ProxySurface proxySurface) {
            if (0L != proxySurface.getSurfaceHandle()) {
                EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)proxySurface.getGraphicsConfiguration();
                EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
                EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), proxySurface.getSurfaceHandle());
                proxySurface.setSurfaceHandle(0L);
                if (0 != (0x80 & proxySurface.getImplBitfield())) {
                    eGLGraphicsDevice.close();
                }
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.dummySurfaceLifecycleHook.create: " + proxySurface);
                }
            }
        }

        @Override
        public final int getWidth(ProxySurface proxySurface) {
            return proxySurface.initialWidth;
        }

        @Override
        public final int getHeight(ProxySurface proxySurface) {
            return proxySurface.initialHeight;
        }

        public String toString() {
            return "EGLSurfaceLifecycleHook[]";
        }
    };

    private static final boolean isANGLE(GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (Platform.OSType.WINDOWS == Platform.OS_TYPE) {
            boolean bl = 0L != gLDynamicLookupHelper.dynamicLookupFunction("eglQuerySurfacePointerANGLE") || 0L != gLDynamicLookupHelper.dynamicLookupFunction("glBlitFramebufferANGLE") || 0L != gLDynamicLookupHelper.dynamicLookupFunction("glRenderbufferStorageMultisampleANGLE");
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EGLDrawableFactory() {
        EGLGraphicsConfigurationFactory.registerFactory();
        if ("X11".equals(NativeWindowFactory.getNativeWindowType(true))) {
            try {
                ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                // empty catch block
            }
        }
        this.defaultDevice = new EGLGraphicsDevice("decon", 0);
        Class<EGLDrawableFactory> clazz = EGLDrawableFactory.class;
        synchronized (EGLDrawableFactory.class) {
            GLDynamicLookupHelper gLDynamicLookupHelper;
            boolean bl;
            boolean bl2 = bl = null != eglES2DynamicLookupHelper;
            if (!bl && null == eglES1DynamicLookupHelper) {
                block20: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block20;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES1DynamicLookupHelper);
                    boolean bl3 = EGLDrawableFactory.isANGLE(eglES1DynamicLookupHelper);
                    isANGLE |= bl3;
                    if (GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK, isANGLE: " + bl3);
                    }
                } else if (GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE");
                }
            }
            if (!bl && null == eglES2DynamicLookupHelper) {
                block21: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block21;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    eglES2DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES2DynamicLookupHelper);
                    boolean bl4 = EGLDrawableFactory.isANGLE(eglES2DynamicLookupHelper);
                    isANGLE |= bl4;
                    if (GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES2 - OK, isANGLE: " + bl4);
                    }
                } else if (GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES2 - NOPE");
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected final void destroy(GLProfile.ShutdownType shutdownType) {
        if (null != this.sharedMap) {
            Collection<SharedResource> collection = this.sharedMap.values();
            for (SharedResource sharedResource : collection) {
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.destroy(" + (Object)((Object)shutdownType) + "): " + sharedResource.device.toString());
                }
                sharedResource.device.close();
            }
            this.sharedMap.clear();
            this.sharedMap = null;
        }
        this.defaultDevice = null;
        if (GLProfile.ShutdownType.COMPLETE == shutdownType) {
            if (null != eglES1DynamicLookupHelper) {
                eglES1DynamicLookupHelper = null;
            }
            if (null != eglES2DynamicLookupHelper) {
                eglES2DynamicLookupHelper = null;
            }
        }
        EGLGraphicsConfigurationFactory.unregisterFactory();
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != eglES2DynamicLookupHelper || null != eglES1DynamicLookupHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEGLContextAvailable(AbstractGraphicsDevice abstractGraphicsDevice, EGLGraphicsDevice eGLGraphicsDevice, String string) {
        if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
            return false;
        }
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
        GLDrawableFactoryImpl gLDrawableFactoryImpl = (GLDrawableFactoryImpl)GLDrawableFactory.getDesktopFactory();
        EGLGraphicsDevice eGLGraphicsDevice2 = null;
        NativeSurface nativeSurface = null;
        ProxySurface proxySurface = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(5);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setAlphaBits(0);
            if (abstractGraphicsDevice instanceof EGLGraphicsDevice || null == gLDrawableFactoryImpl || !QUERY_EGL_ES_NATIVE_TK) {
                eGLGraphicsDevice2 = eGLGraphicsDevice;
                proxySurface = nativeSurface = this.createDummySurfaceImpl(eGLGraphicsDevice2, false, gLCapabilities, null, 64, 64);
                proxySurface.createNotify();
                bl2 = false;
            } else {
                nativeSurface = gLDrawableFactoryImpl.createDummySurface(abstractGraphicsDevice, gLCapabilities, null, 64, 64);
                NativeSurface nativeSurface2 = proxySurface = nativeSurface instanceof ProxySurface ? nativeSurface : null;
                if (null != proxySurface) {
                    proxySurface.createNotify();
                }
                eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(nativeSurface, true);
                bl2 = true;
            }
            EGLDrawable eGLDrawable = (EGLDrawable)this.createOnscreenDrawableImpl(nativeSurface);
            eGLDrawable.setRealized(true);
            EGLContext eGLContext = (EGLContext)eGLDrawable.createContext(null);
            if (null != eGLContext) {
                try {
                    String string2;
                    eGLContext.makeCurrent();
                    bl = eGLContext.isCurrent();
                    if (bl && null == (string2 = eGLContext.getGL().glGetString(7938))) {
                        if (DEBUG) {
                            System.err.println("EGLDrawableFactory.isEGLContextAvailable: " + eGLGraphicsDevice2 + ", " + eGLContext.getGLVersion() + " - VERSION is null, dropping availability!");
                        }
                        bl = false;
                    }
                    if (bl) {
                        eGLContext.mapCurrentAvailableGLVersion(eGLGraphicsDevice2);
                        if (eGLGraphicsDevice2 != abstractGraphicsDevice) {
                            eGLContext.mapCurrentAvailableGLVersion(abstractGraphicsDevice);
                        }
                    }
                }
                catch (GLException gLException) {
                    if (DEBUG) {
                        System.err.println("EGLDrawableFactory.createShared: INFO: context create/makeCurrent failed");
                        gLException.printStackTrace();
                    }
                }
                finally {
                    eGLContext.destroy();
                }
            }
            eGLDrawable.setRealized(false);
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("Catched Exception:");
                throwable.printStackTrace();
            }
            bl = false;
        }
        finally {
            if (eGLGraphicsDevice2 == eGLGraphicsDevice) {
                if (null != proxySurface) {
                    proxySurface.destroyNotify();
                }
            } else if (bl2) {
                if (null != eGLGraphicsDevice2) {
                    eGLGraphicsDevice2.close();
                }
                if (null != proxySurface) {
                    proxySurface.destroyNotify();
                }
            } else {
                if (null != proxySurface) {
                    proxySurface.destroyNotify();
                }
                if (null != eGLGraphicsDevice2) {
                    eGLGraphicsDevice2.close();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedResource getOrCreateEGLSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource;
        if (null == eglES1DynamicLookupHelper && null == eglES2DynamicLookupHelper) {
            return null;
        }
        String string = abstractGraphicsDevice.getConnection();
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            sharedResource = this.sharedMap.get(string);
        }
        if (null == sharedResource) {
            boolean bl;
            boolean bl2;
            EGLGraphicsDevice eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, "decon", 0);
            if (QUERY_EGL_ES) {
                bl2 = this.isEGLContextAvailable(abstractGraphicsDevice, eGLGraphicsDevice, "GLES1");
                bl = this.isEGLContextAvailable(abstractGraphicsDevice, eGLGraphicsDevice, "GLES2");
            } else {
                bl2 = true;
                bl = true;
                EGLContext.mapStaticGLESVersion(eGLGraphicsDevice, 1);
                if (eGLGraphicsDevice != abstractGraphicsDevice) {
                    EGLContext.mapStaticGLESVersion(abstractGraphicsDevice, 1);
                }
                EGLContext.mapStaticGLESVersion(eGLGraphicsDevice, 2);
                if (eGLGraphicsDevice != abstractGraphicsDevice) {
                    EGLContext.mapStaticGLESVersion(abstractGraphicsDevice, 2);
                }
            }
            if (!EGLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                EGLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
            }
            sharedResource = new SharedResource(eGLGraphicsDevice, bl2, bl);
            HashMap<String, SharedResource> hashMap2 = this.sharedMap;
            synchronized (hashMap2) {
                this.sharedMap.put(string, sharedResource);
                if (abstractGraphicsDevice != eGLGraphicsDevice) {
                    this.sharedMap.put(eGLGraphicsDevice.getConnection(), sharedResource);
                }
            }
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.createShared: devices:  queried " + QUERY_EGL_ES + "[nativeTK " + QUERY_EGL_ES_NATIVE_TK + "], " + abstractGraphicsDevice + ", " + eGLGraphicsDevice);
                System.err.println("EGLDrawableFactory.createShared: context ES1: " + bl2);
                System.err.println("EGLDrawableFactory.createShared: context ES2: " + bl);
            }
        }
        return sharedResource;
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return null;
    }

    @Override
    protected final boolean createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        block3: {
            try {
                SharedResource sharedResource = this.getOrCreateEGLSharedResource(abstractGraphicsDevice);
                if (null != sharedResource) {
                    return sharedResource.wasES1ContextAvailable() || sharedResource.wasES2ContextAvailable();
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                System.err.println("Catched Exception while EGL Shared Resource initialization");
                gLException.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateEGLSharedResource(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.getDevice();
        }
        return null;
    }

    public boolean isANGLE() {
        return isANGLE;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        if (2 == n) {
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == eglES1DynamicLookupHelper && null == eglES2DynamicLookupHelper) {
            return new ArrayList<GLCapabilitiesImmutable>();
        }
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLOnscreenDrawable(this, EGLDrawableFactory.getEGLSurface(nativeSurface));
    }

    protected static NativeSurface getEGLSurface(NativeSurface nativeSurface) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice && abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
            if (DEBUG) {
                System.err.println(EGLDrawableFactory.getThreadName() + ": getEGLSurface - already in EGL format - use as-is: " + abstractGraphicsConfiguration);
            }
            return nativeSurface;
        }
        EGLGraphicsDevice eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(nativeSurface, true);
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
        if (abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
            EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities();
            if (0L == eGLGLCapabilities.getEGLConfig()) {
                eGLGLCapabilities.setEGLConfig(EGLGraphicsConfiguration.EGLConfigId2EGLConfig(eGLGraphicsDevice.getHandle(), eGLGLCapabilities.getEGLConfigID()));
                if (0L == eGLGLCapabilities.getEGLConfig()) {
                    throw new GLException("Refreshing native EGLConfig handle failed: " + eGLGLCapabilities + " of " + abstractGraphicsConfiguration);
                }
            }
            eGLGraphicsConfiguration = new EGLGraphicsConfiguration(defaultGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, null);
            if (DEBUG) {
                System.err.println(EGLDrawableFactory.getThreadName() + ": getEGLSurface - Reusing chosenCaps: " + eGLGraphicsConfiguration);
            }
        } else {
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, defaultGraphicsScreen, abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE), false);
            if (null == eGLGraphicsConfiguration) {
                throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
            }
            if (DEBUG) {
                System.err.println(EGLDrawableFactory.getThreadName() + ": getEGLSurface - Chosen eglConfig: " + eGLGraphicsConfiguration);
            }
        }
        return new WrappedSurface(eGLGraphicsConfiguration, 0L, nativeSurface.getWidth(), nativeSurface.getHeight(), new EGLUpstreamSurfaceHook(nativeSurface));
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLPbufferDrawable(this, nativeSurface);
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice;
        Cloneable cloneable;
        if (bl) {
            cloneable = (EGLGraphicsDevice)abstractGraphicsDevice;
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(cloneable.getNativeDisplayID(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        } else {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        }
        cloneable = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, (AbstractGraphicsScreen)cloneable, 0, false);
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + cloneable);
        }
        return new WrappedSurface(eGLGraphicsConfiguration, 0L, n, n2, upstreamSurfaceHook);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, false, this.canCreateGLPbuffer(abstractGraphicsDevice));
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2, dummySurfaceLifecycleHook);
    }

    protected static MutableSurface createPBufferSurfaceImpl(MutableSurface mutableSurface, boolean bl) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)mutableSurface.getGraphicsConfiguration();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        int n = bl ? (gLCapabilitiesImmutable.getAlphaBits() > 0 ? 12382 : 12381) : 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + eGLGraphicsConfiguration);
        }
        int[] nArray = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(mutableSurface.getWidth(), mutableSurface.getHeight(), n);
        long l = EGL.eglCreatePbufferSurface(eGLGraphicsDevice.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), nArray, 0);
        if (0L == l) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + mutableSurface.getWidth() + "x" + mutableSurface.getHeight() + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l));
        }
        mutableSurface.setSurfaceHandle(l);
        return mutableSurface;
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, n);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        return new WrappedSurface(eGLGraphicsConfiguration, l, 0, 0, upstreamSurfaceHook);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault("EGL");
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    @Override
    public boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    static class SharedResource {
        private final EGLGraphicsDevice device;
        private final boolean wasES1ContextCreated;
        private final boolean wasES2ContextCreated;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, boolean bl2) {
            this.device = eGLGraphicsDevice;
            this.wasES1ContextCreated = bl;
            this.wasES2ContextCreated = bl2;
        }

        final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        final boolean wasES1ContextAvailable() {
            return this.wasES1ContextCreated;
        }

        final boolean wasES2ContextAvailable() {
            return this.wasES2ContextCreated;
        }
    }
}

