/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.WrappedSurface;
import com.jogamp.nativewindow.macosx.MacOSXGraphicsDevice;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLDynamicLibraryBundleInfo;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfiguration;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfigurationFactory;
import jogamp.opengl.macosx.cgl.MacOSXExternalCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXOffscreenCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXOnscreenCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXPbufferCGLDrawable;

public class MacOSXCGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static DesktopGLDynamicLookupHelper macOSXCGLDynamicLookupHelper = null;
    private HashMap<String, SharedResource> sharedMap = new HashMap();
    private MacOSXGraphicsDevice defaultDevice;
    private HashSet<String> devicesTried = new HashSet();
    private static final ProxySurface.UpstreamSurfaceHook dummySurfaceLifecycleHook = new ProxySurface.UpstreamSurfaceHook(){
        long nsWindow = 0L;

        @Override
        public final void create(ProxySurface proxySurface) {
            if (0L == this.nsWindow && 0L == proxySurface.getSurfaceHandle()) {
                this.nsWindow = OSXUtil.CreateNSWindow(0, 0, proxySurface.getWidth(), proxySurface.getHeight());
                if (0L == this.nsWindow) {
                    throw new GLException("Error NS window 0");
                }
                long l = OSXUtil.GetNSView(this.nsWindow);
                if (0L == l) {
                    throw new GLException("Error NS view 0");
                }
                proxySurface.setSurfaceHandle(l);
                proxySurface.setImplBitfield(256);
                if (DEBUG) {
                    System.err.println("MacOSXCGLDrawableFactory.dummySurfaceLifecycleHook.create: " + proxySurface);
                }
            }
        }

        @Override
        public final void destroy(ProxySurface proxySurface) {
            if (0L != this.nsWindow && 0L != proxySurface.getSurfaceHandle()) {
                OSXUtil.DestroyNSWindow(this.nsWindow);
                this.nsWindow = 0L;
                proxySurface.setSurfaceHandle(0L);
                if (DEBUG) {
                    System.err.println("MacOSXCGLDrawableFactory.dummySurfaceLifecycleHook.destroy: " + proxySurface);
                }
            }
        }

        @Override
        public final int getWidth(ProxySurface proxySurface) {
            return proxySurface.initialWidth;
        }

        @Override
        public final int getHeight(ProxySurface proxySurface) {
            return proxySurface.initialHeight;
        }

        public String toString() {
            return "MacOSXLSurfaceLifecycleHook[]";
        }
    };
    private static final int GAMMA_RAMP_LENGTH = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacOSXCGLDrawableFactory() {
        Class<MacOSXCGLDrawableFactory> clazz = MacOSXCGLDrawableFactory.class;
        synchronized (MacOSXCGLDrawableFactory.class) {
            if (null == macOSXCGLDynamicLookupHelper) {
                DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
                block11: {
                    desktopGLDynamicLookupHelper = null;
                    try {
                        desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new MacOSXCGLDynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block11;
                        gLException.printStackTrace();
                    }
                }
                if (null != desktopGLDynamicLookupHelper && desktopGLDynamicLookupHelper.isLibComplete()) {
                    macOSXCGLDynamicLookupHelper = desktopGLDynamicLookupHelper;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.defaultDevice = new MacOSXGraphicsDevice(0);
            if (null != macOSXCGLDynamicLookupHelper) {
                MacOSXCGLGraphicsConfigurationFactory.registerFactory();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        ReflectionUtil.callStaticMethod((String)"jogamp.opengl.macosx.cgl.awt.MacOSXAWTCGLGraphicsConfigurationFactory", (String)"registerFactory", null, null, (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (JogampRuntimeException jogampRuntimeException) {
                        // empty catch block
                    }
                }
                this.sharedMap = new HashMap();
            }
            return;
        }
    }

    @Override
    protected final void destroy(GLProfile.ShutdownType shutdownType) {
        if (null != this.sharedMap) {
            this.sharedMap.clear();
            this.sharedMap = null;
        }
        this.defaultDevice = null;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        return macOSXCGLDynamicLookupHelper;
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != macOSXCGLDynamicLookupHelper && abstractGraphicsDevice instanceof MacOSXGraphicsDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDeviceTried(String string) {
        HashSet<String> hashSet = this.devicesTried;
        synchronized (hashSet) {
            return this.devicesTried.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceTried(String string) {
        HashSet<String> hashSet = this.devicesTried;
        synchronized (hashSet) {
            this.devicesTried.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceTried(String string) {
        HashSet<String> hashSet = this.devicesTried;
        synchronized (hashSet) {
            this.devicesTried.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedResource getOrCreateOSXSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource;
        String string = abstractGraphicsDevice.getConnection();
        Cloneable cloneable = this.sharedMap;
        synchronized (cloneable) {
            sharedResource = this.sharedMap.get(string);
        }
        if (null == sharedResource && !this.getDeviceTried(string)) {
            this.addDeviceTried(string);
            cloneable = new MacOSXGraphicsDevice(abstractGraphicsDevice.getUnitID());
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            Object object = GLProfile.get(cloneable, GLProfile.GL_PROFILE_LIST_MIN_DESKTOP, false);
            if (null == object) {
                throw new GLException("Couldn't get default GLProfile for device: " + cloneable);
            }
            GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(this.createDummySurfaceImpl((AbstractGraphicsDevice)cloneable, false, new GLCapabilities((GLProfile)object), null, 64, 64));
            gLDrawableImpl.setRealized(true);
            GLContextImpl gLContextImpl = (GLContextImpl)gLDrawableImpl.createContext(null);
            if (null == gLContextImpl) {
                throw new GLException("Couldn't create shared context for drawable: " + gLDrawableImpl);
            }
            try {
                gLContextImpl.makeCurrent();
                bl = gLContextImpl.isCurrent();
                if (bl) {
                    GL gL = gLContextImpl.getGL();
                    bl2 = gL.isNPOTTextureAvailable();
                    bl3 = gL.isExtensionAvailable("GL_EXT_texture_rectangle");
                    bl4 = gL.isExtensionAvailable("GL_APPLE_float_pixels");
                }
            }
            catch (GLException gLException) {
                if (DEBUG) {
                    System.err.println("MacOSXCGLDrawableFactory.createShared: INFO: makeCurrent catched exception:");
                    gLException.printStackTrace();
                }
            }
            finally {
                block24: {
                    try {
                        gLContextImpl.destroy();
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block24;
                        System.err.println("MacOSXCGLDrawableFactory.createShared: INFO: destroy catched exception:");
                        gLException.printStackTrace();
                    }
                }
            }
            gLDrawableImpl.setRealized(false);
            sharedResource = new SharedResource((MacOSXGraphicsDevice)cloneable, bl, bl2, bl3, bl4);
            object = this.sharedMap;
            synchronized (object) {
                this.sharedMap.put(string, sharedResource);
            }
            this.removeDeviceTried(string);
            if (DEBUG) {
                System.err.println("MacOSXCGLDrawableFactory.createShared: device:  " + cloneable);
                System.err.println("MacOSXCGLDrawableFactory.createShared: context: madeCurrent " + bl + ", NPOT " + bl2 + ", RECT " + bl3 + ", FloatPixels " + bl4);
            }
        }
        return sharedResource;
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return null;
    }

    @Override
    protected final boolean createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        block3: {
            try {
                SharedResource sharedResource = this.getOrCreateOSXSharedResource(abstractGraphicsDevice);
                if (null != sharedResource) {
                    return sharedResource.wasContextAvailable();
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                System.err.println("Catched Exception while MaxOSXCGL Shared Resource initialization:");
                gLException.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateOSXSharedResource(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.getDevice();
        }
        return null;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return MacOSXCGLGraphicsConfiguration.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new MacOSXOnscreenCGLDrawable(this, nativeSurface);
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return new MacOSXOffscreenCGLDrawable(this, nativeSurface);
        }
        return new MacOSXPbufferCGLDrawable(this, nativeSurface);
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        MacOSXGraphicsDevice macOSXGraphicsDevice = bl ? new MacOSXGraphicsDevice(abstractGraphicsDevice.getUnitID()) : (MacOSXGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(macOSXGraphicsDevice, 0);
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = MacOSXCGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen, true);
        if (null == macOSXCGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new WrappedSurface(macOSXCGLGraphicsConfiguration, 0L, n, n2, upstreamSurfaceHook);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2, dummySurfaceLifecycleHook);
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        MacOSXGraphicsDevice macOSXGraphicsDevice = new MacOSXGraphicsDevice(abstractGraphicsDevice.getUnitID());
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(macOSXGraphicsDevice, n);
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = MacOSXCGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, true);
        return new WrappedSurface(macOSXCGLGraphicsConfiguration, l, 0, 0, upstreamSurfaceHook);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        return MacOSXExternalCGLContext.create(this);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    @Override
    public boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("not supported in non AWT enviroment");
    }

    @Override
    protected int getGammaRampLength() {
        return 256;
    }

    @Override
    protected boolean setGammaRamp(float[] fArray) {
        return CGL.setGammaRamp(fArray.length, fArray, 0, fArray, 0, fArray, 0);
    }

    @Override
    protected Buffer getGammaRamp() {
        return null;
    }

    @Override
    protected void resetGammaRamp(Buffer buffer) {
        CGL.resetGammaRamp();
    }

    static class SharedResource {
        MacOSXGraphicsDevice device;
        boolean wasContextCreated;
        boolean hasNPOTTextures;
        boolean hasRECTTextures;
        boolean hasAppleFloatPixels;

        SharedResource(MacOSXGraphicsDevice macOSXGraphicsDevice, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.device = macOSXGraphicsDevice;
            this.wasContextCreated = bl;
            this.hasNPOTTextures = bl2;
            this.hasRECTTextures = bl3;
            this.hasAppleFloatPixels = bl4;
        }

        final MacOSXGraphicsDevice getDevice() {
            return this.device;
        }

        final boolean wasContextAvailable() {
            return this.wasContextCreated;
        }

        final boolean isNPOTTextureAvailable() {
            return this.hasNPOTTextures;
        }

        final boolean isRECTTextureAvailable() {
            return this.hasRECTTextures;
        }

        final boolean isAppleFloatPixelsAvailable() {
            return this.hasAppleFloatPixels;
        }
    }
}

