/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.webupdate;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.IPlanSelection;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.system.btn.SystemsSelectionAction;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Remote Plan Control", author="Paulo Dias", version="0.1")
public class RemotePlanControl
extends ConsolePanel
implements ConfigurationListener,
MainVehicleChangeListener,
LockableSubPanel,
IPeriodicUpdates,
NeptusMessageListener {
    private static final long serialVersionUID = 1L;
    private final ImageIcon ICON_UP = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/up.png");
    private final ImageIcon ICON_START = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/start.png");
    private final ImageIcon ICON_STOP = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/stop.png");
    @NeptusProperty(name="Publish web address")
    public String pubURL = "http://whale.fe.up.pt/neptleaves/";
    @NeptusProperty(name="Font Size Multiplier", description="The font size. Use '1' for default.")
    public int fontMultiplier = 1;
    @NeptusProperty(name="Verify plans for island nodes", description="Always runs a verification on the plan for maneuvers that have no input edges. If you choose to switch off here you can allways click Alt whan sending the plan that this verification will run.")
    public boolean allwaysVerifyAllManeuversUsed = true;
    private DefaultHttpClient client;
    private PoolingClientConnectionManager httpConnectionManager;
    private JXPanel holder;
    private JLabel titleLabel;
    private JXLabel planIdLabel;
    private Font planIdLabelFont;
    private ToolbarButton sendUploadPlanButton;
    private ToolbarButton sendStartButton;
    private ToolbarButton sendStopButton;
    private AbstractAction sendUploadPlanAction;
    private AbstractAction sendStartAction;
    private AbstractAction sendStopAction;
    private boolean locked = false;
    private Integer requestId = 65535;
    private LinkedHashMap<Integer, Long> registerRequestIdsTime = new LinkedHashMap();
    private String[] messagesToObserve = new String[]{"PlanControl", "PlanControlState"};
    private short requestsCleanupFlag = 0;

    public RemotePlanControl(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    public String[] getObservedMessages() {
        return this.messagesToObserve;
    }

    private void initialize() {
        this.initializeComm();
        this.initializeActions();
        this.removeAll();
        this.setSize(new Dimension(255, 60));
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(PluginUtils.getPluginName(((Object)((Object)this)).getClass()));
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.add(this.titleLabel, "North");
        this.holder = new JXPanel();
        this.holder.setLayout((LayoutManager)new BoxLayout((Container)this.holder, 2));
        this.add((Component)this.holder, "Center");
        this.planIdLabel = new JXLabel("");
        this.planIdLabelFont = this.planIdLabel.getFont();
        this.planIdLabel.setFont(this.planIdLabelFont.deriveFont((float)(this.planIdLabelFont.getSize() * this.fontMultiplier)));
        this.add((Component)this.planIdLabel, "South");
        this.holder.setOpaque(false);
        this.setBackground(new Color(255, 255, 110));
        this.sendUploadPlanButton = new ToolbarButton(this.sendUploadPlanAction);
        this.sendStartButton = new ToolbarButton(this.sendStartAction);
        this.sendStartButton.setActionCommand("Start Plan");
        this.sendStopButton = new ToolbarButton(this.sendStopAction);
        this.sendStopButton.setActionCommand("Stop Plan");
        this.holder.add((Component)this.sendUploadPlanButton);
        this.holder.add((Component)this.sendStartButton);
        this.holder.add((Component)this.sendStopButton);
    }

    private void initializeComm() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this.httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.httpConnectionManager.setMaxTotal(4);
        this.httpConnectionManager.setDefaultMaxPerRoute(50);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.httpConnectionManager, (HttpParams)params);
        ProxyInfoProvider.setRoutePlanner((AbstractHttpClient)this.client);
    }

    private void initializeActions() {
        this.sendUploadPlanAction = new AbstractAction("Send Selected Plan", this.ICON_UP){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(final ActionEvent ev) {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        RemotePlanControl.this.sendUploadPlanButton.setEnabled(false);
                        boolean verifyAllManeuversUsed = false;
                        if (RemotePlanControl.this.allwaysVerifyAllManeuversUsed || (ev.getModifiers() & 8) == 8) {
                            verifyAllManeuversUsed = true;
                        }
                        RemotePlanControl.this.sendPlan(verifyAllManeuversUsed, RemotePlanControl.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption((ActionEvent)ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        RemotePlanControl.this.sendUploadPlanButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendStartAction = new AbstractAction("Start Plan", this.ICON_START){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(final ActionEvent ev) {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        RemotePlanControl.this.sendStartButton.setEnabled(false);
                        RemotePlanControl.this.sendStartStop(0, RemotePlanControl.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption((ActionEvent)ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        RemotePlanControl.this.sendStartButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendStopAction = new AbstractAction("Stop Plan", this.ICON_STOP){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(final ActionEvent ev) {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        RemotePlanControl.this.sendStopButton.setEnabled(false);
                        RemotePlanControl.this.sendStartStop(1, RemotePlanControl.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption((ActionEvent)ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        RemotePlanControl.this.sendStopButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextRequestId() {
        Integer n = this.requestId;
        synchronized (n) {
            this.requestId = this.requestId + 1;
            if (this.requestId > 65535) {
                this.requestId = 0;
            }
            if (this.requestId < 0) {
                this.requestId = 0;
            }
            return this.requestId;
        }
    }

    public void propertiesChanged() {
        if (this.fontMultiplier < 1) {
            return;
        }
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.planIdLabel.setFont(this.planIdLabelFont.deriveFont((float)(this.planIdLabelFont.getSize() * this.fontMultiplier)));
        this.revalidate();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.update();
        this.refreshUI();
    }

    private void refreshUI() {
        boolean bEnable = true;
        if (this.isLocked()) {
            bEnable = false;
        }
        if (bEnable != this.sendUploadPlanButton.isEnabled()) {
            for (Component comp : this.holder.getComponents()) {
                comp.setEnabled(bEnable);
            }
        }
    }

    public void lock() {
        this.locked = true;
        this.refreshUI();
    }

    public void unLock() {
        this.locked = false;
        this.refreshUI();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public long millisBetweenUpdates() {
        return 5000L;
    }

    public boolean update() {
        ImcSystem tmp = ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId());
        if (tmp != null) {
            this.refreshUI();
        }
        this.requestsCleanupFlag = (short)(this.requestsCleanupFlag + 1);
        if (this.requestsCleanupFlag > 20) {
            this.requestsCleanupFlag = 0;
            try {
                for (Integer key : this.registerRequestIdsTime.keySet()) {
                    if (System.currentTimeMillis() - this.registerRequestIdsTime.get(key) <= 10000L) continue;
                    this.registerRequestIdsTime.remove(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String[] getSystemsToSendTo(boolean clearSelection) {
        return new String[]{this.getMainVehicleId()};
    }

    private boolean sendPlan(boolean verifyAllManeuversUsed, String ... systems) {
        if (!this.checkConditionToRun((Component)((Object)this), true, true)) {
            return false;
        }
        PlanType[] plans = this.getSelectedPlansFromExternalComponents();
        PlanType plan = plans[0];
        try {
            if (verifyAllManeuversUsed) {
                plan.validatePlan();
            }
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
            return false;
        }
        IMCMessage planSpecificationMessage = this.getPlanAsSpecification(plan);
        if (planSpecificationMessage == null) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Send Plan", (String)"Error sending plan message!\nNo plan spec. valid!");
        }
        IMCMessage planControlMessage = IMCDefinition.getInstance().create("PlanControl", new Object[0]);
        planControlMessage.setValue("type", (Object)0);
        planControlMessage.setValue("op", (Object)"LOAD");
        int reqId = this.getNextRequestId();
        planControlMessage.setValue("request_id", (Object)reqId);
        planControlMessage.setValue("plan_id", (Object)plan.getId());
        planControlMessage.setValue("arg", (Object)planSpecificationMessage);
        planControlMessage.setValue("info", (Object)"");
        planSpecificationMessage = planSpecificationMessage.cloneMessage();
        boolean ret = this.sendTheMessage(planSpecificationMessage, "Error sending plan", systems);
        if (!ret) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Send Plan Spec", (String)"Error sending PlanSpecification message!");
            return false;
        }
        ret = this.sendTheMessage(planControlMessage, "Error sending plan", systems);
        if (!ret) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Send Plan", (String)"Error sending PlanControl message!");
            return false;
        }
        this.registerPlanControlRequest(reqId);
        String missionlog = GuiUtils.getLogFileName((String)"mission_state", (String)"zip");
        this.getConsole().getMission().asZipFile(missionlog, true);
        return true;
    }

    private boolean sendStartStop(int cmd, String ... systems) {
        if (!this.checkConditionToRun((Component)((Object)this), true, true)) {
            return false;
        }
        IMCMessage planControlMessage = IMCDefinition.getInstance().create("PlanControl", new Object[0]);
        planControlMessage.setValue("type", (Object)0);
        int reqId = this.getNextRequestId();
        planControlMessage.setValue("request_id", (Object)reqId);
        String opEnumerated = planControlMessage.getString("op");
        String cmdStrMsg = "Error ";
        try {
            switch (cmd) {
                case 0: {
                    cmdStrMsg = cmdStrMsg + "sending start plan";
                    try {
                        opEnumerated = "START";
                    }
                    catch (Exception ex) {
                        NeptusLog.pub().error((Object)this, (Throwable)ex);
                        return false;
                    }
                    PlanType[] plans = this.getSelectedPlansFromExternalComponents();
                    PlanType plan = plans[0];
                    planControlMessage.setValue("plan_id", (Object)plan.getId());
                    LinkedHashMap flagsBitmask = planControlMessage.getBitmask("flags");
                    try {
                        flagsBitmask.put("CALIBRATE", true);
                    }
                    catch (Exception ex) {
                        NeptusLog.pub().error((Object)this, (Throwable)ex);
                        return false;
                    }
                    planControlMessage.setValue("flags", (Object)flagsBitmask);
                    break;
                }
                case 1: {
                    cmdStrMsg = cmdStrMsg + "sending stopping plan";
                    try {
                        opEnumerated = "STOP";
                        break;
                    }
                    catch (Exception ex) {
                        NeptusLog.pub().error((Object)this, (Throwable)ex);
                        return false;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        planControlMessage.setValue("op", (Object)opEnumerated);
        boolean ret = this.sendTheMessage(planControlMessage, cmdStrMsg, systems);
        if (!ret) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Send Plan", (String)"Error sending PlanControl message!");
            return false;
        }
        this.registerPlanControlRequest(reqId);
        return true;
    }

    private void registerPlanControlRequest(int reqId) {
        this.registerRequestIdsTime.put(reqId, System.currentTimeMillis());
    }

    private IMCMessage getPlanAsSpecification(PlanType plan) {
        if (plan == null || !(plan instanceof PlanType)) {
            return null;
        }
        PlanType iPlan = plan;
        IMCMessage msgPlanSpecification = iPlan.asIMCPlan();
        return msgPlanSpecification;
    }

    protected boolean checkConditionToRun(Component component, boolean checkMission, boolean checkPlan) {
        PlanType[] plans;
        MissionType miss;
        if (!ImcMsgManager.getManager().isRunning()) {
            GuiUtils.errorMessage((Component)((Object)this), (String)component.getName(), (String)"IMC comms. are not running!");
            return false;
        }
        ConsoleLayout cons = this.getConsole();
        if (cons == null) {
            GuiUtils.errorMessage((Component)((Object)this), (String)component.getName(), (String)"Missing console attached!");
            return false;
        }
        if (checkMission && (miss = cons.getMission()) == null) {
            GuiUtils.errorMessage((Component)((Object)this), (String)component.getName(), (String)"Missing attached mission!");
            return false;
        }
        if (checkPlan && ((plans = this.getSelectedPlansFromExternalComponents()) == null || plans.length == 0)) {
            GuiUtils.errorMessage((Component)((Object)this), (String)component.getName(), (String)"Missing attached plan!");
            return false;
        }
        return true;
    }

    private PlanType[] getSelectedPlansFromExternalComponents() {
        if (this.getConsole() == null) {
            return new PlanType[0];
        }
        Vector psel = this.getConsole().getSubPanelsOfInterface(IPlanSelection.class);
        if (psel.size() == 0) {
            if (this.getConsole().getPlan() != null) {
                return new PlanType[]{this.getConsole().getPlan()};
            }
            return new PlanType[0];
        }
        return ((IPlanSelection)psel.get(0)).getSelectedPlans().toArray(new PlanType[0]);
    }

    private boolean sendTheMessage(IMCMessage msg, String errorTextForDialog, String ... ids) {
        return this.sendTheMessage(msg, errorTextForDialog, false, ids);
    }

    private boolean sendTheMessage(IMCMessage msg, String errorTextForDialog, boolean ignoreIfActive, String ... ids) {
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        boolean retAll = true;
        for (String sid : ids) {
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)sid);
            if (sys == null) continue;
            msg.getHeader().setValue("src", (Object)ImcMsgManager.getManager().getLocalId());
            msg.getHeader().setValue("dst", (Object)sys.getId());
            msgs.add(msg);
        }
        retAll = this.postMessages(msgs);
        if (!retAll) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Send Plan Control Message", (String)errorTextForDialog);
        }
        return retAll;
    }

    protected IMCMessage getPlanAsSpecification() {
        if (!this.checkConditionToRun((Component)((Object)this), true, true)) {
            return null;
        }
        ConsoleLayout cons = this.getConsole();
        PlanType plan = cons.getPlan();
        if (!(plan instanceof PlanType)) {
            return null;
        }
        PlanType iPlan = plan;
        return iPlan.asIMCPlan();
    }

    public void messageArrived(IMCMessage message) {
        if (!"PlanControlState".equalsIgnoreCase(message.getAbbrev()) && "PlanControl".equalsIgnoreCase(message.getAbbrev())) {
            try {
                int reqId;
                Integer typeId = message.getInteger("type");
                String typeName = message.getString("type");
                if (typeId != 0 && this.registerRequestIdsTime.containsKey(reqId = Integer.valueOf(message.getAsNumber("request_id").intValue()).intValue())) {
                    boolean cleanReg = false;
                    if ("SUCCESS".equalsIgnoreCase(typeName)) {
                        cleanReg = true;
                    } else if ("FAILURE".equalsIgnoreCase(typeName)) {
                        cleanReg = true;
                    }
                    if (cleanReg) {
                        this.registerRequestIdsTime.remove(reqId);
                    }
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postMessages(Collection<IMCMessage> messages) {
        HttpPost post = null;
        try {
            String uri = this.pubURL + "imc/";
            post = new HttpPost(uri);
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            for (IMCMessage msg : messages) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
                msg.serialize(ios);
                pos.write(baos.toByteArray());
            }
            pos.flush();
            pos.close();
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)pis, -1L);
            reqEntity.setContentType("application/lsf");
            reqEntity.setChunked(true);
            post.setEntity((HttpEntity)reqEntity);
            BasicHttpContext localContext = new BasicHttpContext();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)post, (HttpContext)localContext);
            ProxyInfoProvider.authenticateConnectionIfNeeded((HttpResponse)iGetResultCode, (HttpContext)localContext, (DefaultHttpClient)this.client);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>[" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (post != null) {
                    post.abort();
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (post != null) {
                post.abort();
                post = null;
            }
        }
        return true;
    }

    public void cleanSubPanel() {
        if (this.client != null) {
            // empty if block
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    public void initSubPanel() {
    }
}

