/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.webupdate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Document;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.SystemImcMsgCommInfo;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.plugins.CheckMenuChangeListener;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.webupdate.RemotePositionHelper;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StreamUtil;

@PluginDescription(name="Remote Position Fetcher Updater", author="Paulo Dias", version="0.2", icon="pt/lsts/neptus/plugins/webupdate/webupdate-fetch-on.png")
@LayerPriority(priority=178)
public class RemotePositionFetcherUpdater
extends ConsolePanel
implements IPeriodicUpdates,
ConfigurationListener,
Renderer2DPainter,
SubPanelChangeListener {
    private final ImageIcon ICON_ENABLE = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/webupdate/webupdate-fetch-on.png", (int)32, (int)32);
    private final ImageIcon ICON_DISABLE = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/webupdate/webupdate-fetch-off.png", (int)32, (int)32);
    private final Color LIGHT_ORCHID = new Color(255, 161, 255);
    @NeptusProperty(name="Publish web address")
    public String pubURL = "http://whale.fe.up.pt/neptleaves/";
    @NeptusProperty(name="Update period (ms)", description="The period to fetch the systems' positions. Zero means disconnected.")
    public int updatePeriodMillis = 1000;
    @NeptusProperty
    public boolean fetchOn = false;
    @NeptusProperty(description="If true will paint the web fetch postion in the render.")
    public boolean showSystem = true;
    @NeptusProperty(description="If true will write age of data and depth on the render.")
    public boolean infoExtended = true;
    @NeptusProperty(description="if true will also retreive remote messages from server.")
    public boolean publishWebReceivedMessages = true;
    @NeptusProperty(name="Seconds to display ranges")
    public int secondsToDisplayRanges = 5;
    @NeptusProperty
    public boolean publishRemoteSystemsLocally = true;
    @NeptusProperty(category="Advanced")
    public boolean debugOn = false;
    private JCheckBoxMenuItem publishCheckItem = null;
    private long lastFetchPosTimeMillis = System.currentTimeMillis();
    private Vector<ILayerPainter> renderers = new Vector();
    private static GeneralPath arrowShape = null;
    private DefaultHttpClient client;
    private PoolingClientConnectionManager httpConnectionManager;
    private HttpGet getHttpRequestState;
    private HttpGet getHttpRequestImcMsgs;
    private Timer timer = null;
    private TimerTask ttask = null;
    private final LinkedHashMap<String, Long> timeSysList = new LinkedHashMap();
    private final LinkedHashMap<String, CoordinateSystem> locSysList = new LinkedHashMap();
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private ToolbarButton sendEnableDisableButton;

    public RemotePositionFetcherUpdater(ConsoleLayout console) {
        super(console);
        this.docBuilderFactory.setIgnoringComments(true);
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.docBuilderFactory.setNamespaceAware(false);
        this.initializeComm();
        this.initialize();
    }

    public void initSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.publishCheckItem = this.addCheckMenuItem(I18n.text((String)"Settings") + ">" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Start/Stop", null, new CheckMenuChangeListener(){

            public void menuUnchecked(ActionEvent e) {
                RemotePositionFetcherUpdater.this.fetchOn = false;
            }

            public void menuChecked(ActionEvent e) {
                RemotePositionFetcherUpdater.this.fetchOn = true;
            }
        });
        this.addMenuItem(I18n.text((String)"Settings") + ">" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)RemotePositionFetcherUpdater.this, (Frame)RemotePositionFetcherUpdater.this.getConsole(), (boolean)true);
            }
        });
        this.publishCheckItem.setState(this.fetchOn);
    }

    private void initialize() {
        this.removeAll();
        this.setBackground(new Color(255, 255, 110));
        this.sendEnableDisableButton = new ToolbarButton(new AbstractAction("Fetch on", this.ICON_ENABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String cmd = e.getActionCommand();
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        RemotePositionFetcherUpdater.this.sendEnableDisableButton.setEnabled(false);
                        if ("Fetch on".equalsIgnoreCase(cmd)) {
                            RemotePositionFetcherUpdater.this.fetchOn = true;
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.setActionCommand("Fetch off");
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.getAction().putValue("SmallIcon", RemotePositionFetcherUpdater.this.ICON_DISABLE);
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Fetch off");
                        } else if ("Fetch off".equalsIgnoreCase(cmd)) {
                            RemotePositionFetcherUpdater.this.fetchOn = false;
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.setActionCommand("Fetch on");
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.getAction().putValue("SmallIcon", RemotePositionFetcherUpdater.this.ICON_ENABLE);
                            RemotePositionFetcherUpdater.this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Fetch on");
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        RemotePositionFetcherUpdater.this.sendEnableDisableButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.sendEnableDisableButton.setActionCommand("Fetch on");
        this.add((Component)this.sendEnableDisableButton);
        this.timer = new Timer("RemotePositionFetcher");
        this.ttask = this.getTimerTask();
        this.timer.scheduleAtFixedRate(this.ttask, 500L, (long)this.updatePeriodMillis);
    }

    private void initializeComm() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this.httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.httpConnectionManager.setMaxTotal(4);
        this.httpConnectionManager.setDefaultMaxPerRoute(50);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.httpConnectionManager, (HttpParams)params);
        ProxyInfoProvider.setRoutePlanner((AbstractHttpClient)this.client);
    }

    private void refreshUI() {
        if (this.fetchOn && "Fetch on".equalsIgnoreCase(this.sendEnableDisableButton.getActionCommand())) {
            this.sendEnableDisableButton.setActionCommand("Fetch off");
            this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_DISABLE);
            this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Fetch off");
        } else if (!this.fetchOn && !"Fetch on".equalsIgnoreCase(this.sendEnableDisableButton.getActionCommand())) {
            this.sendEnableDisableButton.setActionCommand("Fetch on");
            this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_ENABLE);
            this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Fetch on");
        }
    }

    private TimerTask getTimerTask() {
        if (this.ttask == null) {
            this.ttask = new TimerTask(){

                @Override
                public void run() {
                    if (!RemotePositionFetcherUpdater.this.fetchOn) {
                        return;
                    }
                    RemotePositionFetcherUpdater.this.getStateRemoteData();
                    RemotePositionFetcherUpdater.this.getRemoteImcData();
                }
            };
        }
        return this.ttask;
    }

    public long millisBetweenUpdates() {
        return 500L;
    }

    public boolean update() {
        this.refreshUI();
        if (this.publishCheckItem != null) {
            this.publishCheckItem.setState(this.fetchOn);
        }
        if (!this.fetchOn) {
            this.abortAllActiveConnections();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStateRemoteData() {
        if (this.getHttpRequestState != null) {
            this.getHttpRequestState.abort();
        }
        this.getHttpRequestState = null;
        try {
            String endpoint = this.pubURL;
            String uri = endpoint + "state/state.xml";
            this.getHttpRequestState = new HttpGet(uri);
            BasicHttpContext localContext = new BasicHttpContext();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.getHttpRequestState, (HttpContext)localContext);
            ProxyInfoProvider.authenticateConnectionIfNeeded((HttpResponse)iGetResultCode, (HttpContext)localContext, (DefaultHttpClient)this.client);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>[" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.getHttpRequestState != null) {
                    this.getHttpRequestState.abort();
                }
                boolean bl = false;
                return bl;
            }
            InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            Document docProfiles = builder.parse(streamGetResponseBody);
            RemotePositionHelper.getRemoteState(this.timeSysList, this.locSysList, docProfiles);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (this.getHttpRequestState != null) {
                this.getHttpRequestState.abort();
                this.getHttpRequestState = null;
            }
        }
        this.processRemoteStates();
        return true;
    }

    private void processRemoteStates() {
        if (this.publishRemoteSystemsLocally) {
            RemotePositionHelper.publishRemoteStatesLocally(this.timeSysList, this.locSysList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRemoteImcData() {
        if (!this.publishWebReceivedMessages) {
            return true;
        }
        if (this.getHttpRequestImcMsgs != null) {
            this.getHttpRequestImcMsgs.abort();
        }
        this.getHttpRequestImcMsgs = null;
        long time = this.lastFetchPosTimeMillis <= 0L ? 0L : this.lastFetchPosTimeMillis;
        try {
            String endpoint = this.pubURL;
            String uri = endpoint + "imc?after=" + time;
            this.getHttpRequestImcMsgs = new HttpGet(uri);
            long reqTime = System.currentTimeMillis();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.getHttpRequestImcMsgs);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>[" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.getHttpRequestImcMsgs != null) {
                    this.getHttpRequestImcMsgs.abort();
                }
                boolean bl = false;
                return bl;
            }
            try {
                long serverTime;
                this.lastFetchPosTimeMillis = serverTime = Long.parseLong(iGetResultCode.getFirstHeader("server-time").getValue().trim());
            }
            catch (Exception e) {
                this.lastFetchPosTimeMillis = System.currentTimeMillis();
            }
            InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
            long fullSize = iGetResultCode.getEntity().getContentLength();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean streamRes = StreamUtil.copyStreamToStream((InputStream)streamGetResponseBody, (OutputStream)baos);
            byte[] baa = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(baa);
            IMCMessage[] msgs = IMCUtils.parseLsf((InputStream)bais);
            if (msgs.length > 0) {
                this.processWebMessages(msgs);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (this.getHttpRequestImcMsgs != null) {
                this.getHttpRequestImcMsgs.abort();
                this.getHttpRequestImcMsgs = null;
            }
        }
        return true;
    }

    private void processWebMessages(IMCMessage[] msgs) {
        if (this.publishWebReceivedMessages) {
            for (IMCMessage msg : msgs) {
                try {
                    SystemImcMsgCommInfo comm;
                    ImcId16 id = new ImcId16(msg.getHeader().getValue("src"));
                    if (!this.debugOn && !ImcId16.NULL_ID.equals((Object)ImcMsgManager.getManager().getLocalId()) && ImcMsgManager.getManager().getLocalId().equals((Object)id)) {
                        return;
                    }
                    MessageInfoImpl info = new MessageInfoImpl();
                    info.setTimeSentNanos((long)(msg.getHeader().getTimestamp() * 1.0E9));
                    info.setTimeReceivedNanos(this.lastFetchPosTimeMillis * 1000000L);
                    info.setProperty("NotToLogMessage", "true");
                    info.setProperty("Web Fetch", "true");
                    ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)id);
                    if (sys == null) {
                        if (id.intValue() < 16384 || id.intValue() >= 24575) continue;
                        this.processWebCCUMessage((MessageInfo)info, msg);
                        continue;
                    }
                    if (sys.isActive() || (comm = (SystemImcMsgCommInfo)ImcMsgManager.getManager().getCommInfoById((Object)sys.getId())) == null) continue;
                    comm.onMessage((MessageInfo)info, (IMessage)msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processWebCCUMessage(MessageInfo info, IMCMessage msg) {
        if ("PlanSpecification".equalsIgnoreCase(msg.getAbbrev())) {
            try {
                String planId = msg.getAsString("plan_id");
                ImcId16 imcId = null;
                try {
                    imcId = new ImcId16(msg.getHeaderValue("src"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String srcId = imcId == null ? msg.getHeaderValue("src").toString() : imcId.toString();
                int res = JOptionPane.showConfirmDialog((Component)this.getConsole(), "Plan with id '" + planId + "' just arrived from " + srcId + ". Want to accept it?", PluginUtils.getPluginName(((Object)((Object)this)).getClass()), 0);
                if (res != 0) {
                    return;
                }
                PlanType plan = IMCUtils.parsePlanSpecification((MissionType)this.getConsole().getMission(), (IMCMessage)msg);
                if (this.getConsole().getMission().getIndividualPlansList().containsKey(planId) && (res = JOptionPane.showConfirmDialog((Component)this.getConsole(), "Overwrite existing plan?", "Plan editor", 0)) != 0) {
                    return;
                }
                this.getConsole().getMission().getIndividualPlansList().put(planId, plan);
                new Thread(){

                    @Override
                    public void run() {
                        RemotePositionFetcherUpdater.this.getConsole().getMission().save(false);
                    }
                }.start();
                this.getConsole().updateMissionListeners();
                this.getConsole().setPlan(plan);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cleanSubPanel() {
        this.removeCheckMenuItem("Settings>" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Start/Stop");
        this.removeMenuItem("Settings>" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Settings");
        if (this.client != null) {
            // empty if block
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
        if (this.ttask != null) {
            this.ttask.cancel();
            this.ttask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timeSysList.clear();
        this.locSysList.clear();
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    private static GeneralPath getArrow() {
        if (arrowShape == null) {
            arrowShape = new GeneralPath();
            arrowShape.moveTo(-2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(8.0f, 0.0f);
            arrowShape.lineTo(0.0f, 8.0f);
            arrowShape.lineTo(-8.0f, 0.0f);
            arrowShape.lineTo(-2.0f, 0.0f);
            arrowShape.closePath();
        }
        return arrowShape;
    }

    public void propertiesChanged() {
        if (!this.pubURL.endsWith("/")) {
            this.pubURL = this.pubURL + "/";
        }
        this.abortAllActiveConnections();
        if (this.ttask != null) {
            this.ttask.cancel();
            this.ttask = null;
        }
        this.ttask = this.getTimerTask();
        this.timer.scheduleAtFixedRate(this.ttask, 500L, (long)this.updatePeriodMillis);
    }

    private void abortAllActiveConnections() {
        try {
            if (this.getHttpRequestState != null) {
                this.getHttpRequestState.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.getHttpRequestImcMsgs != null) {
                this.getHttpRequestImcMsgs.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)panelChange.getPanel();
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter((Renderer2DPainter)this, "GPS FIX");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter((Renderer2DPainter)this);
                }
            }
        }
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        if (this.fetchOn && this.showSystem) {
            if (this.timeSysList.size() == 0) {
                return;
            }
            for (String id : this.timeSysList.keySet().toArray(new String[0])) {
                Color colorIcon = this.LIGHT_ORCHID;
                double alfaPercentage = 1.0;
                long deltaTimeMillis = System.currentTimeMillis() - this.timeSysList.get(id);
                if (deltaTimeMillis > 300000L) {
                    alfaPercentage = 0.0;
                    continue;
                }
                if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 2.0) {
                    alfaPercentage = 0.5;
                } else if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 4.0) {
                    alfaPercentage = 0.7;
                }
                double rotationAngle = renderer.getRotation();
                CoordinateSystem lt = this.locSysList.get(id);
                Point2D centerPos = renderer.getScreenPosition(new LocationType((LocationType)lt));
                Color baseColor = new Color(173, 154, 79);
                Graphics2D g = (Graphics2D)g2.create();
                g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
                g.draw(new Ellipse2D.Double(centerPos.getX() - 10.0, centerPos.getY() - 10.0, 20.0, 20.0));
                g.setColor(ColorUtils.setTransparencyToColor((Color)this.LIGHT_ORCHID, (int)((int)(255.0 * alfaPercentage))));
                g.draw(new Ellipse2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0));
                g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
                g.draw(new Ellipse2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0));
                g.translate(centerPos.getX(), centerPos.getY());
                Color color = baseColor.darker();
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)((int)(200.0 * alfaPercentage))));
                g.fill(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
                color = new Color(139, 69, 19, 0).brighter();
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)((int)(150.0 * alfaPercentage))));
                g.setStroke(new BasicStroke(2.0f));
                g.draw(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
                g.setColor(new Color(0, 0, 0, (int)(150.0 * alfaPercentage)));
                g.fill(new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
                g.setColor(Color.BLACK);
                String strMsg = "Web: " + id;
                String strMsg2 = "";
                if (this.infoExtended) {
                    strMsg = strMsg + (deltaTimeMillis < 10000L ? "" : " :: age:" + DateTimeUtil.milliSecondsToFormatedString((long)deltaTimeMillis));
                    strMsg2 = strMsg2 + " > " + (lt.getAllZ() >= 0.0 ? "depth=" : "alt=") + MathMiscUtils.round((double)(lt.getAllZ() >= 0.0 ? lt.getAllZ() : -lt.getAllZ()), (int)1) + "m";
                }
                g.drawString(strMsg, 3, 27);
                g.drawString(strMsg2, 3, 41);
                g.setColor(this.LIGHT_ORCHID);
                g.drawString(strMsg, 2, 28);
                g.drawString(strMsg2, 2, 42);
                double newYaw = !Double.isNaN(lt.getYaw()) ? Math.toRadians(lt.getYaw()) : 0.0;
                GeneralPath shape = RemotePositionFetcherUpdater.getArrow();
                g.rotate(-rotationAngle);
                if (newYaw != 0.0) {
                    g.rotate(newYaw + Math.PI);
                }
                color = colorIcon;
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)((int)(150.0 * alfaPercentage))));
                g.setStroke(new BasicStroke(2.0f));
                g.fill(shape);
                color = color.darker();
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)((int)(150.0 * alfaPercentage))));
                g.draw(shape);
                g.setColor(Color.BLACK);
                if (newYaw != 0.0) {
                    g.rotate(-(newYaw + Math.PI));
                }
                g.rotate(rotationAngle);
                g.translate(-centerPos.getX(), -centerPos.getY());
            }
        }
    }
}

