/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.webupdate;

import java.util.Date;
import java.util.LinkedHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.XMLUtil;

class RemotePositionHelper {
    private RemotePositionHelper() {
    }

    public static long getRemoteState(LinkedHashMap<String, Long> timeSysList, LinkedHashMap<String, CoordinateSystem> locSysList, Document docProfiles) {
        long lastCalcPosTimeMillis = -1L;
        Element root = docProfiles.getDocumentElement();
        CoordinateSystem loc = null;
        double phi = Double.NaN;
        double theta = Double.NaN;
        double psi = Double.NaN;
        try {
            String dateS = root.getAttributes().getNamedItem("date").getTextContent();
            String timeS = root.getAttributes().getNamedItem("time").getTextContent();
            Date dateTimeS = DateTimeUtil.dateTimeFormaterUTC.parse(dateS + " " + timeS);
            lastCalcPosTimeMillis = dateTimeS.getTime();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            lastCalcPosTimeMillis = -1L;
        }
        for (Node bn = root.getFirstChild(); bn != null; bn = bn.getNextSibling()) {
            if (!"VehicleState".equalsIgnoreCase(bn.getNodeName())) continue;
            try {
                String id = bn.getAttributes().getNamedItem("id").getTextContent();
                String date = bn.getAttributes().getNamedItem("date").getTextContent();
                String time = bn.getAttributes().getNamedItem("time").getTextContent();
                Date dateTime = DateTimeUtil.dateTimeFormaterUTC.parse(date + " " + time);
                NodeList clst = bn.getChildNodes();
                for (int i = 0; i < clst.getLength(); ++i) {
                    Node node = clst.item(i);
                    if ("coordinate".equalsIgnoreCase(node.getNodeName())) {
                        String str = XMLUtil.nodeToString((Node)node);
                        loc = new CoordinateSystem(str);
                        continue;
                    }
                    if (!"attitude".equalsIgnoreCase(node.getNodeName())) continue;
                    try {
                        NodeList anode = node.getChildNodes();
                        for (int j = 0; j < anode.getLength(); ++j) {
                            String pName;
                            Node nodep = anode.item(j);
                            if ("phi".equalsIgnoreCase(nodep.getNodeName())) {
                                pName = nodep.getTextContent();
                                phi = Double.parseDouble(pName);
                                continue;
                            }
                            if ("theta".equalsIgnoreCase(nodep.getNodeName())) {
                                pName = nodep.getTextContent();
                                theta = Double.parseDouble(pName);
                                continue;
                            }
                            if (!"psi".equalsIgnoreCase(nodep.getNodeName())) continue;
                            pName = nodep.getTextContent();
                            psi = Double.parseDouble(pName);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
                        phi = Double.NaN;
                        theta = Double.NaN;
                        psi = Double.NaN;
                    }
                }
                if (loc != null && phi != Double.NaN && theta != Double.NaN && psi != Double.NaN) {
                    loc.setRoll(Math.toDegrees(phi));
                    loc.setPitch(Math.toDegrees(theta));
                    loc.setYaw(Math.toDegrees(psi));
                }
                timeSysList.put(id, dateTime.getTime());
                locSysList.put(id, loc);
                continue;
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            }
        }
        return lastCalcPosTimeMillis;
    }

    static void publishRemoteStatesLocally(LinkedHashMap<String, Long> timeSysList, LinkedHashMap<String, CoordinateSystem> locSysList) {
        try {
            String[] ids = timeSysList.keySet().toArray(new String[0]);
            Long[] timeMillis = timeSysList.values().toArray(new Long[0]);
            CoordinateSystem[] posAndAttitude = locSysList.values().toArray(new CoordinateSystem[0]);
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                long time = timeMillis[i];
                CoordinateSystem coordinateSystem = posAndAttitude[i];
                ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)id);
                if (sys != null) {
                    if (System.currentTimeMillis() - time >= 600000L || sys.getLocationTimeMillis() >= time || coordinateSystem.getLatitudeDegs() == 0.0 || coordinateSystem.getLongitudeDegs() == 0.0) continue;
                    sys.setLocation((LocationType)coordinateSystem, time);
                    if (coordinateSystem.getRoll() != 0.0 && coordinateSystem.getPitch() != 0.0 && coordinateSystem.getYaw() != 0.0) {
                        sys.setAttitudeDegrees(coordinateSystem.getRoll(), coordinateSystem.getPitch(), coordinateSystem.getYaw(), time);
                    }
                    sys.storeData("Web Updated", (Object)true, time, true);
                    continue;
                }
                ExternalSystem ext = ExternalSystemsHolder.lookupSystem((String)id);
                boolean registerNewExternal = false;
                if (ext == null) {
                    ext = new ExternalSystem(id);
                    registerNewExternal = true;
                }
                if (System.currentTimeMillis() - time >= 600000L || ext.getLocationTimeMillis() >= time || coordinateSystem.getLatitudeDegs() == 0.0 || coordinateSystem.getLongitudeDegs() == 0.0) continue;
                ext.setLocation((LocationType)coordinateSystem, time);
                if (coordinateSystem.getRoll() != 0.0 && coordinateSystem.getPitch() != 0.0 && coordinateSystem.getYaw() != 0.0) {
                    ext.setAttitudeDegrees(coordinateSystem.getRoll(), coordinateSystem.getPitch(), coordinateSystem.getYaw(), time);
                }
                if (!registerNewExternal) continue;
                ExternalSystemsHolder.registerSystem((ExternalSystem)ext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

