/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.webupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.proxy.ProxyInfoProvider;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.plugins.CheckMenuChangeListener;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.MultiSystemIMCMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.webupdate.RemotePositionHelper;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.StringPatternValidator;
import pt.lsts.neptus.ws.PublishHelper;

@PluginDescription(name="Remote Position Publisher Updater", author="Paulo Dias", version="1.0", icon="pt/lsts/neptus/plugins/webupdate/webupdate-pub-on.png")
public class RemotePositionPublisherUpdater
extends ConsolePanel
implements IPeriodicUpdates,
ConfigurationListener {
    private final ImageIcon ICON_ENABLE = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/webupdate/webupdate-pub-on.png", (int)32, (int)32);
    private final ImageIcon ICON_DISABLE = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/webupdate/webupdate-pub-off.png", (int)32, (int)32);
    @NeptusProperty(name="Publish web address")
    public String pubURL = "http://whale.fe.up.pt/neptleaves/";
    @NeptusProperty(name="Publish period (ms)", description="The period to fetch the systems' positions.")
    public int publishPeriodMillis = 1000;
    @NeptusProperty(category="Advanced", description="If true any simulated system will not be published.")
    public boolean ignoreSimulatedSystems = true;
    @NeptusProperty
    public boolean active = false;
    @NeptusProperty
    public boolean publishOn = true;
    @NeptusProperty(editable=false)
    public String publishMessagesListStd = "EstimatedState, LbLConfig, PlanSpecification, VehicleState, PlanControlState, EntityList";
    @NeptusProperty
    public String publishMessagesListExtra = "Heartbeat, EntityState, Announce, PlanControl, Voltage";
    @NeptusProperty
    public boolean publishWebReceivedMessages = true;
    @NeptusProperty
    public boolean publishOnlyVehicles = false;
    @NeptusProperty
    public boolean publishExternalSystems = true;
    @NeptusProperty
    public boolean publishBeaconsState = false;
    @NeptusProperty
    public boolean publishActiveConsolePlan = false;
    @NeptusProperty
    public boolean publishVehiclePlan = false;
    @NeptusProperty
    public boolean fetchRemoteSystemsOn = true;
    @NeptusProperty
    public boolean publishRemoteSystemsLocally = true;
    @NeptusProperty(category="Advanced")
    public boolean debugOn = false;
    private JCheckBoxMenuItem publishCheckItem = null;
    private String publishMessagesList = "";
    private long lastFetchPosTimeMillis = System.currentTimeMillis();
    private DefaultHttpClient client;
    private PoolingClientConnectionManager httpConnectionManager;
    private HttpPost postHttpRequestPublishState;
    private HttpPost postHttpRequestPublishPlan;
    private HttpGet getHttpRequestImcMsg;
    private HttpGet getHttpRequestRemoteState;
    private Timer timer = null;
    private TimerTask ttask = null;
    private final LinkedHashMap<String, Integer> msgSysList = new LinkedHashMap();
    private MultiSystemIMCMessageListener systemsMessageListener = null;
    private final String messageListRedex = "(\\w(:\\d{1,2})?(((\\s)*)?,((\\s)*)?)?)*";
    private final Pattern messageListPattern = Pattern.compile("(\\w(:\\d{1,2})?(((\\s)*)?,((\\s)*)?)?)*");
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private final LinkedHashMap<String, IMCMessage> estimatedStates;
    private IMCMessage lblConfig;
    private final Object lblConfigLock;
    private final LinkedHashMap<String, IMCMessage> planSpecifications;
    private final LinkedHashMap<String, IMCMessage> vehicleStates;
    private final LinkedHashMap<String, IMCMessage> planControlStates;
    private final LinkedHashMap<String, IMCMessage> entityLists;
    private final LinkedHashMap<String, Vector<IMCMessage>> otherLists;
    private final LinkedHashMap<String, Long> timeSysList;
    private final LinkedHashMap<String, CoordinateSystem> locSysList;
    protected LinkedHashMap<String, String> vehicleToPlanIds;
    protected LinkedHashMap<String, Vector<LocationType>> planToLocations;
    protected LinkedHashMap<String, PathElement> planToPath;
    private ToolbarButton sendEnableDisableButton;

    public RemotePositionPublisherUpdater(ConsoleLayout console) {
        super(console);
        this.docBuilderFactory.setIgnoringComments(true);
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.docBuilderFactory.setNamespaceAware(false);
        this.estimatedStates = new LinkedHashMap();
        this.lblConfig = null;
        this.lblConfigLock = new Object();
        this.planSpecifications = new LinkedHashMap();
        this.vehicleStates = new LinkedHashMap();
        this.planControlStates = new LinkedHashMap();
        this.entityLists = new LinkedHashMap();
        this.otherLists = new LinkedHashMap();
        this.timeSysList = new LinkedHashMap();
        this.locSysList = new LinkedHashMap();
        this.vehicleToPlanIds = new LinkedHashMap();
        this.planToLocations = new LinkedHashMap();
        this.planToPath = new LinkedHashMap();
        this.initializeComm();
        this.initialize();
    }

    public void initSubPanel() {
        this.publishCheckItem = this.addCheckMenuItem(I18n.text((String)"Settings") + ">" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Start/Stop", null, new CheckMenuChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void menuUnchecked(ActionEvent e) {
                RemotePositionPublisherUpdater.this.active = false;
                Object object = RemotePositionPublisherUpdater.this.estimatedStates;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.estimatedStates.clear();
                }
                object = RemotePositionPublisherUpdater.this.lblConfigLock;
                synchronized (object) {
                    if (RemotePositionPublisherUpdater.this.lblConfig != null) {
                        RemotePositionPublisherUpdater.this.lblConfig = null;
                    }
                }
                object = RemotePositionPublisherUpdater.this.planSpecifications;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.planSpecifications.clear();
                }
                object = RemotePositionPublisherUpdater.this.vehicleStates;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.vehicleStates.clear();
                }
                object = RemotePositionPublisherUpdater.this.planControlStates;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.planControlStates.clear();
                }
                object = RemotePositionPublisherUpdater.this.entityLists;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.entityLists.clear();
                }
                object = RemotePositionPublisherUpdater.this.otherLists;
                synchronized (object) {
                    RemotePositionPublisherUpdater.this.otherLists.clear();
                }
            }

            public void menuChecked(ActionEvent e) {
                RemotePositionPublisherUpdater.this.active = true;
            }
        });
        this.addMenuItem(I18n.text((String)"Settings") + ">" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)RemotePositionPublisherUpdater.this, (Frame)RemotePositionPublisherUpdater.this.getConsole(), (boolean)true);
            }
        });
        this.publishCheckItem.setState(this.active);
    }

    private void initialize() {
        this.removeAll();
        this.setBackground(new Color(255, 255, 110));
        this.sendEnableDisableButton = new ToolbarButton(new AbstractAction("Pub on", this.ICON_ENABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String cmd = e.getActionCommand();
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        RemotePositionPublisherUpdater.this.sendEnableDisableButton.setEnabled(false);
                        if ("Pub on".equalsIgnoreCase(cmd)) {
                            RemotePositionPublisherUpdater.this.active = true;
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.setActionCommand("Pub off");
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.getAction().putValue("SmallIcon", RemotePositionPublisherUpdater.this.ICON_DISABLE);
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Pub off");
                        } else if ("Pub off".equalsIgnoreCase(cmd)) {
                            RemotePositionPublisherUpdater.this.active = false;
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.setActionCommand("Pub on");
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.getAction().putValue("SmallIcon", RemotePositionPublisherUpdater.this.ICON_ENABLE);
                            RemotePositionPublisherUpdater.this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Pub on");
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        RemotePositionPublisherUpdater.this.sendEnableDisableButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.sendEnableDisableButton.setActionCommand("Pub on");
        this.add((Component)this.sendEnableDisableButton);
        this.publishMessagesList = this.publishMessagesListStd + ", " + this.publishMessagesListExtra;
        this.timer = new Timer("RemotePositionPublisher");
        this.ttask = this.getTimerTask();
        this.timer.scheduleAtFixedRate(this.ttask, 500L, (long)this.publishPeriodMillis);
        this.systemsMessageListener = new MultiSystemIMCMessageListener(((Object)((Object)this)).getClass().getSimpleName() + " [" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageArrived(ImcId16 id, IMCMessage msg) {
                ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)id);
                if (!(sys == null || RemotePositionPublisherUpdater.this.ignoreSimulatedSystems && sys.isSimulated())) {
                    if ("LbLConfig".equalsIgnoreCase(msg.getAbbrev())) {
                        Object object = RemotePositionPublisherUpdater.this.lblConfigLock;
                        synchronized (object) {
                            RemotePositionPublisherUpdater.this.lblConfig = msg;
                        }
                    }
                    if ("EstimatedState".equalsIgnoreCase(msg.getAbbrev())) {
                        LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.estimatedStates;
                        synchronized (linkedHashMap) {
                            RemotePositionPublisherUpdater.this.estimatedStates.put(sys.getName(), msg);
                        }
                    }
                    if ("PlanSpecification".equalsIgnoreCase(msg.getAbbrev())) {
                        LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.planSpecifications;
                        synchronized (linkedHashMap) {
                            RemotePositionPublisherUpdater.this.planSpecifications.put(sys.getName(), msg);
                        }
                    }
                    if ("VehicleState".equalsIgnoreCase(msg.getAbbrev())) {
                        LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.vehicleStates;
                        synchronized (linkedHashMap) {
                            RemotePositionPublisherUpdater.this.vehicleStates.put(sys.getName(), msg);
                        }
                    }
                    if ("PlanControlState".equalsIgnoreCase(msg.getAbbrev())) {
                        LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.planControlStates;
                        synchronized (linkedHashMap) {
                            RemotePositionPublisherUpdater.this.planControlStates.put(sys.getName(), msg);
                        }
                        RemotePositionPublisherUpdater.this.processPlanControlStateForVehiclePlanInformation(msg);
                    } else {
                        if ("EntityList".equalsIgnoreCase(msg.getAbbrev())) {
                            LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.entityLists;
                            synchronized (linkedHashMap) {
                                RemotePositionPublisherUpdater.this.entityLists.put(sys.getName(), msg);
                            }
                        }
                        LinkedHashMap linkedHashMap = RemotePositionPublisherUpdater.this.otherLists;
                        synchronized (linkedHashMap) {
                            Vector<IMCMessage> osm = (Vector<IMCMessage>)RemotePositionPublisherUpdater.this.otherLists.get(sys.getName());
                            if (osm == null) {
                                osm = new Vector<IMCMessage>();
                                RemotePositionPublisherUpdater.this.otherLists.put(sys.getName(), osm);
                            }
                            if (msg.hasFlag("periodic")) {
                                IMCMessage remove = null;
                                for (IMCMessage imcMessage : osm) {
                                    if (!imcMessage.getAbbrev().equalsIgnoreCase(msg.getAbbrev())) continue;
                                    remove = imcMessage;
                                }
                                if (remove != null) {
                                    osm.remove(remove);
                                }
                            }
                            if (osm.size() > 1024) {
                                osm.remove(0);
                            }
                            if (RemotePositionPublisherUpdater.this.active || msg.hasFlag("periodic")) {
                                osm.add(msg);
                            }
                        }
                    }
                }
            }
        };
    }

    private void initializeComm() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this.httpConnectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.httpConnectionManager.setMaxTotal(4);
        this.httpConnectionManager.setDefaultMaxPerRoute(50);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.httpConnectionManager, (HttpParams)params);
        ProxyInfoProvider.setRoutePlanner((AbstractHttpClient)this.client);
    }

    public String validatePublishMessagesListExtra(String publishMessagesListExtra) {
        return new StringPatternValidator("(\\w(:\\d{1,2})?(((\\s)*)?,((\\s)*)?)?)*").validate((Object)publishMessagesListExtra);
    }

    private void refreshUI() {
        if (this.active && "Pub on".equalsIgnoreCase(this.sendEnableDisableButton.getActionCommand())) {
            this.sendEnableDisableButton.setActionCommand("Pub off");
            this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_DISABLE);
            this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Pub off");
        } else if (!this.active && !"Pub on".equalsIgnoreCase(this.sendEnableDisableButton.getActionCommand())) {
            this.sendEnableDisableButton.setActionCommand("Pub on");
            this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_ENABLE);
            this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Pub on");
        }
    }

    private TimerTask getTimerTask() {
        if (this.ttask == null) {
            this.ttask = new TimerTask(){

                @Override
                public void run() {
                    if (!RemotePositionPublisherUpdater.this.active) {
                        return;
                    }
                    if (RemotePositionPublisherUpdater.this.publishOn) {
                        try {
                            RemotePositionPublisherUpdater.this.publishData();
                            RemotePositionPublisherUpdater.this.publishPlan();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            RemotePositionPublisherUpdater.this.getRemoteImcData();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (RemotePositionPublisherUpdater.this.fetchRemoteSystemsOn) {
                        try {
                            RemotePositionPublisherUpdater.this.getRemoteStateData();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        return this.ttask;
    }

    public long millisBetweenUpdates() {
        return 500L;
    }

    public boolean update() {
        ImcSystem[] systems;
        this.refreshUI();
        if (!this.publishOn && !this.fetchRemoteSystemsOn) {
            this.active = false;
        }
        if (this.publishCheckItem != null) {
            this.publishCheckItem.setState(this.active);
        }
        if (this.publishMessagesList.length() == 0) {
            this.systemsMessageListener.clean();
            return true;
        }
        Vector<String> sn = new Vector<String>();
        for (ImcSystem sys : systems = ImcSystemsHolder.lookupSystemVehicles()) {
            sn.add(sys.getName());
        }
        if (sn.size() == 0) {
            this.systemsMessageListener.clean();
        } else {
            this.systemsMessageListener.setSystemToListenStrings(sn.toArray(new String[sn.size()]));
        }
        if (!this.publishOn) {
            this.abortPublishOnAllActiveConnections();
        }
        if (!this.fetchRemoteSystemsOn) {
            this.abortFetchOnAllActiveConnections();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishData() {
        Element vs;
        ExternalSystem[] externals;
        ImcSystem[] systems;
        Document doc = DocumentHelper.createDocument();
        Element ms = doc.addElement("MissionState");
        for (ImcSystem sys : systems = this.publishOnlyVehicles ? ImcSystemsHolder.lookupSystemVehicles() : ImcSystemsHolder.lookupAllSystems()) {
            PlanType pt;
            if (this.ignoreSimulatedSystems && sys.isSimulated()) continue;
            Element vs2 = ms.addElement("VehicleState");
            vs2.addAttribute("id", sys.getName());
            try {
                if (System.currentTimeMillis() - sys.getLocationTimeMillis() > 3600000L) {
                    ms.remove(vs2);
                    continue;
                }
                if (sys.getLocation().getLatitudeDegs() == 0.0 && sys.getLocation().getLongitudeDegs() == 0.0) {
                    ms.remove(vs2);
                    continue;
                }
                Date date = new Date(sys.getLocationTimeMillis());
                vs2.addAttribute("time", DateTimeUtil.timeFormaterUTC.format(date));
                vs2.addAttribute("date", DateTimeUtil.dateFormaterUTC.format(date));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Element crd = new LocationType(sys.getLocation()).asElement();
            vs2.add(crd);
            Element att = vs2.addElement("attitude");
            att.addElement("phi").addText("" + sys.getRollDegrees());
            att.addElement("theta").addText("" + sys.getPitchDegrees());
            att.addElement("psi").addText("" + sys.getYawDegrees());
            vs2.addElement("imc");
            try {
                IMCMessage opLimits = (IMCMessage)sys.retrieveData("OperationalLimits");
                if (opLimits != null) {
                    LinkedHashMap mask;
                    long millis = sys.retrieveDataTimeMillis("OperationalLimits");
                    if (System.currentTimeMillis() - millis < 86400000L && (mask = opLimits.getBitmask("mask")).containsKey("AREA") && ((Boolean)mask.get("AREA")).booleanValue()) {
                        Element opLimitsElm = vs2.addElement("oplimits");
                        double latDegrees = Math.toDegrees(opLimits.getDouble("lat"));
                        double lonDegrees = Math.toDegrees(opLimits.getDouble("lon"));
                        double orientationDegrees = Math.toDegrees(opLimits.getDouble("orientation"));
                        double width = opLimits.getDouble("width");
                        double height = opLimits.getDouble("length");
                        opLimitsElm.addAttribute("lat", "" + latDegrees);
                        opLimitsElm.addAttribute("lon", "" + lonDegrees);
                        opLimitsElm.addAttribute("orientation", "" + orientationDegrees);
                        opLimitsElm.addAttribute("width", "" + width);
                        opLimitsElm.addAttribute("height", "" + height);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.vehicleToPlanIds.containsKey(sys.getName())) continue;
            String vehStr = sys.getName();
            String planStr = this.vehicleToPlanIds.get(vehStr);
            Vector<LocationType> locs = null;
            PathElement path = null;
            if (this.getConsole() != null && this.getConsole().getMission() != null && this.getConsole().getMission().getIndividualPlansList() != null && (pt = (PlanType)this.getConsole().getMission().getIndividualPlansList().get(planStr)) != null) {
                if (!this.planToLocations.containsKey(planStr)) {
                    locs = PublishHelper.planPathLocs((PlanType)pt);
                    path = PublishHelper.planPathElement(locs, (String)(vehStr + ":" + planStr));
                    this.planToLocations.put(pt.getId(), locs);
                    this.planToPath.put(pt.getId(), path);
                } else {
                    locs = this.planToLocations.get(pt.getId());
                    path = this.planToPath.get(pt.getId());
                }
            }
            if (path == null) continue;
            Element planPathElement = path.asElement();
            Element planElm = vs2.addElement("plan");
            planElm.add(planPathElement);
        }
        for (ExternalSystem sys : externals = this.publishExternalSystems ? ExternalSystemsHolder.lookupAllSystems() : new ExternalSystem[]{}) {
            vs = ms.addElement("VehicleState");
            vs.addAttribute("id", sys.getName());
            try {
                if (System.currentTimeMillis() - sys.getLocationTimeMillis() > 3600000L) {
                    ms.remove(vs);
                    continue;
                }
                if (sys.getLocation().getLatitudeDegs() == 0.0 && sys.getLocation().getLongitudeDegs() == 0.0) {
                    ms.remove(vs);
                    continue;
                }
                Date date = new Date(sys.getLocationTimeMillis());
                vs.addAttribute("time", DateTimeUtil.timeFormaterUTC.format(date));
                vs.addAttribute("date", DateTimeUtil.dateFormaterUTC.format(date));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Element crd = new LocationType(sys.getLocation()).asElement();
            vs.add(crd);
            Element att = vs.addElement("attitude");
            att.addElement("phi").addText("" + sys.getRollDegrees());
            att.addElement("theta").addText("" + sys.getPitchDegrees());
            att.addElement("psi").addText("" + sys.getYawDegrees());
            vs.addElement("imc");
        }
        if (this.publishBeaconsState && this.getConsole() != null && this.getConsole().getMission() != null) {
            MissionType mt = this.getConsole().getMission();
            Vector ts = MapGroup.getMapGroupInstance((MissionType)mt).getAllObjectsOfType(TransponderElement.class);
            for (TransponderElement beacon : ts) {
                vs = ms.addElement("VehicleState");
                vs.addAttribute("id", beacon.getId());
                LocationType locBeacon = beacon.getCenterLocation().getNewAbsoluteLatLonDepth();
                try {
                    if (locBeacon.getLatitudeDegs() == 0.0 && locBeacon.getLongitudeDegs() == 0.0) {
                        ms.remove(vs);
                        continue;
                    }
                    Date date = new Date(System.currentTimeMillis());
                    vs.addAttribute("time", DateTimeUtil.timeFormaterUTC.format(date));
                    vs.addAttribute("date", DateTimeUtil.dateFormaterUTC.format(date));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Element crd = locBeacon.asElement();
                vs.add(crd);
                Element att = vs.addElement("attitude");
                att.addElement("phi").addText("0");
                att.addElement("theta").addText("0");
                att.addElement("psi").addText("0");
                vs.addElement("imc");
            }
        }
        String xml = doc.asXML();
        if (this.postHttpRequestPublishState != null) {
            this.postHttpRequestPublishState.abort();
        }
        this.postHttpRequestPublishState = null;
        try {
            String uri = this.pubURL + "state";
            this.postHttpRequestPublishState = new HttpPost(uri);
            BasicNameValuePair nvp_type = new BasicNameValuePair("type", "state");
            BasicNameValuePair nvp_xml = new BasicNameValuePair("xml", xml);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(nvp_type);
            nvps.add(nvp_xml);
            this.postHttpRequestPublishState.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            BasicHttpContext localContext = new BasicHttpContext();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.postHttpRequestPublishState, (HttpContext)localContext);
            ProxyInfoProvider.authenticateConnectionIfNeeded((HttpResponse)iGetResultCode, (HttpContext)localContext, (DefaultHttpClient)this.client);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>publishData [" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.postHttpRequestPublishState != null) {
                    this.postHttpRequestPublishState.abort();
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (this.postHttpRequestPublishState != null) {
                this.postHttpRequestPublishState.abort();
                this.postHttpRequestPublishState = null;
            }
        }
        try {
            Vector<IMCMessage> msgLst = new Vector<IMCMessage>();
            LinkedHashMap<String, Object> linkedHashMap = this.estimatedStates;
            synchronized (linkedHashMap) {
                msgLst.addAll(this.estimatedStates.values());
                this.estimatedStates.clear();
            }
            linkedHashMap = this.lblConfigLock;
            synchronized (linkedHashMap) {
                if (this.lblConfig != null) {
                    msgLst.add(this.lblConfig);
                    this.lblConfig = null;
                }
            }
            linkedHashMap = this.planSpecifications;
            synchronized (linkedHashMap) {
                msgLst.addAll(this.planSpecifications.values());
                this.planSpecifications.clear();
            }
            linkedHashMap = this.vehicleStates;
            synchronized (linkedHashMap) {
                msgLst.addAll(this.vehicleStates.values());
                this.vehicleStates.clear();
            }
            linkedHashMap = this.planControlStates;
            synchronized (linkedHashMap) {
                msgLst.addAll(this.planControlStates.values());
                this.planControlStates.clear();
            }
            linkedHashMap = this.entityLists;
            synchronized (linkedHashMap) {
                msgLst.addAll(this.entityLists.values());
                this.entityLists.clear();
            }
            linkedHashMap = this.otherLists;
            synchronized (linkedHashMap) {
                for (Vector<IMCMessage> vecMsgs : this.otherLists.values()) {
                    msgLst.addAll(vecMsgs);
                    vecMsgs.clear();
                }
                this.otherLists.clear();
            }
            if (msgLst != null && msgLst.size() > 0) {
                this.postMessages(msgLst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishPlan() {
        String xml;
        if (!this.publishActiveConsolePlan || this.getConsole().getPlan() == null) {
            return false;
        }
        try {
            xml = PublishHelper.createPlanPath((MissionType)this.getConsole().getMission(), (PlanType)this.getConsole().getPlan());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        if (this.postHttpRequestPublishPlan != null) {
            this.postHttpRequestPublishPlan.abort();
        }
        this.postHttpRequestPublishPlan = null;
        try {
            String uri = this.pubURL + "state";
            this.postHttpRequestPublishPlan = new HttpPost(uri);
            BasicNameValuePair nvp_type = new BasicNameValuePair("type", "plan");
            BasicNameValuePair nvp_xml = new BasicNameValuePair("xml", xml);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(nvp_type);
            nvps.add(nvp_xml);
            this.postHttpRequestPublishPlan.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            BasicHttpContext localContext = new BasicHttpContext();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.postHttpRequestPublishPlan, (HttpContext)localContext);
            ProxyInfoProvider.authenticateConnectionIfNeeded((HttpResponse)iGetResultCode, (HttpContext)localContext, (DefaultHttpClient)this.client);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>publishData [" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.postHttpRequestPublishPlan != null) {
                    this.postHttpRequestPublishPlan.abort();
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (this.postHttpRequestPublishPlan != null) {
                this.postHttpRequestPublishPlan.abort();
                this.postHttpRequestPublishPlan = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postMessages(Collection<IMCMessage> messages) {
        HttpPost post = null;
        try {
            String uri = this.pubURL + "imc/";
            post = new HttpPost(uri);
            Vector<Byte> bv = new Vector<Byte>();
            for (IMCMessage msg : messages) {
                byte[] ba;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
                msg.serialize(ios);
                for (byte b : ba = baos.toByteArray()) {
                    bv.add(b);
                }
            }
            byte[] bf = new byte[bv.size()];
            int i = 0;
            Iterator i$ = bv.iterator();
            while (i$.hasNext()) {
                byte b = (Byte)i$.next();
                bf[i++] = b;
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(bf);
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)inStream, -1L);
            reqEntity.setContentType("application/lsf");
            reqEntity.setChunked(true);
            post.setEntity((HttpEntity)reqEntity);
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)post);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>postMessages [" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (post != null) {
                    post.abort();
                }
                boolean arr$ = false;
                return arr$;
            }
            try {
                InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
                long fullSize = iGetResultCode.getEntity().getContentLength();
                String timeStr = StreamUtil.copyStreamToString((InputStream)streamGetResponseBody).trim();
                long serverTime = Long.parseLong(timeStr);
            }
            catch (Exception e) {
                NeptusLog.pub().info((Object)("<###> " + e.getMessage()));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)("<###> " + e.getMessage()));
        }
        finally {
            if (post != null) {
                post.abort();
                post = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRemoteImcData() {
        if (!this.publishWebReceivedMessages) {
            return true;
        }
        if (this.getHttpRequestImcMsg != null) {
            this.getHttpRequestImcMsg.abort();
        }
        this.getHttpRequestImcMsg = null;
        long time = this.lastFetchPosTimeMillis <= 0L ? 0L : this.lastFetchPosTimeMillis;
        try {
            String endpoint = this.pubURL;
            String uri = endpoint + "imc?after=" + time;
            this.getHttpRequestImcMsg = new HttpGet(uri);
            long reqTime = System.currentTimeMillis();
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.getHttpRequestImcMsg);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>getRemoteImcData [" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.getHttpRequestImcMsg != null) {
                    this.getHttpRequestImcMsg.abort();
                }
                boolean bl = false;
                return bl;
            }
            try {
                long serverTime;
                this.lastFetchPosTimeMillis = serverTime = Long.parseLong(iGetResultCode.getFirstHeader("server-time").getValue().trim());
            }
            catch (Exception e) {
                this.lastFetchPosTimeMillis = System.currentTimeMillis();
            }
            InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
            long fullSize = iGetResultCode.getEntity().getContentLength();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean streamRes = StreamUtil.copyStreamToStream((InputStream)streamGetResponseBody, (OutputStream)baos);
            byte[] baa = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(baa);
            IMCMessage[] msgs = IMCUtils.parseLsf((InputStream)bais);
            if (msgs.length > 0) {
                this.processWebMessages(msgs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.getHttpRequestImcMsg != null) {
                this.getHttpRequestImcMsg.abort();
                this.getHttpRequestImcMsg = null;
            }
        }
        return true;
    }

    private void processWebMessages(IMCMessage[] msgs) {
        if (this.publishWebReceivedMessages) {
            for (IMCMessage msg : msgs) {
                try {
                    ImcId16 id = new ImcId16(msg.getHeader().getValue("src"));
                    if (!this.debugOn && !ImcId16.NULL_ID.equals((Object)ImcMsgManager.getManager().getLocalId()) && ImcMsgManager.getManager().getLocalId().equals((Object)id)) {
                        return;
                    }
                    MessageInfoImpl info = new MessageInfoImpl();
                    info.setTimeSentNanos((long)(msg.getHeader().getTimestamp() * 1.0E9));
                    info.setTimeReceivedNanos(this.lastFetchPosTimeMillis * 1000000L);
                    info.setProperty("NotToLogMessage", "true");
                    info.setProperty("Web Fetch", "true");
                    ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)id);
                    if (sys != null || id.intValue() < 16384 || id.intValue() >= 24575) continue;
                    this.processWebCCUMessage((MessageInfo)info, msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processWebCCUMessage(MessageInfo info, IMCMessage msg) {
        if ("PlanSpecification".equalsIgnoreCase(msg.getAbbrev())) {
            try {
                String planId = msg.getAsString("plan_id");
                ImcId16 imcId = null;
                try {
                    imcId = new ImcId16(msg.getHeaderValue("src"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String srcId = imcId == null ? msg.getHeaderValue("src").toString() : imcId.toString();
                int res = JOptionPane.showConfirmDialog((Component)this.getConsole(), "Plan with id '" + planId + "' just arrived from " + srcId + ". Want to accept it?", PluginUtils.getPluginName(((Object)((Object)this)).getClass()), 0);
                if (res != 0) {
                    return;
                }
                PlanType plan = IMCUtils.parsePlanSpecification((MissionType)this.getConsole().getMission(), (IMCMessage)msg);
                if (this.getConsole().getMission().getIndividualPlansList().containsKey(planId) && (res = JOptionPane.showConfirmDialog((Component)this.getConsole(), "Overwrite existing plan?", "Plan editor", 0)) != 0) {
                    return;
                }
                this.getConsole().getMission().getIndividualPlansList().put(planId, plan);
                new Thread(){

                    @Override
                    public void run() {
                        RemotePositionPublisherUpdater.this.getConsole().getMission().save(false);
                    }
                }.start();
                this.getConsole().updateMissionListeners();
                this.getConsole().setPlan(plan);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ImcId16 imcId = null;
            try {
                try {
                    imcId = new ImcId16(msg.getHeaderValue("src"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String srcId = imcId == null ? msg.getHeaderValue("src").toString() : imcId.toString();
                imcId = new ImcId16(msg.getHeaderValue("dst"));
                ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)imcId);
                if (sys != null) {
                    int res = JOptionPane.showConfirmDialog((Component)this.getConsole(), "Message '" + msg.getAbbrev() + "' just arrived from " + srcId + " to " + sys.getName() + ". \nWant to foward it?\n >> " + StringUtils.wrapEveryNChars((String)msg.asJSON(), (short)100, (int)300, (boolean)true) + " <<", PluginUtils.getPluginName(((Object)((Object)this)).getClass()), 0);
                    if (res != 0) {
                        return;
                    }
                    ImcMsgManager.getManager().sendMessage(msg, imcId, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRemoteStateData() {
        if (!this.fetchRemoteSystemsOn) {
            return false;
        }
        if (this.getHttpRequestRemoteState != null) {
            this.getHttpRequestRemoteState.abort();
        }
        this.getHttpRequestRemoteState = null;
        try {
            String endpoint = this.pubURL;
            String uri = endpoint + "state/state.xml";
            this.getHttpRequestRemoteState = new HttpGet(uri);
            CloseableHttpResponse iGetResultCode = this.client.execute((HttpUriRequest)this.getHttpRequestRemoteState);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>[" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.getHttpRequestRemoteState != null) {
                    this.getHttpRequestRemoteState.abort();
                }
                boolean bl = false;
                return bl;
            }
            InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document docProfiles = builder.parse(streamGetResponseBody);
            RemotePositionHelper.getRemoteState(this.timeSysList, this.locSysList, docProfiles);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage());
        }
        finally {
            if (this.getHttpRequestRemoteState != null) {
                this.getHttpRequestRemoteState.abort();
                this.getHttpRequestRemoteState = null;
            }
        }
        this.processRemoteStates();
        return true;
    }

    private void processRemoteStates() {
        if (this.publishRemoteSystemsLocally) {
            RemotePositionHelper.publishRemoteStatesLocally(this.timeSysList, this.locSysList);
        }
    }

    public void processPlanControlStateForVehiclePlanInformation(IMCMessage msg) {
        try {
            PlanControlState pcstate = PlanControlState.clone((IMCMessage)msg);
            ImcSystem system = ImcSystemsHolder.lookupSystem((int)msg.getSrc());
            if (system == null) {
                return;
            }
            String sysId = system.getName();
            switch (pcstate.getState()) {
                case INITIALIZING: 
                case EXECUTING: {
                    this.vehicleToPlanIds.put(sysId, pcstate.getPlanId());
                    break;
                }
                case BLOCKED: 
                case READY: {
                    this.vehicleToPlanIds.remove(sysId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanSubPanel() {
        this.removeCheckMenuItem("Settings>" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Start/Stop");
        this.removeMenuItem("Settings>" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Settings");
        if (this.client != null) {
            // empty if block
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
        if (this.ttask != null) {
            this.ttask.cancel();
            this.ttask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.msgSysList.clear();
        this.systemsMessageListener.clean();
    }

    public void propertiesChanged() {
        if (!this.pubURL.endsWith("/")) {
            this.pubURL = this.pubURL + "/";
        }
        this.publishMessagesList = this.publishMessagesListStd;
        Matcher m = this.messageListPattern.matcher(this.publishMessagesListExtra);
        boolean b = m.matches();
        if (b) {
            this.publishMessagesList = this.publishMessagesList + ", " + this.publishMessagesListExtra;
        }
        this.msgSysList.clear();
        if (this.publishMessagesList.length() != 0) {
            try {
                m = this.messageListPattern.matcher(this.publishMessagesList);
                b = m.matches();
                if (b) {
                    for (String pme : this.publishMessagesList.split(",")) {
                        String[] kk = pme.split(":");
                        this.msgSysList.put(kk[0].trim(), kk.length == 1 ? 0 : Integer.parseInt(kk[1].trim()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.systemsMessageListener.setMessagesToListen(this.msgSysList.keySet().toArray(new String[0]));
        if (!this.publishOn && !this.fetchRemoteSystemsOn) {
            this.active = false;
        }
        this.abortAllActiveConnections();
        if (this.ttask != null) {
            this.ttask.cancel();
            this.ttask = null;
        }
        this.ttask = this.getTimerTask();
        this.timer.scheduleAtFixedRate(this.ttask, 500L, (long)this.publishPeriodMillis);
    }

    private void abortAllActiveConnections() {
        this.abortPublishOnAllActiveConnections();
        this.abortFetchOnAllActiveConnections();
    }

    private void abortPublishOnAllActiveConnections() {
        try {
            if (this.postHttpRequestPublishState != null) {
                this.postHttpRequestPublishState.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.getHttpRequestImcMsg != null) {
                this.getHttpRequestImcMsg.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.postHttpRequestPublishPlan != null) {
                this.postHttpRequestPublishPlan.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void abortFetchOnAllActiveConnections() {
        try {
            if (this.getHttpRequestRemoteState != null) {
                this.getHttpRequestRemoteState.abort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

