/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.state;

import com.google.common.eventbus.Subscribe;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import pt.lsts.imc.VehicleState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.speech.SpeechUtil;

@PluginDescription(name="Audio Vehicle State Alerts", category=PluginDescription.CATEGORY.INTERFACE)
public class AudibleVehicleState
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, VehicleState> vStatesImc = new LinkedHashMap();
    protected JMenuItem audioAlerts = null;
    @NeptusProperty(name="Use Audio Alerts", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean useAudioAlerts = true;

    public AudibleVehicleState(ConsoleLayout console) {
        super(console);
    }

    public long millisBetweenUpdates() {
        return 2500L;
    }

    public void initSubPanel() {
        this.audioAlerts = new JCheckBoxMenuItem(I18n.text((String)"Audio Alerts"));
        this.audioAlerts.setSelected(this.useAudioAlerts);
        this.audioAlerts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudibleVehicleState.this.useAudioAlerts = AudibleVehicleState.this.audioAlerts.isSelected();
                if (!AudibleVehicleState.this.useAudioAlerts) {
                    SpeechUtil.stop();
                }
            }
        });
        this.getConsole().getOrCreateJMenu(new String[]{I18n.text((String)"Tools")}).add(this.audioAlerts);
    }

    public void cleanSubPanel() {
        try {
            this.audioAlerts.getParent().remove(this.audioAlerts);
            SpeechUtil.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean update() {
        for (String src : this.vStatesImc.keySet().toArray(new String[0])) {
            try {
                if (ImcSystemsHolder.getSystemWithName((String)src).isActive()) continue;
                this.vStatesImc.remove(src);
                this.say("Lost connection to " + src);
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)(AudibleVehicleState.class.getSimpleName() + " for " + src + " gave an error: " + e.getMessage()));
            }
        }
        return true;
    }

    private String cleanUp(String text) {
        return text.replaceAll("xtreme", "extreme").replaceAll("xplore", "explore").replaceAll("lauv-seacon-1", "eereena");
    }

    public void say(String text) {
        if (this.useAudioAlerts) {
            SpeechUtil.readSimpleText((String)this.cleanUp(text));
        }
    }

    @Subscribe
    public void consume(VehicleState msg) {
        String src = msg.getSourceName();
        if (src == null) {
            return;
        }
        VehicleState oldState = this.vStatesImc.get(src);
        if (oldState != null) {
            boolean startedTeleop;
            boolean stoppedTeleop = oldState.getManeuverType() == 452 && msg.getManeuverType() != 452;
            boolean bl = startedTeleop = oldState.getManeuverType() != 452 && msg.getManeuverType() == 452;
            if (oldState.getOpMode() != msg.getOpMode() || startedTeleop || stoppedTeleop) {
                String text = src + " is in " + msg.getOpMode().toString() + " mode";
                if (msg.getManeuverType() == 452) {
                    text = src + " is in teleh operation mode";
                }
                String regexp = "e?" + src + " is in .* mode";
                SpeechUtil.removeStringsFromQueue((String)regexp);
                this.say(text);
            }
        } else {
            String text = src + " is connected";
            SpeechUtil.removeStringsFromQueue((String)("Lost connection to e?" + src));
            this.say(text);
        }
        this.vStatesImc.put(src, msg);
    }
}

