/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.state;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.EntityState;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.state.EntitiesModel;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Entity Sub Panel")
public class EntitySubPanel
extends ConsolePanel {
    private static final long serialVersionUID = -2631714987613438043L;
    private final int PANEL_WIDTH = 300;
    private final int GAP = 5;
    private final int COMPONENT_WIDTH = 290;
    private final int TABLE_HEIGHT = 200;
    JLabel globalState;
    JButton setEntitiesVisibility = new JButton(I18n.text((String)"Choose entities"));
    private ImageIcon bootstrappingIcon;
    private ImageIcon errorIcon;
    private ImageIcon failureIcon;
    private ImageIcon faultIcon;
    private final int numberOfMsgValuesStored = 7;
    EntitiesModel model;

    public EntitySubPanel(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        this.removeAll();
        this.setSize(300, 500);
        this.setBackground(Color.BLACK);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(I18n.text((String)"Hide"));
        columnNames.add(I18n.text((String)"Entity"));
        columnNames.add(I18n.text((String)"State"));
        columnNames.add(I18n.text((String)"Description"));
        columnNames.add(I18n.text((String)"\u0394t"));
        columnNames.add(I18n.text((String)"Entity identifier"));
        this.model = new EntitiesModel(columnNames);
        EntityTable table = new EntityTable(this.model);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(290, 200));
        scrollPane.setMaximumSize(new Dimension(290, 200));
        scrollPane.setMinimumSize(new Dimension(290, 200));
        this.globalState = new JLabel(I18n.text((String)"Error in selected entities!"));
        this.globalState.setForeground(Color.red);
        StringBuilder colConstraints = new StringBuilder();
        colConstraints.append("[]");
        colConstraints.append(5);
        colConstraints.append("[");
        colConstraints.append(" grow]");
        colConstraints.append(5);
        colConstraints.append("[]");
        this.setLayout((LayoutManager)new MigLayout("", colConstraints.toString(), "[]5[]"));
        this.add(this.globalState, "span 2 ");
        this.add(this.setEntitiesVisibility, "wrap");
        this.add(scrollPane, "span, grow, wrap");
    }

    @Subscribe
    public void handleMessage(EntityState stateMsg) {
        EntityState.STATE state = stateMsg.getState();
        String entityName = EntitiesResolver.resolveName((String)this.getMainVehicleId(), (Integer)Integer.valueOf(stateMsg.getSrcEnt()));
        if (!state.equals((Object)EntityState.STATE.NORMAL) && entityName != null) {
            UpdateWorker worker = new UpdateWorker(stateMsg);
            worker.execute();
        }
    }

    public void cleanSubPanel() {
    }

    private class EntityTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private final Timer timer;
        private final int INITIAL_DELAY = 30000;
        private final int UPDATE_FREQUENCY = 100;

        public EntityTable(EntitiesModel model) {
            super(model);
            this.INITIAL_DELAY = 30000;
            this.UPDATE_FREQUENCY = 100;
            this.setPreferredScrollableViewportSize(new Dimension(1600, 70));
            this.setAutoCreateRowSorter(true);
            this.setFillsViewportHeight(true);
            TableColumn column = this.columnModel.getColumn(0);
            column.setPreferredWidth((int)Math.floor(30.0));
            column = this.columnModel.getColumn(EntitiesModel.DataIndex.ENTITY_NAME.getIndex());
            column.setPreferredWidth((int)Math.floor(105.0));
            column = this.columnModel.getColumn(EntitiesModel.DataIndex.ICON.getIndex());
            column.setPreferredWidth((int)Math.floor(30.0));
            column.setResizable(false);
            column = this.columnModel.getColumn(EntitiesModel.DataIndex.DESCRIPTION.getIndex());
            column.setPreferredWidth((int)Math.floor(90.0));
            column = this.columnModel.getColumn(EntitiesModel.DataIndex.TIME_ELAPSED.getIndex());
            column.setPreferredWidth((int)Math.floor(45.0));
            column.setResizable(false);
            this.removeColumn(this.getColumnModel().getColumn(EntitiesModel.DataIndex.ENTITY_ID.getIndex()));
            this.timer = new Timer(100, new ElapsedTimeTimer());
            this.timer.setInitialDelay(30000);
            this.timer.start();
        }

        public Class<? extends Object> getColumnClass(int column) {
            Object value = this.getValueAt(0, column);
            return value == null ? Object.class : value.getClass();
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            if (rowIndex == -1) {
                return "";
            }
            int colIndex = this.columnAtPoint(p);
            Object cell = this.getValueAt(rowIndex, colIndex);
            if (cell instanceof String) {
                return (String)cell;
            }
            if (cell instanceof ImageIcon) {
                return ((ImageIcon)cell).getDescription();
            }
            if (cell instanceof Boolean) {
                Boolean cellB = (Boolean)cell;
                if (cellB.booleanValue()) {
                    return I18n.text((String)"Hide");
                }
                return I18n.text((String)"Show");
            }
            return I18n.text((String)"A new adaptor is needed!");
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new EntityTableHeader(this.columnModel);
        }

        class ElapsedTimeTimer
        implements ActionListener {
            ElapsedTimeTimer() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < EntityTable.this.dataModel.getRowCount(); ++i) {
                    short row = (Short)EntityTable.this.getValueAt(i, EntitiesModel.DataIndex.TIME_ELAPSED.getIndex());
                    row = (short)(row + 0);
                    EntityTable.this.setValueAt(row, i, EntitiesModel.DataIndex.TIME_ELAPSED.getIndex());
                }
            }
        }

        private class EntityTableHeader
        extends JTableHeader {
            private static final long serialVersionUID = 7972061124799780985L;

            public EntityTableHeader(TableColumnModel columnModel) {
                super(columnModel);
                this.setBackground(Color.WHITE);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return EntitySubPanel.this.model.getColumnName(realIndex);
            }
        }
    }

    public class UpdateWorker
    extends SwingWorker<Void, Void> {
        private final EntityState msg;

        public UpdateWorker(EntityState msg) {
            this.msg = msg;
        }

        @Override
        public Void doInBackground() {
            short srcEntityId = this.msg.getSrcEnt();
            String entityName = EntitiesResolver.resolveName((String)EntitySubPanel.this.getMainVehicleId(), (Integer)Integer.valueOf(srcEntityId));
            Object[] row = new Object[7];
            EntityState.STATE state = this.msg.getState();
            switch (state) {
                case BOOT: {
                    row[EntitiesModel.DataIndex.ICON.getIndex()] = EntitySubPanel.this.bootstrappingIcon;
                    break;
                }
                case ERROR: {
                    row[EntitiesModel.DataIndex.ICON.getIndex()] = EntitySubPanel.this.errorIcon;
                    break;
                }
                case FAILURE: {
                    row[EntitiesModel.DataIndex.ICON.getIndex()] = EntitySubPanel.this.failureIcon;
                    break;
                }
                case FAULT: {
                    row[EntitiesModel.DataIndex.ICON.getIndex()] = EntitySubPanel.this.faultIcon;
                    break;
                }
            }
            row[EntitiesModel.DataIndex.ENTITY_NAME.getIndex()] = entityName;
            row[EntitiesModel.DataIndex.DESCRIPTION.getIndex()] = this.msg.getDescription();
            row[EntitiesModel.DataIndex.ENTITY_ID.getIndex()] = (int)srcEntityId;
            row[EntitiesModel.DataIndex.TIME_ELAPSED.getIndex()] = (short)0;
            EntitySubPanel.this.model.updateRow(row);
            return null;
        }
    }

    public static enum Icons {
        BOOTSTRAPPINGICON("images/information/bootsInfo.png", I18n.text((String)"Bootstraping")),
        ERRORICON("images/information/errorInfo.png", I18n.text((String)"Error")),
        FAILUREICON("images/information/failureInfo.png", I18n.text((String)"Failure")),
        FAULTICON("images/information/faultInfo.png", I18n.text((String)"Fault"));

        private final ImageIcon icon;

        private Icons(String path, String description) {
            this.icon = ImageUtils.createImageIcon((String)path);
            this.icon.setDescription(description);
        }

        public ImageIcon getIcon() {
            return this.icon;
        }
    }
}

