/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.state;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import pt.lsts.imc.state.ImcSystemState;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="IMC State Panel")
public class ImcStatePanel
extends ConsolePanel
implements CommManagerStatusChangeListener {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, JMenuItem> menus = new LinkedHashMap();
    private final String menuPath = I18n.text((String)"Advanced") + ">" + I18n.text((String)"Incoming messages") + ">";

    public ImcStatePanel(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        ImcSystem[] systems;
        for (ImcSystem s : systems = ImcSystemsHolder.lookupAllSystems()) {
            ImageIcon icon = null;
            if (s.getVehicle() != null) {
                icon = s.getVehicle().getIcon();
            }
            this.createMenu(s.getName(), icon);
        }
        ImcMsgManager.getManager().addStatusListener((CommManagerStatusChangeListener)this);
    }

    public void managerStatusChanged(int status, String msg) {
    }

    protected JMenuItem createMenu(String system, ImageIcon icon) {
        final ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)system);
        if (sys == null) {
            return null;
        }
        if (icon == null) {
            icon = ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass()));
        }
        final Image sysIco = icon.getImage();
        JMenuItem item = this.addMenuItem(this.menuPath + system, icon, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pt.lsts.imc.gui.ImcStatePanel statePanel = new pt.lsts.imc.gui.ImcStatePanel((ImcSystemState)ImcMsgManager.getManager().getState(sys.getId()));
                JFrame frm = new JFrame(sys.getName() + " messages");
                frm.setSize(800, 600);
                frm.getContentPane().add((Component)statePanel);
                frm.setDefaultCloseOperation(2);
                GuiUtils.centerOnScreen((Window)frm);
                frm.setIconImage(sysIco);
                frm.setVisible(true);
            }
        });
        this.menus.put(system, item);
        return item;
    }

    protected void removeMenu(String system) {
        this.removeMenuItem(this.menuPath + system);
    }

    public void managerSystemAdded(String systemId) {
        this.createMenu(systemId, null);
    }

    public void managerSystemRemoved(String systemId) {
        this.removeMenu(systemId);
    }

    public void managerSystemStatusChanged(String systemId, int status) {
    }

    public void managerVehicleAdded(VehicleType vehicle) {
        this.createMenu(vehicle.getId(), vehicle.getIcon());
    }

    public void managerVehicleRemoved(VehicleType vehicle) {
        this.removeMenu(vehicle.getId());
    }

    public void managerVehicleStatusChanged(VehicleType vehicle, int status) {
    }

    public void cleanSubPanel() {
    }
}

