/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import java.io.IOException;
import java.util.HashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.ecmascript.builtin.MFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.MFString;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;

public class JavascriptBrowser {
    private ErrorReporter errorReporter;
    private VRMLExecutionSpace execSpace;
    private VRML97CommonBrowser realBrowser;

    JavascriptBrowser(VRMLExecutionSpace vRMLExecutionSpace, BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        VRMLNodeFactory vRMLNodeFactory = basicScene.getNodeFactory();
        this.realBrowser = new VRML97CommonBrowser(browserCore, routeManager, frameStateManager, worldLoaderManager, vRMLNodeFactory);
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.execSpace = vRMLExecutionSpace;
        this.realBrowser.setErrorReporter(this.errorReporter);
    }

    public String getDescription() {
        return this.realBrowser.getDescription();
    }

    public void setDescription(String string) {
        this.realBrowser.setDescription(string);
    }

    public String getName() {
        return this.realBrowser.getName();
    }

    public String getVersion() {
        return this.realBrowser.getVersion();
    }

    public float getCurrentSpeed() {
        return this.realBrowser.getCurrentSpeed();
    }

    public float getCurrentFrameRate() {
        return this.realBrowser.getCurrentFrameRate();
    }

    public String getWorldURL() {
        return this.realBrowser.getWorldURL();
    }

    public void replaceWorld(MFNode mFNode) {
        this.realBrowser.replaceWorld(mFNode.getRawData());
    }

    public MFNode createVrmlFromString(String string) {
        MFNode mFNode = null;
        try {
            Object[] objectArray = this.realBrowser.createVrmlFromString(string, this.execSpace);
            mFNode = new MFNode(objectArray);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return mFNode;
    }

    public void createVrmlFromURL(MFString mFString, SFNode sFNode, String string) {
        try {
            this.realBrowser.createVrmlFromURL(mFString.getRawData(), sFNode.getImplNode(), string);
        }
        catch (InvalidFieldException invalidFieldException) {
            if (this.errorReporter != null) {
                this.errorReporter.errorReport(null, invalidFieldException);
            }
            invalidFieldException.printStackTrace();
        }
    }

    public void addRoute(SFNode sFNode, String string, SFNode sFNode2, String string2) {
        VRMLNodeType vRMLNodeType = sFNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = sFNode2.getImplNode();
        try {
            this.realBrowser.addRoute(this.execSpace, vRMLNodeType, string, vRMLNodeType2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            if (this.errorReporter != null) {
                this.errorReporter.errorReport(null, invalidFieldException);
            }
            invalidFieldException.printStackTrace();
        }
    }

    public void deleteRoute(SFNode sFNode, String string, SFNode sFNode2, String string2) {
        VRMLNodeType vRMLNodeType = sFNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = sFNode2.getImplNode();
        try {
            this.realBrowser.deleteRoute(this.execSpace, vRMLNodeType, string, vRMLNodeType2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            if (this.errorReporter != null) {
                this.errorReporter.errorReport(null, invalidFieldException);
            }
            invalidFieldException.printStackTrace();
        }
    }

    public void loadURL(MFString mFString, MFString mFString2) {
        String[] stringArray = mFString2.getRawData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(61);
            String string = stringArray[i].substring(0, n2);
            String string2 = stringArray[i].substring(n2 + 1);
            hashMap.put(string, string2);
        }
        this.realBrowser.loadURL(mFString.getRawData(), hashMap);
    }

    public void println(String string) {
        if (this.errorReporter != null) {
            this.errorReporter.messageReport(string);
        } else {
            System.out.println(string);
        }
    }

    public void println(Object object) {
        if (this.errorReporter != null) {
            this.errorReporter.messageReport(object.toString());
        } else {
            System.out.println(object);
        }
    }

    public void print(String string) {
        if (this.errorReporter != null) {
            this.errorReporter.messageReport(string);
        } else {
            System.out.print(string);
        }
    }

    public void print(Object object) {
        if (this.errorReporter != null) {
            this.errorReporter.messageReport(object.toString());
        } else {
            System.out.print(object);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.realBrowser.setErrorReporter(this.errorReporter);
    }

    public VRMLNodeType[] parseVrmlString(String string) throws VRMLParseException, VRMLException {
        try {
            return this.realBrowser.createVrmlFromString(string, this.execSpace);
        }
        catch (IOException iOException) {
            throw new VRMLException(iOException.getMessage());
        }
    }
}

