/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import java.util.WeakHashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.ecmascript.JavascriptBrowser;

class JavascriptBrowserFactory {
    private ErrorReporter errorReporter;
    private BrowserCore core;
    private RouteManager routeManager;
    private WorldLoaderManager loadManager;
    private FrameStateManager stateManager;
    private WeakHashMap browsers;

    JavascriptBrowserFactory(BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        this.core = browserCore;
        this.routeManager = routeManager;
        this.loadManager = worldLoaderManager;
        this.stateManager = frameStateManager;
        this.browsers = new WeakHashMap();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public JavascriptBrowser getBrowser(VRMLExecutionSpace vRMLExecutionSpace) {
        JavascriptBrowser javascriptBrowser = (JavascriptBrowser)this.browsers.get(vRMLExecutionSpace);
        if (javascriptBrowser == null) {
            javascriptBrowser = new JavascriptBrowser(vRMLExecutionSpace, this.core, this.routeManager, this.stateManager, this.loadManager);
            javascriptBrowser.setErrorReporter(this.errorReporter);
            this.browsers.put(vRMLExecutionSpace, javascriptBrowser);
        }
        return javascriptBrowser;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

