/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import java.util.HashMap;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.ecmascript.JavascriptBrowser;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldExtras;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldFactory;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;

class JavascriptScriptContext
implements Scriptable,
FieldExtras {
    private static final String BROWSER = "Browser";
    private static final String TRUE_STRING = "TRUE";
    private static final String FALSE_STRING = "FALSE";
    private static final Object[] EMPTY_IDS = new Object[0];
    private Scriptable parentScope;
    private HashMap fieldValueMap = new HashMap();
    private IntHashMap eventOutIndexMap;
    private HashMap eventOutValueMap = new HashMap();
    private HashSet changedEventOuts = new HashSet();
    private HashMap functionObjects;
    private HashMap stdObjects;
    private FieldFactory fieldFactory;
    private JavascriptBrowser browser;
    private ErrorReporter errorReporter;

    JavascriptScriptContext(JavascriptBrowser javascriptBrowser, Scriptable scriptable, FieldFactory fieldFactory) {
        this.eventOutIndexMap = new IntHashMap();
        this.functionObjects = new HashMap();
        this.stdObjects = new HashMap();
        this.browser = javascriptBrowser;
        this.fieldFactory = fieldFactory;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        Scriptable scriptable2 = Context.toObject((Object)javascriptBrowser, (Scriptable)scriptable);
        this.stdObjects.put(TRUE_STRING, Boolean.TRUE);
        this.stdObjects.put(FALSE_STRING, Boolean.FALSE);
        this.stdObjects.put(BROWSER, scriptable2);
    }

    public String getClassName() {
        return "Script";
    }

    public Object getDefaultValue(Class clazz) {
        return null;
    }

    public Object get(int n, Scriptable scriptable) {
        return Scriptable.NOT_FOUND;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = this.fieldValueMap.get(string);
        if (object == null) {
            object = this.eventOutValueMap.get(string);
        }
        if (object == null) {
            object = this.stdObjects.containsKey(string) ? this.stdObjects.get(string) : this.functionObjects.get(string);
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    public boolean has(String string, Scriptable scriptable) {
        return true;
    }

    public void put(int n, Scriptable scriptable, Object object) {
    }

    public void put(String string, Scriptable scriptable, Object object) {
        Object v = this.fieldValueMap.get(string);
        boolean bl = true;
        if (v == null) {
            v = this.eventOutValueMap.get(string);
            bl = false;
        }
        if (v != null) {
            if (bl) {
                this.fieldValueMap.put(string, object);
            } else {
                this.eventOutValueMap.put(string, object);
                this.changedEventOuts.add(string);
            }
        } else {
            this.functionObjects.put(string, object);
        }
    }

    public void delete(int n) {
    }

    public void delete(String string) {
    }

    public Object[] getIds() {
        return EMPTY_IDS;
    }

    public boolean hasInstance(Scriptable scriptable) {
        for (Scriptable scriptable2 = scriptable.getPrototype(); scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
            if (!scriptable2.equals(this)) continue;
            return true;
        }
        return false;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parentScope = scriptable;
    }

    public Scriptable getPrototype() {
        return null;
    }

    public void setPrototype(Scriptable scriptable) {
    }

    public VRMLNodeType[] parseVrmlString(String string) throws VRMLException, VRMLParseException {
        return this.browser.parseVrmlString(string);
    }

    public FieldFactory getFieldFactory() {
        return this.fieldFactory;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    void addField(String string, Object object) {
        this.fieldValueMap.put(string, object);
        if (object instanceof Scriptable) {
            ((Scriptable)object).setParentScope((Scriptable)this);
        }
    }

    void addEventOut(String string, int n, Object object) {
        this.eventOutValueMap.put(string, object);
        this.eventOutIndexMap.put(n, string);
        if (object instanceof Scriptable) {
            ((Scriptable)object).setParentScope((Scriptable)this);
        }
    }

    boolean hasAnyEventOutChanged() {
        return this.changedEventOuts.size() != 0;
    }

    boolean hasEventOutChanged(int n) {
        Object v;
        Object object = this.eventOutIndexMap.get(n);
        boolean bl = this.changedEventOuts.remove(object);
        if (!bl && (v = this.eventOutValueMap.get(object)) instanceof FieldScriptableObject) {
            bl = ((FieldScriptableObject)v).hasChanged();
        }
        return bl;
    }

    boolean hasEventOutChanged(String string) {
        Object v;
        boolean bl = this.changedEventOuts.remove(string);
        if (!bl && (v = this.eventOutValueMap.get(string)) instanceof FieldScriptableObject) {
            bl = ((FieldScriptableObject)v).hasChanged();
        }
        return bl;
    }
}

