/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;

public class MFBool
extends FieldScriptableObject {
    private static final String OBJECT_NOT_Bool_MSG = "The object you attempted to assign was not a boolean instance";
    private ArrayList valueList;
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFBool() {
        super("MFBool");
        this.valueList = new ArrayList();
    }

    public MFBool(boolean[] blArray, int n) {
        this();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.valueList.add(blArray[i] ? Boolean.TRUE : Boolean.FALSE);
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFBool(boolean[] blArray, int n, int n2) {
        this();
        if (blArray != null && n2 > 0) {
            for (int i = n; i < n2; ++i) {
                this.valueList.add(blArray[i] ? Boolean.TRUE : Boolean.FALSE);
            }
            this.sizeInt.setValue(blArray.length);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFBool(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof Number)) {
                throw new IllegalArgumentException("Non Bool given");
            }
            ++n;
            this.valueList.add((Boolean)objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFBool mFBool = new MFBool(objectArray);
        return mFBool;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = (Boolean)this.valueList.get(n);
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                Boolean bl = Boolean.FALSE;
                if (i == n) {
                    object = bl;
                }
                this.valueList.add(bl);
            }
            this.sizeInt.setValue(this.valueList.size());
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            return this.sizeInt;
        }
        object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof Boolean)) {
            Context.reportError((String)OBJECT_NOT_Bool_MSG);
            return;
        }
        if (n >= this.valueList.size()) {
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)this.valueList.get(i);
            stringBuffer.append(bl);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFBool)) {
            return false;
        }
        MFBool mFBool = (MFBool)object;
        int n = this.valueList.size();
        if (n != mFBool.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFBool.valueList);
    }

    public void updateRawData(boolean[] blArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        for (int i = 0; i < n; ++i) {
            this.valueList.add(blArray[i] ? Boolean.TRUE : Boolean.FALSE);
        }
        this.sizeInt.setValue(n);
    }

    public boolean[] getRawData() {
        boolean[] blArray = new boolean[this.valueList.size()];
        for (int i = 0; i < this.valueList.size(); ++i) {
            blArray[i] = (Boolean)this.valueList.get(i);
        }
        return blArray;
    }

    public void getRawData(boolean[] blArray) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            blArray[i] = (Boolean)this.valueList.get(i);
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

