/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFColor;

public class MFColor
extends FieldScriptableObject {
    private static final String OBJECT_NOT_COLOR_MSG = "The object you attempted to assign was not an SFColor instance";
    private ArrayList valueList = new ArrayList();
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private float[] floatData;
    private float[] workArray;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFColor() {
        super("MFColor");
    }

    public MFColor(float[] fArray, int n) {
        this();
        this.workArray = new float[3];
        int n2 = n / 3;
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFColor(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFColor)) {
                throw new IllegalArgumentException("Non SFColor given");
            }
            ++n;
            this.valueList.add(objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFColor mFColor = new MFColor(objectArray);
        return mFColor;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = this.valueList.get(n);
            if (object == null) {
                int n2 = n * 3;
                this.workArray[0] = this.floatData[n2++];
                this.workArray[1] = this.floatData[n2++];
                this.workArray[2] = this.floatData[n2];
                SFColor sFColor = new SFColor(this.workArray);
                sFColor.setParentScope(this);
                this.valueList.set(n, sFColor);
                object = sFColor;
            }
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                SFColor sFColor = new SFColor();
                sFColor.setParentScope(this);
                this.valueList.add(sFColor);
            }
            this.sizeInt.setValue(this.valueList.size());
            object = (SFColor)this.valueList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFColor)) {
            Context.reportError((String)OBJECT_NOT_COLOR_MSG);
            return;
        }
        SFColor sFColor = (SFColor)object;
        if (sFColor.getParentScope() == null) {
            sFColor.setParentScope(this);
        }
        if (n >= this.valueList.size()) {
            int n2 = n - this.valueList.size();
            this.valueList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(new SFColor());
            }
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            SFColor sFColor = (SFColor)this.valueList.get(i);
            stringBuffer.append(sFColor.toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFColor)) {
            return false;
        }
        MFColor mFColor = (MFColor)object;
        int n = this.valueList.size();
        if (n != mFColor.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFColor.valueList);
    }

    public void updateRawData(float[] fArray, int n) {
        if (this.dataChanged) {
            return;
        }
        int n2 = n / 3;
        this.valueList.clear();
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public float[] getRawData() {
        int n = this.valueList.size();
        if (this.floatData == null || this.floatData.length != n * 3) {
            this.floatData = new float[n * 3];
        }
        if (this.workArray == null) {
            this.workArray = new float[3];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFColor sFColor = (SFColor)this.valueList.get(i);
            if (sFColor != null) {
                sFColor.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                continue;
            }
            n2 += 3;
        }
        return this.floatData;
    }

    public void getRawData(float[] fArray) {
        int n = this.valueList.size();
        if (this.workArray == null) {
            this.workArray = new float[3];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFColor sFColor = (SFColor)this.valueList.get(i);
            if (sFColor != null) {
                sFColor.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                continue;
            }
            n2 += 3;
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

