/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldData;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;

public class MFNode
extends NodeFieldObject {
    private static final String OBJECT_NOT_NODE_MSG = "The object you attempted to assign was not an SFNode instance";
    private ArrayList nodeList = new ArrayList();
    private ReusableInteger sizeInt;
    private ArrayList changedNodes = new ArrayList();
    private boolean localChanges = false;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFNode() {
        super("MFNode");
        this.sizeInt = new ReusableInteger(0L);
    }

    public MFNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        this();
        this.parentNode = vRMLNodeType;
        this.parentFieldIndex = n;
        if (n2 != 0) {
            this.nodeList.ensureCapacity(vRMLNodeTypeArray.length);
            for (int i = 0; i < n2; ++i) {
                if (vRMLNodeTypeArray[i] != null) {
                    SFNode sFNode = new SFNode(vRMLNodeType, n, vRMLNodeTypeArray[i]);
                    sFNode.setParentScope(this);
                    this.nodeList.add(sFNode);
                    continue;
                }
                this.nodeList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFNode(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFNode)) {
                throw new IllegalArgumentException("Non SFNode given");
            }
            SFNode sFNode = (SFNode)objectArray[i];
            if (sFNode.getParentScope() == null) {
                sFNode.setParentScope(this);
            }
            ++n;
            this.nodeList.add(sFNode);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFNode mFNode = new MFNode(objectArray);
        return mFNode;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (n >= 0 && n < this.nodeList.size()) {
            object = this.nodeList.get(n);
            if (this.readOnly) {
                ((FieldScriptableObject)object).setReadOnly();
            }
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFNode)) {
            Context.reportError((String)OBJECT_NOT_NODE_MSG);
            return;
        }
        SFNode sFNode = (SFNode)object;
        sFNode.setParentScope(this);
        if (n >= this.nodeList.size()) {
            for (int i = this.nodeList.size(); i < n; ++i) {
                this.nodeList.add(null);
            }
            this.nodeList.add(object);
            this.sizeInt.setValue(this.nodeList.size());
        } else if (n >= 0) {
            this.nodeList.set(n, object);
        }
        if (object instanceof NodeFieldObject) {
            ((NodeFieldObject)object).realize();
        }
        if (!this.changedNodes.contains(object)) {
            this.changedNodes.add(object);
        }
        this.dataChanged = true;
        this.localChanges = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public Object getChangedFields() {
        Object object;
        Object object2;
        int n = this.changedNodes.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Object> arrayList = null;
        if (n == 1) {
            object2 = (SFNode)this.changedNodes.get(0);
            arrayList = ((SFNode)object2).getChangedFields();
        } else {
            for (int i = 0; i < n; ++i) {
                object = (SFNode)this.changedNodes.get(i);
                Object object3 = ((SFNode)object).getChangedFields();
                if (object3 == null) continue;
                if (arrayList != null) {
                    ArrayList<Object> arrayList2;
                    if (arrayList instanceof ArrayList) {
                        arrayList2 = arrayList;
                    } else {
                        arrayList2 = new ArrayList<Object>();
                        arrayList2.add(arrayList);
                    }
                    if (object3 instanceof ArrayList) {
                        arrayList2.addAll((ArrayList)object3);
                    } else {
                        arrayList2.add(object3);
                    }
                    arrayList = arrayList2;
                    continue;
                }
                arrayList = object3;
            }
        }
        this.changedNodes.clear();
        if (this.localChanges) {
            object2 = new NodeFieldData();
            ((NodeFieldData)object2).node = this.parentNode;
            ((NodeFieldData)object2).fieldIndex = this.parentFieldIndex;
            ((NodeFieldData)object2).value = this;
            this.localChanges = false;
            if (arrayList != null) {
                if (arrayList instanceof ArrayList) {
                    object = arrayList;
                } else {
                    object = new ArrayList<Object>();
                    ((ArrayList)object).add(arrayList);
                }
                ((ArrayList)object).add(object2);
                arrayList = object;
            } else {
                arrayList = object2;
            }
        }
        return arrayList;
    }

    public void realize() {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            SFNode sFNode = (SFNode)this.nodeList.get(i);
            if (sFNode == null) continue;
            sFNode.realize();
        }
    }

    public boolean hasChanged() {
        boolean bl = super.hasChanged();
        if (!bl) {
            int n = this.nodeList.size();
            for (int i = 0; i < n; ++i) {
                SFNode sFNode = (SFNode)this.nodeList.get(i);
                if (sFNode == null || !sFNode.hasChanged()) continue;
                if (!this.changedNodes.contains(sFNode)) {
                    this.changedNodes.add(sFNode);
                }
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n");
        int n = this.nodeList.size();
        for (int i = 0; i < n; ++i) {
            SFNode sFNode = (SFNode)this.nodeList.get(i);
            if (sFNode == null) {
                stringBuffer.append("NULL\n");
                continue;
            }
            stringBuffer.append(sFNode.toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append(" ]\n");
        return stringBuffer.toString();
    }

    public void updateRawData(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        if (this.dataChanged) {
            return;
        }
        if (n != 0) {
            this.nodeList.clear();
            this.nodeList.ensureCapacity(vRMLNodeTypeArray.length);
            for (int i = 0; i < n; ++i) {
                if (vRMLNodeTypeArray[i] != null) {
                    SFNode sFNode = new SFNode(this.parentNode, this.parentFieldIndex, vRMLNodeTypeArray[i]);
                    sFNode.setParentScope(this);
                    this.nodeList.add(sFNode);
                    continue;
                }
                this.nodeList.add(null);
            }
        }
        this.sizeInt.setValue(n);
    }

    public VRMLNodeType[] getRawData() {
        int n = this.nodeList.size();
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        for (int i = 0; i < n; ++i) {
            SFNode sFNode = (SFNode)this.nodeList.get(i);
            if (sFNode == null) continue;
            vRMLNodeTypeArray[i] = sFNode.getImplNode();
        }
        return vRMLNodeTypeArray;
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

