/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec2f;

public class MFVec2f
extends FieldScriptableObject {
    private static final String OBJECT_NOT_VEC_MSG = "The object you attempted to assign was not an SFVec2f instance";
    private ArrayList valueList = new ArrayList();
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private float[] floatData;
    private float[] workArray;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFVec2f() {
        super("MFVec2f");
    }

    public MFVec2f(float[] fArray, int n) {
        this();
        this.workArray = new float[2];
        int n2 = n / 2;
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFVec2f(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFVec2f)) {
                throw new IllegalArgumentException("Non SFVec2f given");
            }
            ++n;
            this.valueList.add(objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFVec2f mFVec2f = new MFVec2f(objectArray);
        return mFVec2f;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = this.valueList.get(n);
            if (object == null) {
                int n2 = n * 2;
                this.workArray[0] = this.floatData[n2++];
                this.workArray[1] = this.floatData[n2];
                SFVec2f sFVec2f = new SFVec2f(this.workArray);
                sFVec2f.setParentScope(this);
                this.valueList.set(n, sFVec2f);
                object = sFVec2f;
            }
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                SFVec2f sFVec2f = new SFVec2f();
                sFVec2f.setParentScope(this);
                this.valueList.add(sFVec2f);
            }
            this.sizeInt.setValue(this.valueList.size());
            object = (SFVec2f)this.valueList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFVec2f)) {
            Context.reportError((String)OBJECT_NOT_VEC_MSG);
            return;
        }
        SFVec2f sFVec2f = (SFVec2f)object;
        if (sFVec2f.getParentScope() == null) {
            sFVec2f.setParentScope(this);
        }
        if (n >= this.valueList.size()) {
            int n2 = n - this.valueList.size();
            this.valueList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(new SFVec2f());
            }
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            SFVec2f sFVec2f = (SFVec2f)this.valueList.get(i);
            stringBuffer.append(sFVec2f.toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFVec2f)) {
            return false;
        }
        MFVec2f mFVec2f = (MFVec2f)object;
        int n = this.valueList.size();
        if (n != mFVec2f.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFVec2f.valueList);
    }

    public void updateRawData(float[] fArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        int n2 = n / 2;
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public float[] getRawData() {
        int n = this.valueList.size();
        if (this.floatData == null || this.floatData.length > n * 2) {
            this.floatData = new float[n * 2];
        }
        int n2 = 0;
        if (this.workArray == null) {
            this.workArray = new float[2];
        }
        for (int i = 0; i < n; ++i) {
            SFVec2f sFVec2f = (SFVec2f)this.valueList.get(i);
            if (sFVec2f != null) {
                sFVec2f.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                continue;
            }
            n2 += 2;
        }
        return this.floatData;
    }

    public void getRawData(float[] fArray) {
        int n = this.valueList.size();
        int n2 = 0;
        if (this.workArray == null) {
            this.workArray = new float[2];
        }
        for (int i = 0; i < n; ++i) {
            SFVec2f sFVec2f = (SFVec2f)this.valueList.get(i);
            if (sFVec2f != null) {
                sFVec2f.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                continue;
            }
            n2 += 2;
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

