/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec3f;

public class Matrix3
extends FieldScriptableObject {
    private static HashSet functionNames;
    private static final double[] IDENTITY;
    private static final double[] DEFAULT_TRANSLATION;
    private static final double[] DEFAULT_ROTATION;
    private static final double[] DEFAULT_SCALE;
    private static final double[] DEFAULT_SCALE_ORIENT;
    private static final double[] DEFAULT_CENTER;
    private double[] matrix = new double[9];
    private double[] workMatrix = new double[9];
    private double[] workTranslation = new double[2];
    private double[] workRotation = new double[3];
    private double[] workScale = new double[2];
    private double[] workOrientation = new double[3];
    private double[] workCenter = new double[2];

    public Matrix3() {
        super("Matrix3");
    }

    public Matrix3(double[] dArray) {
        this();
        if (dArray == null) {
            return;
        }
        int n = dArray.length > 9 ? 9 : dArray.length;
        System.arraycopy(dArray, 0, this.matrix, 0, n);
    }

    public void jsConstructor(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.matrix[0] = Double.isNaN(d) ? 1.0 : d;
        this.matrix[1] = Double.isNaN(d2) ? 0.0 : d2;
        this.matrix[2] = Double.isNaN(d3) ? 0.0 : d3;
        this.matrix[3] = Double.isNaN(d4) ? 0.0 : d4;
        this.matrix[4] = Double.isNaN(d5) ? 1.0 : d5;
        this.matrix[5] = Double.isNaN(d6) ? 0.0 : d6;
        this.matrix[6] = Double.isNaN(d7) ? 0.0 : d7;
        this.matrix[7] = Double.isNaN(d8) ? 0.0 : d8;
        this.matrix[8] = Double.isNaN(d9) ? 1.0 : d9;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < 9;
    }

    public Object get(int n, Scriptable scriptable) {
        if (n < 0 && n > 8) {
            return Scriptable.NOT_FOUND;
        }
        return new Double(this.matrix[n]);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n < 0 && n > 8) {
            return;
        }
        Number number = (Number)object;
        this.matrix[n] = number.doubleValue();
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public void jsFunction_setTransform(Scriptable scriptable, Scriptable scriptable2, Scriptable scriptable3, Scriptable scriptable4, Scriptable scriptable5) {
        if (scriptable != null && !(scriptable instanceof SFVec2f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable2 != null && !(scriptable2 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable3 != null && !(scriptable3 instanceof SFVec2f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable4 != null && !(scriptable4 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable5 != null && !(scriptable5 instanceof SFVec2f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable == null) {
            System.arraycopy(IDENTITY, 0, this.matrix, 0, 9);
            return;
        }
        System.out.println("Need to implement Matrix3.set()");
    }

    public void jsFunction_getTransform(Scriptable scriptable, Scriptable scriptable2, Scriptable scriptable3) {
        if (scriptable != null && !(scriptable instanceof SFVec2f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable2 != null && !(scriptable2 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable3 != null && !(scriptable3 instanceof SFVec2f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec2f sFVec2f = (SFVec2f)scriptable;
        SFVec3f sFVec3f = (SFVec3f)scriptable2;
        SFVec2f sFVec2f2 = (SFVec2f)scriptable3;
        if (sFVec2f == null) {
            return;
        }
        this.workTranslation[0] = this.matrix[6];
        this.workTranslation[1] = this.matrix[7];
        this.workTranslation[2] = this.matrix[8];
        sFVec2f.setRawData(this.workTranslation);
        if (sFVec3f == null) {
            return;
        }
        System.out.println("Need to implement Matrix3.get()");
    }

    public Matrix3 jsFunction_inverse() {
        System.out.println("Need to implement Matrix3.inverse()");
        return new Matrix3(this.workMatrix);
    }

    public Matrix3 jsFunction_transpose() {
        this.workMatrix[0] = this.matrix[0];
        this.workMatrix[1] = this.matrix[3];
        this.workMatrix[2] = this.matrix[6];
        this.workMatrix[3] = this.matrix[1];
        this.workMatrix[4] = this.matrix[4];
        this.workMatrix[5] = this.matrix[7];
        this.workMatrix[6] = this.matrix[2];
        this.workMatrix[7] = this.matrix[5];
        this.workMatrix[8] = this.matrix[8];
        return new Matrix3(this.workMatrix);
    }

    public Matrix3 jsFunction_multLeft(Scriptable scriptable) {
        if (!(scriptable instanceof Matrix3)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        Matrix3 matrix3 = (Matrix3)scriptable;
        double[] dArray = matrix3.matrix;
        return new Matrix3(this.workMatrix);
    }

    public Matrix3 jsFunction_multRight(Scriptable scriptable) {
        if (!(scriptable instanceof Matrix3)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        Matrix3 matrix3 = (Matrix3)scriptable;
        double[] dArray = matrix3.matrix;
        return new Matrix3(this.workMatrix);
    }

    public SFVec3f jsFunction_multVecMatrix(Scriptable scriptable) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        double[] dArray = this.workTranslation;
        double[] dArray2 = this.workScale;
        sFVec3f.getRawData(dArray);
        dArray2[0] = this.matrix[0] * dArray[0] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        dArray2[1] = this.matrix[0] * dArray[1] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        dArray2[2] = this.matrix[0] * dArray[2] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        return new SFVec3f(dArray2);
    }

    public SFVec3f jsFunction_multMatrixVec(Scriptable scriptable) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        double[] dArray = this.workTranslation;
        double[] dArray2 = this.workScale;
        sFVec3f.getRawData(dArray);
        return new SFVec3f(dArray2);
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 9) {
            stringBuffer.append("| ");
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(" |\n");
        }
        return stringBuffer.toString();
    }

    private void manualSetup() {
        System.out.println("Matrix3.manualSetup() not implemented");
    }

    private double determinant(double[] dArray) {
        System.out.println("Matrix3.determinant() not implemented");
        return 0.0;
    }

    static {
        IDENTITY = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        DEFAULT_TRANSLATION = new double[]{0.0, 0.0, 0.0};
        DEFAULT_ROTATION = new double[]{0.0, 0.0, 1.0, 0.0};
        DEFAULT_SCALE = new double[]{1.0, 1.0, 1.0};
        DEFAULT_SCALE_ORIENT = new double[]{0.0, 0.0, 1.0, 0.0};
        DEFAULT_CENTER = new double[]{0.0, 0.0, 0.0};
        functionNames = new HashSet();
        functionNames.add("setTransform");
        functionNames.add("getTransform");
        functionNames.add("inverse");
        functionNames.add("transpose");
        functionNames.add("multLeft");
        functionNames.add("multRight");
        functionNames.add("multVecMatrix");
        functionNames.add("multMatrixVec");
        functionNames.add("toString");
    }
}

