/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldExtras;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldFactory;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldData;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldObject;

public class SFNode
extends NodeFieldObject {
    private static final String NO_CONTENT_MSG = "The class was constructed with a null or empty string, which is not valid for VRML";
    private static final String FIELD_ACCESS_MSG = "You have attempted to access a value that has field access: ";
    private static final String EVENTIN_ACCESS_MSG = "You have attempted to access a value that has eventIn access: ";
    private VRMLNodeType node;
    private FieldExtras extras;
    private FieldFactory fieldFactory;
    private HashSet eventOuts;
    private HashSet exposedFields = new HashSet();
    private HashSet eventIns;
    private HashSet fields;
    private HashMap changedValues;
    private ArrayList nodeFieldNames;
    private HashMap fieldObjects;
    private static HashSet functionNames = new HashSet();

    public SFNode() {
        super("SFNode");
        this.eventOuts = new HashSet();
        this.fields = new HashSet();
        this.eventIns = new HashSet();
        this.changedValues = new HashMap();
        this.nodeFieldNames = new ArrayList();
        this.fieldObjects = new HashMap();
    }

    public SFNode(VRMLNodeType vRMLNodeType) {
        this(null, 0, vRMLNodeType);
    }

    public SFNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        this();
        this.node = vRMLNodeType2;
        this.parentNode = vRMLNodeType;
        this.parentFieldIndex = n;
    }

    public void jsConstructor(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(NO_CONTENT_MSG);
        }
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        if (this.fields.contains(string)) {
            Context.reportRuntimeError((String)(FIELD_ACCESS_MSG + string));
            bl = false;
        } else {
            bl = this.eventOuts.contains(string) || this.exposedFields.contains(string) || this.eventIns.contains(string) ? true : this.loadField(string);
        }
        return bl;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (this.fields.contains(string)) {
            Context.reportRuntimeError((String)(FIELD_ACCESS_MSG + string));
            object = Context.getUndefinedValue();
        } else if (this.eventIns.contains(string)) {
            Context.reportRuntimeError((String)(EVENTIN_ACCESS_MSG + string));
            object = Context.getUndefinedValue();
        } else if (this.eventOuts.contains(string) || this.exposedFields.contains(string)) {
            object = this.getFieldValue(string);
        } else if (this.loadField(string)) {
            if (this.fields.contains(string)) {
                Context.reportRuntimeError((String)(FIELD_ACCESS_MSG + string));
                object = Context.getUndefinedValue();
            } else if (this.eventIns.contains(string)) {
                Context.reportRuntimeError((String)(EVENTIN_ACCESS_MSG + string));
                object = Context.getUndefinedValue();
            } else if (this.eventOuts.contains(string) || this.exposedFields.contains(string)) {
                object = this.getFieldValue(string);
            }
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = Scriptable.NOT_FOUND;
        }
        return object;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (this.fields.contains(string) || this.eventOuts.contains(string)) {
            Context.reportRuntimeError((String)("Not a writable field " + string));
        } else if (this.eventIns.contains(string) || this.exposedFields.contains(string)) {
            if (this.readOnly && !this.scriptField) {
                Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
                return;
            }
            if (!this.loadField(string)) {
                Context.reportRuntimeError((String)("Not a field of this node " + string));
            }
            this.changedValues.put(string, object);
            if (object instanceof NodeFieldObject) {
                ((NodeFieldObject)object).realize();
            }
            this.dataChanged = true;
        } else if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public Object getChangedFields() {
        NodeFieldData nodeFieldData;
        ArrayList<Object> arrayList;
        String string;
        Map.Entry entry;
        int n = this.changedValues.size();
        ArrayList<Object> arrayList2 = null;
        Set set = this.changedValues.entrySet();
        Iterator iterator = set.iterator();
        if (n == 1) {
            entry = iterator.next();
            string = (String)entry.getKey();
            arrayList = entry.getValue();
            nodeFieldData = new NodeFieldData();
            nodeFieldData.node = this.node;
            nodeFieldData.fieldIndex = this.node.getFieldIndex(string);
            nodeFieldData.value = arrayList;
            arrayList2 = nodeFieldData;
        } else if (n > 1) {
            arrayList = new ArrayList(n);
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                Object v = entry.getValue();
                nodeFieldData = new NodeFieldData();
                nodeFieldData.node = this.node;
                nodeFieldData.fieldIndex = this.node.getFieldIndex(string);
                nodeFieldData.value = v;
                arrayList.add(nodeFieldData);
            }
            arrayList2 = arrayList;
        }
        set = null;
        iterator = null;
        entry = null;
        int n2 = this.nodeFieldNames.size();
        for (int i = 0; i < n2; ++i) {
            string = (String)this.nodeFieldNames.get(i);
            if (this.changedValues.containsKey(string)) {
                this.fieldObjects.put(string, this.changedValues.get(string));
                continue;
            }
            NodeFieldObject nodeFieldObject = (NodeFieldObject)this.fieldObjects.get(string);
            Object object = nodeFieldObject.getChangedFields();
            if (object == null) continue;
            if (arrayList2 != null) {
                ArrayList<Object> arrayList3;
                if (arrayList2 instanceof ArrayList) {
                    arrayList3 = arrayList2;
                } else {
                    arrayList3 = new ArrayList<Object>();
                    arrayList3.add(arrayList2);
                }
                if (object instanceof ArrayList) {
                    arrayList3.addAll((ArrayList)object);
                } else {
                    arrayList3.add(object);
                }
                arrayList2 = arrayList3;
                continue;
            }
            arrayList2 = object;
        }
        this.changedValues.clear();
        return arrayList2;
    }

    public void realize() {
        if (this.node != null && !this.node.isSetupFinished()) {
            this.node.setupFinished();
        }
    }

    public boolean hasChanged() {
        boolean bl = super.hasChanged();
        if (!bl) {
            Set set = this.fieldObjects.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FieldScriptableObject fieldScriptableObject;
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                if (!(v instanceof FieldScriptableObject) || !(fieldScriptableObject = (FieldScriptableObject)v).hasChanged()) continue;
                bl = true;
                if (v instanceof NodeFieldObject) continue;
                this.changedValues.put(entry.getKey(), fieldScriptableObject);
            }
        }
        return bl;
    }

    public String toString() {
        VRMLFieldDeclaration vRMLFieldDeclaration;
        if (this.node == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(this.node.getVRMLNodeName());
        stringBuffer.append(" {\n");
        int n = this.node.getNumFields();
        for (int i = 0; i < n && (vRMLFieldDeclaration = this.node.getFieldDeclaration(i)) != null; ++i) {
            int n2 = vRMLFieldDeclaration.getAccessType();
            if (n2 != 3) continue;
            String string = vRMLFieldDeclaration.getName();
            Object object = this.get(string, (Scriptable)this);
            stringBuffer.append("  ");
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(object.toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SFNode)) {
            return false;
        }
        return ((SFNode)object).node == this.node;
    }

    public VRMLNodeType getImplNode() {
        return this.node;
    }

    private boolean loadField(String string) {
        if (this.node == null) {
            return false;
        }
        int n = this.node.getFieldIndex(string);
        if (n == -1) {
            return false;
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = this.node.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            return false;
        }
        switch (vRMLFieldDeclaration.getAccessType()) {
            case 1: {
                this.eventIns.add(string);
                break;
            }
            case 4: {
                this.eventOuts.add(string);
                break;
            }
            case 3: {
                this.exposedFields.add(string);
                int n2 = vRMLFieldDeclaration.getFieldType();
                if (n2 != 11 && n2 != 12) break;
                this.nodeFieldNames.add(string);
                break;
            }
            case 2: {
                this.fields.add(string);
                int n3 = vRMLFieldDeclaration.getFieldType();
                if (n3 != 11 && n3 != 12) break;
                this.nodeFieldNames.add(string);
            }
        }
        return true;
    }

    private Object getFieldValue(String string) {
        Object object = this.fieldObjects.get(string);
        if (this.fieldFactory == null) {
            this.locateFieldFactory();
        }
        if (object != null) {
            object = this.fieldFactory.updateField(object, this.node, string, false);
            this.fieldObjects.put(string, object);
            return object;
        }
        object = this.fieldFactory.createField(this.node, string, false);
        if (object instanceof FieldScriptableObject) {
            FieldScriptableObject fieldScriptableObject = (FieldScriptableObject)object;
            fieldScriptableObject.setParentScope(this);
            if (this.readOnly) {
                fieldScriptableObject.setReadOnly();
            }
        }
        this.fieldObjects.put(string, object);
        return object;
    }

    private void locateFieldFactory() {
        Scriptable scriptable;
        SFNode sFNode = this;
        for (scriptable = this.getParentScope(); !(scriptable instanceof FieldExtras) && scriptable != null; scriptable = scriptable.getParentScope()) {
            sFNode = scriptable;
        }
        if (scriptable instanceof FieldExtras) {
            this.extras = (FieldExtras)scriptable;
            this.fieldFactory = this.extras.getFieldFactory();
        } else if (sFNode instanceof FieldExtras) {
            this.extras = (FieldExtras)((Object)sFNode);
            this.fieldFactory = this.extras.getFieldFactory();
        }
    }

    static {
        functionNames.add("toString");
        functionNames.add("equals");
    }
}

