/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.x3d;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.builtin.MFString;
import org.web3d.vrml.scripting.ecmascript.x3d.AbstractScriptableObject;
import org.web3d.vrml.scripting.ecmascript.x3d.ComponentInfo;
import org.web3d.vrml.scripting.ecmascript.x3d.ComponentInfoArray;
import org.web3d.vrml.scripting.ecmascript.x3d.ProfileInfo;
import org.web3d.vrml.scripting.ecmascript.x3d.ProfileInfoArray;
import org.web3d.vrml.scripting.ecmascript.x3d.Scene;
import org.web3d.vrml.scripting.ecmascript.x3d.X3DExecutionContext;

public class Browser
extends AbstractScriptableObject {
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private HashMap functionObjects = new HashMap();
    private ErrorReporter errorReporter;
    private VRMLExecutionSpace execSpace;
    private BasicScene internalScene;
    private X3DCommonBrowser realBrowser;
    private X3DExecutionContext ecmaScene;
    private RouteManager routeManager;
    private FrameStateManager stateManager;
    private ProfileInfoArray profileListing;
    private ComponentInfoArray componentListing;
    private HashMap nameToProfileMap = new HashMap();

    public Browser(VRMLExecutionSpace vRMLExecutionSpace, BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        super("Browser");
        this.stateManager = frameStateManager;
        this.routeManager = routeManager;
        this.realBrowser = new X3DCommonBrowser(browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.execSpace = vRMLExecutionSpace;
        this.realBrowser.setErrorReporter(this.errorReporter);
        this.internalScene = vRMLExecutionSpace.getContainedScene();
        VRMLNodeFactory vRMLNodeFactory = this.internalScene.getNodeFactory();
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = vRMLNodeFactory.getAvailableComponents();
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length];
        for (int i = 0; i < componentInfoArray.length; ++i) {
            componentInfoArray2[i] = new ComponentInfo(componentInfoArray[i]);
        }
        this.componentListing = new ComponentInfoArray(componentInfoArray2);
        org.web3d.vrml.lang.ProfileInfo[] profileInfoArray = vRMLNodeFactory.getAvailableProfiles();
        ProfileInfo[] profileInfoArray2 = new ProfileInfo[profileInfoArray.length];
        ProfileInfo profileInfo = null;
        SceneMetaData sceneMetaData = this.internalScene.getMetaData();
        String string = sceneMetaData.getProfileName();
        this.nameToProfileMap = new HashMap();
        for (int i = 0; i < profileInfoArray.length; ++i) {
            profileInfoArray2[i] = new ProfileInfo(profileInfoArray[i]);
            String string2 = profileInfoArray[i].getName();
            if (string2.equals(string)) {
                profileInfo = profileInfoArray2[i];
            }
            this.nameToProfileMap.put(string2, profileInfoArray2[i]);
        }
        this.profileListing = new ProfileInfoArray(profileInfoArray2);
        this.ecmaScene = this.internalScene instanceof VRMLScene ? new Scene(vRMLExecutionSpace, routeManager, frameStateManager, profileInfo) : new X3DExecutionContext(vRMLExecutionSpace, routeManager, frameStateManager, profileInfo);
        this.ecmaScene.setParentScope(this);
    }

    public boolean has(String string, Scriptable scriptable) {
        return propertyNames.contains(string) || functionNames.contains(string);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            switch (c) {
                case 'n': {
                    object = this.realBrowser.getName();
                    break;
                }
                case 'v': {
                    object = this.realBrowser.getVersion();
                    break;
                }
                case 'c': {
                    if (string.equals("currentSpeed")) {
                        object = new Float(this.realBrowser.getCurrentSpeed());
                        break;
                    }
                    if (string.equals("currentFrameRate")) {
                        object = new Float(this.realBrowser.getCurrentFrameRate());
                        break;
                    }
                    object = this.ecmaScene;
                    break;
                }
                case 'd': {
                    object = this.realBrowser.getDescription();
                    break;
                }
                case 's': {
                    object = string.equals("supportedProfiles") ? this.profileListing : this.componentListing;
                }
            }
        } else if (functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        return object;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.functionObjects.put(string, object);
        } else if (string.equals("description")) {
            this.realBrowser.setDescription((String)object);
        }
    }

    public void jsFunction_replaceWorld(Scene scene) {
        VRMLScene vRMLScene = (VRMLScene)scene.getInternalScene();
        this.realBrowser.replaceWorld(vRMLScene);
    }

    public Scene jsFunction_createX3DFromString(String string) {
        Scene scene = null;
        try {
            VRMLScene vRMLScene = this.realBrowser.createX3DFromString(string);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            SceneMetaData sceneMetaData = vRMLScene.getMetaData();
            String string2 = sceneMetaData.getProfileName();
            ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string2);
            scene = new Scene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo);
            scene.setParentScope(this);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return scene;
    }

    public Scene jsFunction_createX3DFromURL(MFString mFString) {
        Scene scene = null;
        try {
            String[] stringArray = mFString.getRawData();
            VRMLScene vRMLScene = this.realBrowser.createX3DFromURL(stringArray);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            SceneMetaData sceneMetaData = vRMLScene.getMetaData();
            String string = sceneMetaData.getProfileName();
            ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string);
            scene = new Scene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo);
            scene.setParentScope(this);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return scene;
    }

    public void jsFunction_loadURL(MFString mFString, MFString mFString2) {
        String[] stringArray = mFString2.getRawData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(61);
            String string = stringArray[i].substring(0, n2);
            String string2 = stringArray[i].substring(n2 + 1);
            hashMap.put(string, string2);
        }
        this.realBrowser.loadURL(mFString.getRawData(), hashMap);
    }

    public String jsFunction_getRenderingProperty(String string) {
        this.errorReporter.messageReport("Browser.getRenderingProperty() not implemented yet");
        return null;
    }

    public void jsFunction_addBrowserListener(String string) {
        this.errorReporter.messageReport("Browser.addBrowserListener() not implemented yet");
    }

    public void jsFunction_removeBrowserListener(String string) {
        this.errorReporter.messageReport("Browser.removeBrowserListener() not implemented yet");
    }

    public void jsFunction_println(String string) {
        this.errorReporter.messageReport(string);
    }

    public void jsFunction_println(Object object) {
        this.errorReporter.messageReport(object.toString());
    }

    public void jsFunction_print(String string) {
        this.errorReporter.partialReport(string);
    }

    public void jsFunction_print(Object object) {
        this.errorReporter.partialReport(object.toString());
    }

    public void jsFunction_nextViewpoint() {
        this.realBrowser.nextViewpoint();
    }

    public void jsFunction_previousViewpoint() {
        this.realBrowser.nextViewpoint();
    }

    public void jsFunction_firstViewpoint() {
        this.realBrowser.nextViewpoint();
    }

    public void jsFunction_lastViewpoint() {
        this.realBrowser.nextViewpoint();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.realBrowser.setErrorReporter(this.errorReporter);
        this.ecmaScene.setErrorReporter(this.errorReporter);
    }

    protected void registerFunction(String string, Object object) {
        this.functionObjects.put(string, object);
    }

    protected FunctionObject locateFunction(String string) {
        String string2 = "jsFunction_" + string;
        Method[] methodArray = FunctionObject.findMethods(this.getClass(), (String)string2);
        FunctionObject functionObject = new FunctionObject(string, (Member)methodArray[0], (Scriptable)this);
        this.functionObjects.put(string, functionObject);
        return functionObject;
    }

    static {
        propertyNames.add("name");
        propertyNames.add("version");
        propertyNames.add("currentSpeed");
        propertyNames.add("currentFrameRate");
        propertyNames.add("description");
        propertyNames.add("supportedComponents");
        propertyNames.add("supportedProfiles");
        propertyNames.add("currentScene");
        functionNames = new HashSet();
        functionNames.add("replaceWorld");
        functionNames.add("createX3DFromString");
        functionNames.add("createX3DFromURL");
        functionNames.add("loadURL");
        functionNames.add("importDocument");
        functionNames.add("getRenderingProperty");
        functionNames.add("addBrowserListener");
        functionNames.add("removeBrowserListener");
        functionNames.add("print");
        functionNames.add("println");
        functionNames.add("nextViewpoint");
        functionNames.add("previousViewpoint");
        functionNames.add("firstViewpoint");
        functionNames.add("lastViewpoint");
    }
}

