/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.x3d;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.ecmascript.builtin.MFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;
import org.web3d.vrml.scripting.ecmascript.x3d.AbstractScriptableObject;
import org.web3d.vrml.scripting.ecmascript.x3d.ComponentInfo;
import org.web3d.vrml.scripting.ecmascript.x3d.ComponentInfoArray;
import org.web3d.vrml.scripting.ecmascript.x3d.ExternProtoDeclaration;
import org.web3d.vrml.scripting.ecmascript.x3d.ExternProtoDeclarationArray;
import org.web3d.vrml.scripting.ecmascript.x3d.ProfileInfo;
import org.web3d.vrml.scripting.ecmascript.x3d.ProtoDeclaration;
import org.web3d.vrml.scripting.ecmascript.x3d.ProtoDeclarationArray;
import org.web3d.vrml.scripting.ecmascript.x3d.Route;
import org.web3d.vrml.scripting.ecmascript.x3d.RouteArray;

public class X3DExecutionContext
extends AbstractScriptableObject {
    private static final String INVALID_ROUTE_TYPE_MSG = "deleteRoute() was expecting an object of type Route, but got ";
    private static final String INVALID_ROUTE_SRC_MSG = "addRoute() fromNode argument was expecting an object of type SFNode but got ";
    private static final String INVALID_ROUTE_DEST_MSG = "addRoute() toNode argument was expecting an object of type SFNode but got ";
    private static final String ASCII_ENCODING = "ASCII";
    private static final String VRML_ENCODING = "VRML";
    private static final String XML_ENCODING = "XML";
    private static final String BINARY_ENCODING = "BINARY";
    private static final String SCRIPTED_ENCODING = "SCRIPTED";
    private static final String BIFS_ENCODING = "BIFS";
    private static final String NONE_ENCODING = "NONE";
    private static final String DEFAULT_SPEC_VERSION = "3.0";
    protected static HashSet propertyNames = new HashSet();
    protected static HashSet functionNames;
    private HashMap functionObjects = new HashMap();
    protected final String specVersion;
    protected final String encoding;
    protected final ProfileInfo profile;
    protected final ComponentInfoArray components;
    protected ErrorReporter errorReporter;
    protected final String url;
    protected MFNode rootNodes;
    protected ProtoDeclarationArray protos;
    protected ExternProtoDeclarationArray externprotos;
    protected RouteArray routes;
    private VRMLNodeFactory nodeFactory;
    protected VRMLExecutionSpace executionSpace;
    protected BasicScene scene;
    protected RouteManager routeManager;
    protected FrameStateManager stateManager;
    protected ArrayList nodeWrapperList = new ArrayList();
    protected HashMap nodeWrapperMap = new HashMap();
    protected Map importMap;

    public X3DExecutionContext(VRMLExecutionSpace vRMLExecutionSpace, RouteManager routeManager, FrameStateManager frameStateManager, ProfileInfo profileInfo) {
        super(vRMLExecutionSpace.getContainedScene() instanceof VRMLScene ? "Scene" : "X3DExecutionContext");
        VRMLNodeType[] vRMLNodeTypeArray;
        Object object;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.routeManager = routeManager;
        this.executionSpace = vRMLExecutionSpace;
        this.stateManager = frameStateManager;
        this.scene = this.executionSpace.getContainedScene();
        this.nodeFactory = this.scene.getNodeFactory();
        SceneMetaData sceneMetaData = this.scene.getMetaData();
        this.specVersion = sceneMetaData.getVersion();
        this.profile = profileInfo;
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        VRMLNodeFactory vRMLNodeFactory = basicScene.getNodeFactory();
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = vRMLNodeFactory.getAvailableComponents();
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length];
        for (int i = 0; i < componentInfoArray.length; ++i) {
            componentInfoArray2[i] = new ComponentInfo(componentInfoArray[i]);
        }
        this.components = new ComponentInfoArray(componentInfoArray2);
        this.url = this.scene.getWorldRootURL();
        switch (sceneMetaData.getEncoding()) {
            case 0: {
                this.encoding = SCRIPTED_ENCODING;
                break;
            }
            case 1: {
                this.encoding = ASCII_ENCODING;
                break;
            }
            case 2: {
                this.encoding = VRML_ENCODING;
                break;
            }
            case 3: {
                this.encoding = XML_ENCODING;
                break;
            }
            case 4: {
                this.encoding = BINARY_ENCODING;
                break;
            }
            case 5: {
                this.encoding = BIFS_ENCODING;
                break;
            }
            default: {
                this.encoding = NONE_ENCODING;
            }
        }
        ArrayList arrayList = this.scene.getNodeTemplates();
        int n = 0;
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            if (arrayList.get(i) instanceof VRMLProtoDeclare) {
                ++n;
                continue;
            }
            ++n2;
        }
        ProtoDeclaration[] protoDeclarationArray = new ProtoDeclaration[n];
        ExternProtoDeclaration[] externProtoDeclarationArray = new ExternProtoDeclaration[n2];
        n = 0;
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            object = arrayList.get(i);
            if (object instanceof VRMLProtoDeclare) {
                protoDeclarationArray[n] = new ProtoDeclaration((VRMLProtoDeclare)object, basicScene);
                ++n;
                continue;
            }
            externProtoDeclarationArray[n2] = new ExternProtoDeclaration((VRMLExternProtoDeclare)object, basicScene);
            ++n2;
        }
        this.protos = new ProtoDeclarationArray(protoDeclarationArray);
        this.externprotos = new ExternProtoDeclarationArray(externProtoDeclarationArray);
        ArrayList arrayList2 = this.scene.getRoutes();
        object = new Route[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            vRMLNodeTypeArray = (VRMLNodeType[])arrayList2.get(i);
            VRMLNodeType vRMLNodeType = (VRMLNodeType)vRMLNodeTypeArray.getSourceNode();
            int n4 = vRMLNodeTypeArray.getSourceIndex();
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)vRMLNodeTypeArray.getDestinationNode();
            int n5 = vRMLNodeTypeArray.getDestinationIndex();
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n4);
            String string = vRMLFieldDeclaration.getName();
            vRMLFieldDeclaration = vRMLNodeType2.getFieldDeclaration(n5);
            String string2 = vRMLFieldDeclaration.getName();
            SFNode sFNode = new SFNode(vRMLNodeType);
            sFNode.setParentScope(this);
            SFNode sFNode2 = new SFNode(vRMLNodeType2);
            sFNode2.setParentScope(this);
            object[i] = new Route(sFNode, string, sFNode2, string2);
        }
        this.routes = new RouteArray((Route[])object);
        if (vRMLExecutionSpace instanceof VRMLWorldRootNodeType) {
            VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLExecutionSpace;
            vRMLNodeTypeArray = vRMLWorldRootNodeType.getChildren();
            this.rootNodes = new MFNode(null, 0, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
            this.rootNodes.setParentScope(this);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean has(String string, Scriptable scriptable) {
        return propertyNames.contains(string) || functionNames.contains(string);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = Scriptable.NOT_FOUND;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            switch (c) {
                case 's': {
                    object = this.specVersion;
                    break;
                }
                case 'c': {
                    object = this.components;
                    break;
                }
                case 'w': {
                    object = this.url;
                    break;
                }
                case 'r': {
                    char c2 = string.charAt(2);
                    if (c2 == 'o') {
                        System.out.println("rootNodes: " + this.rootNodes);
                        object = this.rootNodes;
                        break;
                    }
                    object = this.routes;
                    break;
                }
                case 'e': {
                    char c3 = string.charAt(string.length() - 1);
                    if (c3 == 'g') {
                        object = this.encoding;
                        break;
                    }
                    object = this.externprotos;
                    break;
                }
                case 'p': {
                    char c4 = string.charAt(string.length() - 1);
                    object = c4 == 'e' ? this.profile : this.protos;
                }
            }
        } else if (functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        return object;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.functionObjects.put(string, object);
        }
    }

    public Route jsFunction_addRoute(Scriptable scriptable, String string, Scriptable scriptable2, String string2) {
        if (!(scriptable instanceof SFNode)) {
            Context.reportRuntimeError((String)(INVALID_ROUTE_SRC_MSG + scriptable.getClass()));
        }
        if (!(scriptable2 instanceof SFNode)) {
            Context.reportRuntimeError((String)(INVALID_ROUTE_DEST_MSG + scriptable2.getClass()));
        }
        SFNode sFNode = (SFNode)scriptable;
        SFNode sFNode2 = (SFNode)scriptable2;
        VRMLNodeType vRMLNodeType = sFNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = sFNode2.getImplNode();
        int n = vRMLNodeType.getFieldIndex(string);
        int n2 = vRMLNodeType2.getFieldIndex(string2);
        Route route = null;
        try {
            this.routeManager.addRoute(this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
            route = new Route(sFNode, string, sFNode2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            this.errorReporter.errorReport(null, invalidFieldException);
        }
        return route;
    }

    public void jsFunction_deleteRoute(Scriptable scriptable) {
        if (!(scriptable instanceof Route)) {
            Context.reportRuntimeError((String)(INVALID_ROUTE_TYPE_MSG + scriptable.getClass()));
        }
        Route route = (Route)scriptable;
        VRMLNodeType vRMLNodeType = route.srcNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = route.destNode.getImplNode();
        int n = vRMLNodeType.getFieldIndex(route.srcField);
        int n2 = vRMLNodeType2.getFieldIndex(route.destField);
        this.routeManager.removeRoute(this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
    }

    public SFNode jsFunction_createNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeFactory.createVRMLNode(string, false);
        vRMLNodeType.setErrorReporter(this.errorReporter);
        if (vRMLNodeType instanceof VRMLExternalNodeType) {
            ((VRMLExternalNodeType)((Object)vRMLNodeType)).setWorldUrl(this.url);
        }
        vRMLNodeType.setFrameStateManager(this.stateManager);
        SFNode sFNode = new SFNode(vRMLNodeType);
        sFNode.setParentScope(this);
        return sFNode;
    }

    public SFNode jsFunction_createProto(String string) {
        VRMLNodeTemplate vRMLNodeTemplate = this.scene.getNodeTemplate(string);
        VRMLNodeType vRMLNodeType = (VRMLNodeType)vRMLNodeTemplate.createNewInstance(this.scene.getRootNode(), false);
        vRMLNodeType.setFrameStateManager(this.stateManager);
        SFNode sFNode = new SFNode(vRMLNodeType);
        sFNode.setParentScope(this);
        return sFNode;
    }

    public SFNode jsFunction_getNamedNode(String string) {
        Map map = this.scene.getDEFNodes();
        if (string == null || !map.containsKey(string)) {
            return null;
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(string);
        SFNode sFNode = (SFNode)this.nodeWrapperMap.get(vRMLNodeType);
        if (sFNode == null) {
            sFNode = new SFNode(vRMLNodeType);
            sFNode.setParentScope(this);
            this.nodeWrapperMap.put(vRMLNodeType, sFNode);
            this.nodeWrapperList.add(sFNode);
        }
        return sFNode;
    }

    public void jsFunction_updateNamedNode(String string, Scriptable scriptable) {
        this.errorReporter.messageReport("updateNamedNode() not implemented yet");
    }

    public void jsFunction_removeNamedNode(String string) {
        Map map = this.scene.getDEFNodes();
        if (string == null || !map.containsKey(string)) {
            return;
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)map.remove(string);
        SFNode sFNode = (SFNode)this.nodeWrapperMap.get(vRMLNodeType);
        if (sFNode != null) {
            this.nodeWrapperMap.remove(vRMLNodeType);
            this.nodeWrapperList.remove(sFNode);
        }
    }

    public SFNode jsFunction_getImportedNode(String string, String string2) {
        this.errorReporter.messageReport("X3DExecutionContext does not implement getImportedNode() yet");
        return null;
    }

    public void jsFunction_updateImportedNode(String string, String string2) {
        this.errorReporter.messageReport("X3DExecutionContext does not implement updateImportedNode() yet");
        if (this.importMap == null) {
            this.importMap = this.scene.getImports();
        }
    }

    public void jsFunction_removeImportedNode(String string) {
        if (this.importMap == null) {
            this.importMap = this.scene.getImports();
        }
        this.importMap.remove(string);
    }

    BasicScene getInternalScene() {
        return this.scene;
    }

    protected void registerFunction(String string, Object object) {
        this.functionObjects.put(string, object);
    }

    protected FunctionObject locateFunction(String string) {
        String string2 = "jsFunction_" + string;
        Method[] methodArray = FunctionObject.findMethods(this.getClass(), (String)string2);
        if (methodArray == null) {
            this.errorReporter.warningReport("Unknown function: " + string2 + " on: " + this.getClass(), null);
            return null;
        }
        FunctionObject functionObject = new FunctionObject(string, (Member)methodArray[0], (Scriptable)this);
        this.functionObjects.put(string, functionObject);
        return functionObject;
    }

    static {
        propertyNames.add("specificationVersion");
        propertyNames.add("encoding");
        propertyNames.add("profile");
        propertyNames.add("components");
        propertyNames.add("worldURL");
        propertyNames.add("rootNodes");
        propertyNames.add("protos");
        propertyNames.add("externprotos");
        propertyNames.add("routes");
        functionNames = new HashSet();
        functionNames.add("addRoute");
        functionNames.add("deleteRoute");
        functionNames.add("createNode");
        functionNames.add("createProto");
        functionNames.add("getImportedNode");
        functionNames.add("updateImportedNode");
        functionNames.add("removeImportedNode");
        functionNames.add("getNamedNode");
        functionNames.add("updateNamedNode");
        functionNames.add("removeNamedNode");
    }
}

