/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.browser;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.nodes.VRMLTouchSensorNodeType;

public class CursorManager
implements SensorStatusListener,
NavigationStateListener {
    static final String ANCHOR_CURSOR_PROPERTY = "anchor.cursor";
    static final String DRAGSENSOR_CURSOR_PROPERTY = "dragSensor.cursor";
    static final String EXAMINE_CURSOR_PROPERTY = "EXAMINE.cursor";
    static final String LOOKAT_CURSOR_PROPERTY = "LOOKAT.cursor";
    static final String FLY_CURSOR_PROPERTY = "FLY.cursor";
    static final String PAN_CURSOR_PROPERTY = "PAN.cursor";
    static final String TILT_CURSOR_PROPERTY = "TILT.cursor";
    static final String TOUCHSENSOR_CURSOR_PROPERTY = "touchSensor.cursor";
    static final String WALK_CURSOR_PROPERTY = "WALK.cursor";
    static final String NONE_CURSOR_PROPERTY = "NONE.cursor";
    static final String DEFAULT_ANCHOR_CURSOR_VALUE = "images/navigation/link.gif";
    static final String DEFAULT_DRAGSENSOR_CURSOR_VALUE = "images/navigation/drag.gif";
    static final String DEFAULT_EXAMINE_CURSOR_VALUE = "images/navigation/CursorExamine.gif";
    static final String DEFAULT_LOOKAT_CURSOR_VALUE = "images/navigation/CursorLookat.gif";
    static final String DEFAULT_FLY_CURSOR_VALUE = "images/navigation/CursorFly.gif";
    static final String DEFAULT_PAN_CURSOR_VALUE = "images/navigation/CursorPan.gif";
    static final String DEFAULT_TILT_CURSOR_VALUE = "images/navigation/CursorTilt.gif";
    static final String DEFAULT_TOUCHSENSOR_CURSOR_VALUE = "images/navigation/CursorTarget.gif";
    static final String DEFAULT_WALK_CURSOR_VALUE = "images/navigation/CursorWalk.gif";
    static final String DEFAULT_NONE_CURSOR_VALUE = "images/navigation/CursorNone.gif";
    static final Properties DEFAULT_CURSORS = new Properties();
    private Canvas canvas;
    private SensorStatusListener sensorStatusListener;
    private NavigationStateListener navListener;
    private Cursor tsCursor;
    private Cursor dsCursor;
    private Cursor anchorCursor;
    private Cursor navStateCursor;
    private SimpleStack sensorStack;
    private MediaTracker mt;
    private static final String PROPERTY_FILE = "xj3d-skin.properties";
    private Hashtable navCursors;
    private String[] navModes;
    private Toolkit tk;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$web3d$vrml$renderer$common$browser$CursorManager;

    public CursorManager(Canvas canvas, Properties properties) {
        this.canvas = canvas;
        this.navCursors = new Hashtable();
        this.navModes = new String[0];
        this.sensorStack = new SimpleStack();
        this.navStateCursor = Cursor.getDefaultCursor();
        this.tk = Toolkit.getDefaultToolkit();
        this.classLoader = ClassLoader.getSystemClassLoader();
        if (properties == null) {
            properties = this.loadProperties();
        }
        if (properties == null) {
            properties = DEFAULT_CURSORS;
        }
        this.loadCursors(properties);
    }

    public CursorManager(Canvas canvas) {
        this(canvas, null);
    }

    public void setSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.sensorStatusListener = sensorStatusListener;
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navListener = navigationStateListener;
    }

    public void deviceOver(int n, String string) {
        if (this.sensorStatusListener != null) {
            this.sensorStatusListener.deviceOver(n, string);
        }
        switch (n) {
            case 0: {
                this.sensorStack.push((Object)this.anchorCursor);
                this.canvas.setCursor(this.anchorCursor);
                break;
            }
            case 1: {
                this.sensorStack.push((Object)this.tsCursor);
                this.canvas.setCursor(this.tsCursor);
                break;
            }
            case 2: {
                this.sensorStack.push((Object)this.dsCursor);
                this.canvas.setCursor(this.dsCursor);
            }
        }
    }

    public void deviceNotOver(int n) {
        if (this.sensorStatusListener != null) {
            this.sensorStatusListener.deviceNotOver(n);
        }
        this.sensorStack.pop();
        if (!this.sensorStack.isEmpty()) {
            this.canvas.setCursor((Cursor)this.sensorStack.peek());
        } else {
            this.canvas.setCursor(this.navStateCursor);
        }
    }

    public void deviceActivated(int n) {
        if (this.sensorStatusListener != null) {
            this.sensorStatusListener.deviceActivated(n);
        }
    }

    public void linkActivated(String[] stringArray) {
        if (this.sensorStatusListener != null) {
            this.sensorStatusListener.linkActivated(stringArray);
        }
    }

    public void deviceSelectable(VRMLTouchSensorNodeType vRMLTouchSensorNodeType) {
        this.sensorStack.push((Object)this.tsCursor);
        this.canvas.setCursor(this.tsCursor);
    }

    public void deviceNonSelectable(VRMLTouchSensorNodeType vRMLTouchSensorNodeType) {
        this.sensorStack.pop();
        if (!this.sensorStack.isEmpty()) {
            this.canvas.setCursor((Cursor)this.sensorStack.peek());
        } else {
            this.canvas.setCursor(this.navStateCursor);
        }
    }

    public void navigationStateChanged(int n) {
        Cursor cursor;
        if (this.navListener != null) {
            this.navListener.navigationStateChanged(n);
        }
        if ((cursor = (Cursor)this.navCursors.get(this.navModes[n])) == null) {
            System.out.println("Cursor node not found");
        } else {
            this.navStateCursor = cursor;
            this.canvas.setCursor(cursor);
        }
    }

    public void navigationListChanged(String[] stringArray, int n) {
        if (this.navListener != null) {
            this.navListener.navigationListChanged(stringArray, n);
        }
        if (this.navModes.length != n) {
            this.navModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navModes, 0, n);
    }

    private void loadCursors(Properties properties) {
        this.mt = new MediaTracker(this.canvas);
        String string = properties.getProperty(TOUCHSENSOR_CURSOR_PROPERTY, DEFAULT_TOUCHSENSOR_CURSOR_VALUE);
        String string2 = properties.getProperty(DRAGSENSOR_CURSOR_PROPERTY, DEFAULT_DRAGSENSOR_CURSOR_VALUE);
        String string3 = properties.getProperty(ANCHOR_CURSOR_PROPERTY, DEFAULT_ANCHOR_CURSOR_VALUE);
        String string4 = properties.getProperty(WALK_CURSOR_PROPERTY, DEFAULT_WALK_CURSOR_VALUE);
        String string5 = properties.getProperty(FLY_CURSOR_PROPERTY, DEFAULT_FLY_CURSOR_VALUE);
        String string6 = properties.getProperty(PAN_CURSOR_PROPERTY, DEFAULT_PAN_CURSOR_VALUE);
        String string7 = properties.getProperty(TILT_CURSOR_PROPERTY, DEFAULT_TILT_CURSOR_VALUE);
        String string8 = properties.getProperty(EXAMINE_CURSOR_PROPERTY, DEFAULT_EXAMINE_CURSOR_VALUE);
        String string9 = properties.getProperty(LOOKAT_CURSOR_PROPERTY, DEFAULT_LOOKAT_CURSOR_VALUE);
        String string10 = properties.getProperty(NONE_CURSOR_PROPERTY, DEFAULT_NONE_CURSOR_VALUE);
        Image image = this.loadImage(string);
        Image image2 = this.loadImage(string2);
        Image image3 = this.loadImage(string3);
        Image image4 = this.loadImage(string4);
        Image image5 = this.loadImage(string5);
        Image image6 = this.loadImage(string8);
        Image image7 = this.loadImage(string6);
        Image image8 = this.loadImage(string7);
        Image image9 = this.loadImage(string9);
        Image image10 = this.loadImage(string10);
        Point point = new Point();
        this.mt.addImage(image, 0);
        this.mt.addImage(image2, 1);
        this.mt.addImage(image3, 2);
        this.mt.addImage(image4, 3);
        this.mt.addImage(image5, 4);
        this.mt.addImage(image6, 5);
        this.mt.addImage(image7, 6);
        this.mt.addImage(image8, 7);
        this.mt.addImage(image9, 8);
        this.mt.addImage(image10, 9);
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.tsCursor = this.tk.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load touchSensor cursor image: " + string);
            this.tsCursor = Cursor.getPredefinedCursor(1);
        }
        if (image2 != null) {
            point.x = image2.getWidth(null) / 2;
            point.y = image2.getHeight(null) / 2;
            this.dsCursor = this.tk.createCustomCursor(image2, point, null);
        } else {
            System.out.println("Unable to load dragSensor cursor image: " + string2);
            this.dsCursor = Cursor.getPredefinedCursor(1);
        }
        if (image3 != null) {
            point.x = image3.getWidth(null) / 2;
            point.y = image3.getHeight(null) / 2;
            this.anchorCursor = this.tk.createCustomCursor(image3, point, null);
        } else {
            System.out.println("Unable to load anchor cursor image: " + string3);
            this.anchorCursor = Cursor.getPredefinedCursor(1);
        }
        if (image4 != null) {
            point.x = image4.getWidth(null) / 2;
            point.y = image4.getHeight(null) / 2;
            this.navCursors.put("WALK", this.tk.createCustomCursor(image4, point, null));
        } else {
            System.out.println("Unable to load WALK cursor image: " + string4);
            this.navCursors.put("WALK", Cursor.getPredefinedCursor(1));
        }
        if (image5 != null) {
            point.x = image5.getWidth(null) / 2;
            point.y = image5.getHeight(null) / 2;
            this.navCursors.put("FLY", this.tk.createCustomCursor(image5, point, null));
        } else {
            System.out.println("Unable to load FLY cursor image: " + string5);
            this.navCursors.put("FLY", Cursor.getPredefinedCursor(1));
        }
        if (image6 != null) {
            point.x = image6.getWidth(null) / 2;
            point.y = image6.getHeight(null) / 2;
            this.navCursors.put("EXAMINE", this.tk.createCustomCursor(image6, point, null));
        } else {
            System.out.println("Unable to load EXAMINE cursor image: " + string8);
            this.navCursors.put("EXAMINE", Cursor.getPredefinedCursor(1));
        }
        if (image7 != null) {
            point.x = image7.getWidth(null) / 2;
            point.y = image7.getHeight(null) / 2;
            this.navCursors.put("xj3d_PAN", this.tk.createCustomCursor(image7, point, null));
        } else {
            System.out.println("Unable to load xj3d_pan cursor image: " + string6);
            this.navCursors.put("xj3d_PAN", Cursor.getPredefinedCursor(1));
        }
        if (image8 != null) {
            point.x = image8.getWidth(null) / 2;
            point.y = image8.getHeight(null) / 2;
            this.navCursors.put("xj3d_TILT", this.tk.createCustomCursor(image8, point, null));
        } else {
            System.out.println("Unable to load xj3d_tilt cursor image: " + string7);
            this.navCursors.put("xj3d_TILT", Cursor.getPredefinedCursor(1));
        }
        if (image9 != null) {
            point.x = image9.getWidth(null) / 2;
            point.y = image9.getHeight(null) / 2;
            this.navCursors.put("LOOKAT", this.tk.createCustomCursor(image9, point, null));
        } else {
            System.out.println("Unable to load LOOKAT cursor image: " + string9);
        }
        if (image10 != null) {
            point.x = image9.getWidth(null) / 2;
            point.y = image9.getHeight(null) / 2;
            this.navCursors.put("NONE", this.tk.createCustomCursor(image10, point, null));
        } else {
            System.out.println("Unable to load NONE cursor image: " + string10);
            this.navCursors.put("NONE", Cursor.getPredefinedCursor(1));
        }
    }

    private Properties loadProperties() {
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    InputStream inputStream;
                    String string = System.getProperty("user.dir");
                    String string2 = string + File.separator + CursorManager.PROPERTY_FILE;
                    try {
                        inputStream = new FileInputStream(string2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(CursorManager.PROPERTY_FILE);
                    }
                    if (inputStream == null) {
                        inputStream = (class$org$web3d$vrml$renderer$common$browser$CursorManager == null ? (class$org$web3d$vrml$renderer$common$browser$CursorManager = CursorManager.class$("org.web3d.vrml.renderer.common.browser.CursorManager")) : class$org$web3d$vrml$renderer$common$browser$CursorManager).getClassLoader().getResourceAsStream(CursorManager.PROPERTY_FILE);
                    }
                    if (inputStream != null) {
                        Properties properties = new Properties();
                        try {
                            properties.load(inputStream);
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("Error reading properties from xj3d-skin.properties");
                        }
                        return properties;
                    }
                    System.out.println("No skin defined in xj3d-skin.properties");
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error getting cursor properties");
        }
        return properties;
    }

    public Image loadImage(String string) {
        Image image = null;
        if (string == null) {
            return null;
        }
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            image = this.tk.createImage(uRL);
        }
        if (image == null && (uRL = (class$org$web3d$vrml$renderer$common$browser$CursorManager == null ? (class$org$web3d$vrml$renderer$common$browser$CursorManager = CursorManager.class$("org.web3d.vrml.renderer.common.browser.CursorManager")) : class$org$web3d$vrml$renderer$common$browser$CursorManager).getClassLoader().getResource(string)) != null) {
            image = this.tk.createImage(uRL);
        }
        return image;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

