/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.nodes.VRMLViewDependentNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.InputDeviceManager;
import org.web3d.vrml.nodes.runtime.KeyDeviceSensorManager;
import org.web3d.vrml.nodes.runtime.PickingManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.TerrainSectorManager;
import org.web3d.vrml.nodes.runtime.UserInputHandler;
import org.web3d.vrml.renderer.common.input.TimeSensorManager;
import org.web3d.vrml.renderer.common.nodes.AreaListener;
import org.web3d.vrml.renderer.common.nodes.VisibilityListener;
import org.web3d.vrml.util.NodeArray;

public abstract class BaseSensorManager
implements SensorManager {
    protected static final int DEFAULT_EVENT_SIZE = 128;
    protected boolean initialised = false;
    protected TimeSensorManager timeSensors;
    protected KeyDeviceSensorManager keySensors;
    protected PickingManager pickManager;
    protected KeyEvent[] keyEvents;
    protected InputDeviceManager inputManager;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    protected UserInputHandler inputHandler;
    protected BindableNodeManager viewStack;
    protected BindableNodeManager navInfoStack;
    protected BindableNodeManager backgroundStack;
    protected BindableNodeManager fogStack;
    protected VRMLViewpointNodeType currentViewpoint;
    protected boolean navigationEnabled = true;
    protected boolean fogTypeChanged;
    protected boolean fogDetailsChanged;
    protected boolean backgroundSkyChanged;
    protected boolean backgroundGroundChanged;
    protected BackgroundListener backgroundListener;
    protected FogListener fogListener;
    protected float worldScale = 1.0f;
    protected float invWorldScale = 1.0f;
    protected int numVisibilityListeners;
    protected int numAreaListeners;
    protected int numPointingDeviceSensors;

    public BaseSensorManager() {
        this.timeSensors = new TimeSensorManager();
        this.keySensors = new KeyDeviceSensorManager();
        this.keyEvents = new KeyEvent[128];
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.timeSensors.setErrorReporter(errorReporter);
        this.keySensors.setErrorReporter(this.errorReporter);
        if (this.inputManager != null) {
            this.inputManager.setErrorReporter(this.errorReporter);
        }
        if (this.pickManager != null) {
            this.pickManager.setErrorReporter(this.errorReporter);
        }
    }

    public UserInputHandler getUserInputHandler() {
        return this.inputHandler;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public void setTerrainSectorManager(TerrainSectorManager terrainSectorManager) {
    }

    public void setInputManager(InputDeviceManager inputDeviceManager) {
        this.inputManager = inputDeviceManager;
        if (inputDeviceManager != null) {
            inputDeviceManager.setErrorReporter(this.errorReporter);
            inputDeviceManager.initialize(this.inputHandler);
        }
    }

    public void setPickingManager(PickingManager pickingManager) {
        this.pickManager = pickingManager;
        if (pickingManager != null) {
            pickingManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setNavigationStacks(BindableNodeManager bindableNodeManager, BindableNodeManager bindableNodeManager2, BindableNodeManager bindableNodeManager3, BindableNodeManager bindableNodeManager4) {
        this.viewStack = bindableNodeManager;
        this.navInfoStack = bindableNodeManager2;
        this.backgroundStack = bindableNodeManager3;
        this.fogStack = bindableNodeManager4;
    }

    public void removeSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block12: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            if (vRMLSensorNodeType instanceof AreaListener) {
                --this.numAreaListeners;
            } else if (vRMLSensorNodeType instanceof VisibilityListener) {
                --this.numVisibilityListeners;
            }
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 13: 
                case 28: 
                case 36: {
                    --this.numPointingDeviceSensors;
                    if (this.numPointingDeviceSensors != 0) continue block12;
                    this.inputHandler.setTestPointingDevices(false);
                    continue block12;
                }
                case 26: {
                    this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock(null);
                    continue block12;
                }
                case 73: {
                    this.pickManager.removeSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 78: {
                    this.inputManager.removeX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 14: 
                case 42: {
                    int[] nArray = vRMLSensorNodeType.getSecondaryType();
                    block13: for (int j = 0; j < nArray.length; ++j) {
                        switch (nArray[j]) {
                            case 26: {
                                this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                                continue block13;
                            }
                            case 52: 
                            case 53: {
                                ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock(null);
                            }
                        }
                    }
                    continue block12;
                }
                default: {
                    System.out.println("Unhandled node type " + vRMLSensorNodeType.getVRMLNodeName());
                }
            }
        }
    }

    public void addSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block12: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            if (vRMLSensorNodeType instanceof AreaListener) {
                ++this.numAreaListeners;
            } else if (vRMLSensorNodeType instanceof VisibilityListener) {
                ++this.numVisibilityListeners;
            }
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 13: 
                case 28: 
                case 36: {
                    ++this.numPointingDeviceSensors;
                    this.inputHandler.setTestPointingDevices(true);
                    continue block12;
                }
                case 26: {
                    this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock((VRMLClock)this.timeSensors);
                    continue block12;
                }
                case 78: {
                    this.inputManager.addX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 14: 
                case 42: {
                    int[] nArray = vRMLSensorNodeType.getSecondaryType();
                    block13: for (int j = 0; j < nArray.length; ++j) {
                        switch (nArray[j]) {
                            case 26: {
                                this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                                continue block13;
                            }
                            case 52: 
                            case 53: {
                                ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock((VRMLClock)this.timeSensors);
                            }
                        }
                    }
                    continue block12;
                }
                case 73: {
                    this.pickManager.addSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                default: {
                    System.out.println("Unhandled node type " + vRMLSensorNodeType.getVRMLNodeName());
                }
            }
        }
    }

    public void addViewDependentNodes(NodeArray nodeArray) {
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLViewDependentNodeType vRMLViewDependentNodeType = (VRMLViewDependentNodeType)nodeArray.get(i);
            if (vRMLViewDependentNodeType instanceof AreaListener) {
                ++this.numAreaListeners;
                continue;
            }
            if (!(vRMLViewDependentNodeType instanceof VisibilityListener)) continue;
            ++this.numVisibilityListeners;
        }
    }

    public void removeViewDependentNodes(NodeArray nodeArray) {
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLViewDependentNodeType vRMLViewDependentNodeType = (VRMLViewDependentNodeType)nodeArray.get(i);
            if (vRMLViewDependentNodeType instanceof AreaListener) {
                --this.numAreaListeners;
                continue;
            }
            if (!(vRMLViewDependentNodeType instanceof VisibilityListener)) continue;
            --this.numVisibilityListeners;
        }
    }

    public void loadScene(BasicScene basicScene) {
        Object object;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(26);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)arrayList.get(n));
        }
        arrayList = basicScene.getBySecondaryType(52);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            ((VRMLTimeDependentNodeType)object).setVRMLClock((VRMLClock)this.timeSensors);
        }
        arrayList = basicScene.getBySecondaryType(53);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            ((VRMLTimeControlledNodeType)object).setVRMLClock((VRMLClock)this.timeSensors);
        }
        arrayList = basicScene.getByPrimaryType(14);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            if (object instanceof AreaListener) {
                ++this.numAreaListeners;
                continue;
            }
            if (!(object instanceof VisibilityListener)) continue;
            ++this.numVisibilityListeners;
        }
        arrayList = basicScene.getBySecondaryType(88);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            if (object instanceof AreaListener) {
                ++this.numAreaListeners;
                continue;
            }
            if (!(object instanceof VisibilityListener)) continue;
            ++this.numVisibilityListeners;
        }
        arrayList = basicScene.getByPrimaryType(36);
        this.numPointingDeviceSensors += arrayList.size();
        arrayList = basicScene.getByPrimaryType(13);
        this.numPointingDeviceSensors += arrayList.size();
        arrayList = basicScene.getBySecondaryType(28);
        this.numPointingDeviceSensors += arrayList.size();
        this.inputHandler.setTestPointingDevices(this.numPointingDeviceSensors != 0);
        arrayList = basicScene.getByPrimaryType(78);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (VRMLDeviceSensorNodeType)arrayList.get(n);
            this.inputManager.addX3DNode((VRMLDeviceSensorNodeType)object);
        }
        if (this.pickManager != null) {
            this.pickManager.loadScene(basicScene);
        }
    }

    public void unloadScene(BasicScene basicScene) {
        Object object;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(26);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)arrayList.get(n));
        }
        if (this.pickManager != null) {
            this.pickManager.unloadScene(basicScene);
        }
        arrayList = basicScene.getByPrimaryType(78);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (VRMLDeviceSensorNodeType)arrayList.get(n);
            this.inputManager.removeX3DNode((VRMLDeviceSensorNodeType)object);
        }
        arrayList = basicScene.getByPrimaryType(14);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            if (object instanceof AreaListener) {
                --this.numAreaListeners;
                continue;
            }
            if (!(object instanceof VisibilityListener)) continue;
            --this.numVisibilityListeners;
        }
        arrayList = basicScene.getBySecondaryType(88);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            if (object instanceof AreaListener) {
                --this.numAreaListeners;
                continue;
            }
            if (!(object instanceof VisibilityListener)) continue;
            --this.numVisibilityListeners;
        }
        arrayList = basicScene.getByPrimaryType(36);
        this.numPointingDeviceSensors -= arrayList.size();
        arrayList = basicScene.getByPrimaryType(13);
        this.numPointingDeviceSensors -= arrayList.size();
        arrayList = basicScene.getBySecondaryType(28);
        this.numPointingDeviceSensors -= arrayList.size();
        this.inputHandler.setTestPointingDevices(this.numPointingDeviceSensors != 0);
    }

    public void clear() {
        this.timeSensors.clear();
        this.keySensors.clear();
        this.numAreaListeners = 0;
        this.numVisibilityListeners = 0;
        this.numPointingDeviceSensors = 0;
    }

    public VRMLClock getVRMLClock() {
        return this.timeSensors;
    }

    protected void initialise() {
        this.initialised = true;
        VRMLBindableNodeType vRMLBindableNodeType = this.fogStack.getBoundNode();
        int n = vRMLBindableNodeType.getFieldIndex("fogType");
        int n2 = vRMLBindableNodeType.getFieldIndex("visibilityRange");
        int n3 = vRMLBindableNodeType.getFieldIndex("color");
        this.fogListener = new FogListener(n, n2, n3);
        vRMLBindableNodeType = this.backgroundStack.getBoundNode();
        int n4 = vRMLBindableNodeType.getFieldIndex("groundAngle");
        int n5 = vRMLBindableNodeType.getFieldIndex("groundColor");
        int n6 = vRMLBindableNodeType.getFieldIndex("skyAngle");
        int n7 = vRMLBindableNodeType.getFieldIndex("skyColor");
        this.backgroundListener = new BackgroundListener(n4, n5, n6, n7);
    }

    protected void clearChangeFlags() {
        this.fogTypeChanged = false;
        this.fogDetailsChanged = false;
        this.backgroundSkyChanged = false;
        this.backgroundGroundChanged = false;
    }

    private class FogListener
    implements VRMLNodeListener {
        private int typeField;
        private int visibilityField;
        private int colourField;

        FogListener(int n, int n2, int n3) {
            this.typeField = n;
            this.visibilityField = n2;
            this.colourField = n3;
        }

        public void fieldChanged(int n) {
            if (n == this.typeField) {
                BaseSensorManager.this.fogTypeChanged = true;
            }
            if (n == this.visibilityField || n == this.colourField) {
                BaseSensorManager.this.fogDetailsChanged = true;
            }
        }
    }

    private class BackgroundListener
    implements VRMLNodeListener {
        private int gndAngleField;
        private int gndColorField;
        private int skyAngleField;
        private int skyColorField;

        BackgroundListener(int n, int n2, int n3, int n4) {
            this.gndAngleField = n;
            this.gndColorField = n2;
            this.skyAngleField = n3;
            this.skyColorField = n4;
        }

        public void fieldChanged(int n) {
            if (n == this.gndAngleField || n == this.gndColorField) {
                BaseSensorManager.this.backgroundGroundChanged = true;
            }
            if (n == this.skyAngleField || n == this.skyColorField) {
                BaseSensorManager.this.backgroundSkyChanged = true;
            }
        }
    }
}

