/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.PropertyTools;
import org.web3d.vrml.nodes.NetworkRoleListener;
import org.web3d.vrml.nodes.VRMLDISManagerNodeType;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNetworkInterfaceNodeType;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;
import org.web3d.vrml.renderer.common.input.dis.DISConnectionId;
import org.web3d.vrml.renderer.common.input.dis.DISId;
import org.web3d.vrml.renderer.common.input.dis.DISXMLConnectionHandler;
import org.web3d.vrml.renderer.common.input.dis.LinkedList;
import org.web3d.vrml.renderer.common.input.dis.LiveListEntryDX;
import org.web3d.vrml.renderer.common.input.dis.NodeMapEntry;
import org.web3d.vrml.renderer.common.input.dis.OrderNQuat4dConverger;
import org.web3d.vrml.renderer.common.input.dis.OrderNVector3dConverger;
import org.web3d.vrml.renderer.common.input.dis.RungeKuttaSolver;
import org.web3d.vrml.renderer.common.input.dis.WriterListEntryDX;
import org.web3d.vrml.renderer.common.input.dis.WriterMapEntryDX;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ProtocolDataUnitType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;

public class DISXMLProtocolHandler
implements NetworkProtocolHandler,
NetworkRoleListener {
    private static final String PROTOCOL = "DIS";
    private static final int INACTIVE_CHECK_TIME = 1000;
    private static final int INACTIVE_TIME = 5000;
    private static final int HEARTBEAT_CHECK_TIME = 4500;
    private static final int DEFAULT_ORDER = 2;
    private static final int DEFAULT_CONVERGENCE_INTERVAL = 200;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private HashMap connections = new HashMap();
    private Map nodeMap = Collections.synchronizedMap(new HashMap());
    private Map writerMap = Collections.synchronizedMap(new HashMap());
    private LinkedList liveList = new LinkedList();
    private LinkedList writerList = new LinkedList();
    private long lastCheck;
    private long lastHeartCheck;
    private List managerList = Collections.synchronizedList(new ArrayList());
    private Set notifiedSet = Collections.synchronizedSet(new HashSet());
    private DISId disId = new DISId(0, 0, 0);
    float[] tempPositionArray = new float[3];
    float[] tempPositionArray2 = new float[3];
    float[] goalOrientation = new float[3];
    private float[] rotation = new float[4];
    private float[] currOrientation;
    private float[] positionArray = new float[3];
    private boolean smooth = true;
    protected static final boolean DEFAULT_DEADRECKON_POSITION = true;
    protected static final String DEADRECKON_POSITION_PROP = "org.web3d.vrml.renderer.common.dis.input.deadreckonPosition";
    protected static final boolean deadreckonPosition = PropertyTools.fetchSystemProperty((String)"org.web3d.vrml.renderer.common.dis.input.deadreckonPosition", (boolean)true);
    protected static final boolean DEFAULT_DEADRECKON_ROTATION = true;
    protected static final String DEADRECKON_ROTATION_PROP = "org.web3d.vrml.renderer.common.dis.input.deadreckonRotation";
    protected static final boolean deadreckonRotation = PropertyTools.fetchSystemProperty((String)"org.web3d.vrml.renderer.common.dis.input.deadreckonRotation", (boolean)true);
    Matrix3d rotationMatrix;
    Matrix3d psiMat;
    Matrix3d thetaMat;
    Matrix3d phiMat;
    Quat4d rotationQuat;
    Vector3d translationVec;
    Vector3d[] translationDerivatives;
    Vector3d[] rotationDerivatives;
    RungeKuttaSolver solver;
    AxisAngle4d axisTemp;

    public DISXMLProtocolHandler() {
        this.currOrientation = new float[3];
        this.rotationMatrix = new Matrix3d();
        this.psiMat = new Matrix3d();
        this.thetaMat = new Matrix3d();
        this.phiMat = new Matrix3d();
        this.rotationQuat = new Quat4d();
        this.translationVec = new Vector3d();
        this.translationDerivatives = new Vector3d[]{new Vector3d(), new Vector3d()};
        this.rotationDerivatives = new Vector3d[]{new Vector3d()};
        this.axisTemp = new AxisAngle4d();
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void processNetworkTraffic() {
        ProtocolDataUnitType protocolDataUnitType;
        WriterListEntryDX writerListEntryDX;
        WriterListEntryDX writerListEntryDX2;
        VRMLDISNodeType vRMLDISNodeType;
        long l = System.currentTimeMillis();
        boolean bl = l - this.lastCheck >= 1000L;
        LiveListEntryDX liveListEntryDX = (LiveListEntryDX)this.liveList.head;
        LiveListEntryDX liveListEntryDX2 = (LiveListEntryDX)this.liveList.head;
        int n = 0;
        while (liveListEntryDX != null) {
            VRMLDISManagerNodeType vRMLDISManagerNodeType;
            NodeMapEntry nodeMapEntry;
            vRMLDISNodeType = liveListEntryDX.node;
            if (liveListEntryDX.newPackets) {
                if (liveListEntryDX.currFire != null) {
                    vRMLDISNodeType.packetArrived(liveListEntryDX.currFire);
                    liveListEntryDX.currFire = null;
                } else if (liveListEntryDX.currDetonate != null) {
                    vRMLDISNodeType.packetArrived(liveListEntryDX.currDetonate);
                    liveListEntryDX.closeEnough = true;
                    liveListEntryDX.currDetonate = null;
                } else if (liveListEntryDX.currEspdu != null) {
                    vRMLDISNodeType.packetArrived((ProtocolDataUnitType)liveListEntryDX.currEspdu);
                    EntityStatePduType entityStatePduType = liveListEntryDX.currEspdu;
                    this.rotationMatrix.setIdentity();
                    writerListEntryDX2 = entityStatePduType.getEntityOrientation();
                    this.eulersToMatrix(writerListEntryDX2.getPhi(), writerListEntryDX2.getTheta(), writerListEntryDX2.getPsi(), this.rotationMatrix);
                    this.rotationQuat.set(this.rotationMatrix);
                    writerListEntryDX = entityStatePduType.getEntityLocation();
                    protocolDataUnitType = new Vector3d(writerListEntryDX.getX(), -writerListEntryDX.getZ(), writerListEntryDX.getY());
                    nodeMapEntry = entityStatePduType.getEntityLinearVelocity();
                    this.translationDerivatives[0].set((double)nodeMapEntry.getX(), (double)(-nodeMapEntry.getZ()), (double)nodeMapEntry.getY());
                    DeadReckoningParametersType deadReckoningParametersType = entityStatePduType.getDeadReckoningParameters();
                    vRMLDISManagerNodeType = deadReckoningParametersType.getEntityAngularVelocity();
                    this.rotationDerivatives[0].set((double)vRMLDISManagerNodeType.getX(), (double)(-vRMLDISManagerNodeType.getZ()), (double)vRMLDISManagerNodeType.getY());
                    Vector3Float vector3Float = deadReckoningParametersType.getEntityLinearAcceleration();
                    this.translationDerivatives[1].set((double)vector3Float.getX(), (double)(-vector3Float.getZ()), (double)vector3Float.getY());
                    liveListEntryDX.translationConverger.convergeTo((Vector3d)protocolDataUnitType, this.translationDerivatives, l, l);
                    liveListEntryDX.rotationConverger.convergeTo(this.rotationQuat, this.rotationDerivatives, l, l);
                }
                liveListEntryDX.newPackets = false;
                ++n;
            }
            if (bl && l - liveListEntryDX.lastTime >= 5000L) {
                liveListEntryDX.node.setIsActive(false);
                this.liveList.remove(liveListEntryDX, liveListEntryDX2);
                int n2 = vRMLDISNodeType.getSiteID();
                int n3 = vRMLDISNodeType.getAppID();
                int n4 = vRMLDISNodeType.getEntityID();
                this.disId.setValue(n2, n3, n4);
                nodeMapEntry = (NodeMapEntry)this.nodeMap.get(this.disId);
                if (nodeMapEntry == null) {
                    System.out.println("DIS Entry null on timeout");
                } else {
                    nodeMapEntry.listEntry = null;
                    int n5 = this.managerList.size();
                    for (int i = 0; i < n5; ++i) {
                        vRMLDISManagerNodeType = (VRMLDISManagerNodeType)this.managerList.get(i);
                        vRMLDISManagerNodeType.entityRemoved(vRMLDISNodeType);
                        this.notifiedSet.remove(this.disId);
                    }
                }
            }
            if ((deadreckonPosition || deadreckonRotation) && !liveListEntryDX.closeEnough) {
                float f = (float)(l - liveListEntryDX.lastTime) * 0.001f;
                writerListEntryDX2 = liveListEntryDX.currEspdu.getDeadReckoningParameters();
                writerListEntryDX = liveListEntryDX.currEspdu.getEntityLinearVelocity();
                protocolDataUnitType = writerListEntryDX2.getEntityLinearAcceleration();
                if ((double)writerListEntryDX.getX() <= 1.0E-4 && (double)writerListEntryDX.getY() <= 1.0E-4 && (double)writerListEntryDX.getZ() <= 1.0E-4 && (double)protocolDataUnitType.getX() <= 1.0E-4 && (double)protocolDataUnitType.getY() <= 1.0E-4 && (double)protocolDataUnitType.getZ() <= 1.0E-4) {
                    liveListEntryDX.closeEnough = true;
                }
                if (deadreckonPosition) {
                    liveListEntryDX.translationConverger.getValue(l, this.translationVec);
                    this.tempPositionArray[0] = (float)this.translationVec.x;
                    this.tempPositionArray[1] = (float)this.translationVec.y;
                    this.tempPositionArray[2] = (float)this.translationVec.z;
                    int n6 = vRMLDISNodeType.getFieldIndex("translation");
                    vRMLDISNodeType.setValue(n6, this.tempPositionArray, 3);
                }
                if (deadreckonRotation) {
                    liveListEntryDX.rotationConverger.getValue(l, this.rotationQuat);
                    this.rotationQuat.normalize();
                    this.axisTemp.set(this.rotationQuat);
                    this.rotation[0] = (float)this.axisTemp.x;
                    this.rotation[1] = (float)this.axisTemp.y;
                    this.rotation[2] = (float)this.axisTemp.z;
                    this.rotation[3] = (float)this.axisTemp.angle;
                    int n7 = vRMLDISNodeType.getFieldIndex("rotation");
                    vRMLDISNodeType.setValue(n7, this.rotation, 4);
                }
                liveListEntryDX.prevDt = f;
            }
            liveListEntryDX2 = liveListEntryDX;
            liveListEntryDX = (LiveListEntryDX)liveListEntryDX.next;
        }
        if (bl) {
            this.lastCheck = l;
        }
        writerListEntryDX2 = (WriterListEntryDX)this.writerList.head;
        writerListEntryDX = (WriterListEntryDX)this.writerList.head;
        while (writerListEntryDX2 != null) {
            WriterMapEntryDX writerMapEntryDX;
            vRMLDISNodeType = writerListEntryDX2.node;
            if (vRMLDISNodeType.valuesToWrite()) {
                writerListEntryDX2.lastTime = l;
                protocolDataUnitType = vRMLDISNodeType.getStateDX();
                this.disId.setValue(vRMLDISNodeType.getSiteID(), vRMLDISNodeType.getAppID(), vRMLDISNodeType.getEntityID());
                writerMapEntryDX = (WriterMapEntryDX)this.writerMap.get(this.disId);
                writerMapEntryDX.writer.write(protocolDataUnitType);
            } else if (l - writerListEntryDX2.lastTime >= 4500L) {
                writerListEntryDX2.lastTime = l;
                protocolDataUnitType = vRMLDISNodeType.getStateDX();
                this.disId.setValue(vRMLDISNodeType.getSiteID(), vRMLDISNodeType.getAppID(), vRMLDISNodeType.getEntityID());
                writerMapEntryDX = (WriterMapEntryDX)this.writerMap.get(this.disId);
                writerMapEntryDX.writer.write(protocolDataUnitType);
            }
            writerListEntryDX = writerListEntryDX2;
            writerListEntryDX2 = (WriterListEntryDX)writerListEntryDX2.next;
        }
    }

    public void addNode(VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType) {
        VRMLDISNodeType vRMLDISNodeType = (VRMLDISNodeType)vRMLNetworkInterfaceNodeType;
        vRMLDISNodeType.addNetworkRoleListener((NetworkRoleListener)this);
        String string = vRMLDISNodeType.getAddress();
        int n = vRMLDISNodeType.getPort();
        String string2 = vRMLDISNodeType.getUsername();
        String string3 = vRMLDISNodeType.getPassword();
        String[] stringArray = vRMLDISNodeType.getAuthServer();
        String string4 = vRMLDISNodeType.getMucServer();
        String string5 = vRMLDISNodeType.getMucRoom();
        switch (vRMLDISNodeType.getRole()) {
            case 3: {
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISXMLConnectionHandler dISXMLConnectionHandler = (DISXMLConnectionHandler)this.connections.get(dISConnectionId);
                if (dISXMLConnectionHandler == null) {
                    dISXMLConnectionHandler = new DISXMLConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n, string2, string3, stringArray, string4, string5);
                    this.connections.put(dISConnectionId, dISXMLConnectionHandler);
                }
                int n2 = vRMLDISNodeType.getSiteID();
                int n3 = vRMLDISNodeType.getAppID();
                int n4 = vRMLDISNodeType.getEntityID();
                this.managerList.add(vRMLDISNodeType);
                break;
            }
            case 0: {
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISXMLConnectionHandler dISXMLConnectionHandler = (DISXMLConnectionHandler)this.connections.get(dISConnectionId);
                if (dISXMLConnectionHandler == null) {
                    dISXMLConnectionHandler = new DISXMLConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n, string2, string3, stringArray, string4, string5);
                    this.connections.put(dISConnectionId, dISXMLConnectionHandler);
                }
                int n5 = vRMLDISNodeType.getSiteID();
                int n6 = vRMLDISNodeType.getAppID();
                int n7 = vRMLDISNodeType.getEntityID();
                int n8 = vRMLNetworkInterfaceNodeType.getFieldIndex("marking");
                VRMLFieldData vRMLFieldData = vRMLNetworkInterfaceNodeType.getFieldValue(n8);
                System.out.println("New DIS node: siteID: " + n5 + " appID: " + n6 + " " + " entityID: " + n7 + " marking: " + vRMLFieldData.stringValue);
                DISId dISId = new DISId(n5, n6, n7);
                this.nodeMap.put(dISId, new NodeMapEntry((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, null));
                WriterListEntryDX writerListEntryDX = new WriterListEntryDX(vRMLDISNodeType);
                WriterMapEntryDX writerMapEntryDX = new WriterMapEntryDX((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, writerListEntryDX, dISXMLConnectionHandler);
                this.writerMap.put(dISId, writerMapEntryDX);
                break;
            }
            case 1: {
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISXMLConnectionHandler dISXMLConnectionHandler = (DISXMLConnectionHandler)this.connections.get(dISConnectionId);
                if (dISXMLConnectionHandler == null) {
                    dISXMLConnectionHandler = new DISXMLConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n, string2, string3, stringArray, string4, string5);
                    this.connections.put(dISConnectionId, dISXMLConnectionHandler);
                }
                int n9 = vRMLDISNodeType.getSiteID();
                int n10 = vRMLDISNodeType.getAppID();
                int n11 = vRMLDISNodeType.getEntityID();
                DISId dISId = new DISId(n9, n10, n11);
                WriterListEntryDX writerListEntryDX = new WriterListEntryDX(vRMLDISNodeType);
                WriterMapEntryDX writerMapEntryDX = new WriterMapEntryDX((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, writerListEntryDX, dISXMLConnectionHandler);
                this.writerMap.put(dISId, writerMapEntryDX);
                this.writerList.add(writerListEntryDX);
                break;
            }
            case 2: {
                System.out.println("Logic to change Inactive to Writer not implemented");
            }
        }
    }

    public void removeNode(VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType) {
        System.out.println("DISProtocolHandler: removeNode not implemented");
    }

    public void clear() {
        if (this.connections.size() > 0) {
            System.out.println("DISProtocolHandler: clear not implemented");
        }
    }

    public void roleChanged(int n, Object object) {
        VRMLDISNodeType vRMLDISNodeType = (VRMLDISNodeType)object;
        long l = System.currentTimeMillis();
        switch (n) {
            case 2: {
                break;
            }
            case 0: {
                EntityStatePduType entityStatePduType;
                System.out.println("*** Now READER: " + this);
                WriterListEntryDX writerListEntryDX = (WriterListEntryDX)this.writerList.head;
                WriterListEntryDX writerListEntryDX2 = (WriterListEntryDX)this.writerList.head;
                while (writerListEntryDX != null) {
                    if (writerListEntryDX.node == vRMLDISNodeType) {
                        this.writerList.remove(writerListEntryDX, writerListEntryDX2);
                        break;
                    }
                    writerListEntryDX2 = writerListEntryDX;
                    writerListEntryDX = (WriterListEntryDX)writerListEntryDX.next;
                }
                NodeMapEntry nodeMapEntry = new NodeMapEntry(vRMLDISNodeType, null);
                this.nodeMap.put(this.disId.clone(), nodeMapEntry);
                LiveListEntryDX liveListEntryDX = new LiveListEntryDX(vRMLDISNodeType, l);
                nodeMapEntry.listEntry = liveListEntryDX;
                liveListEntryDX.lastEspdu = entityStatePduType = (EntityStatePduType)vRMLDISNodeType.getStateDX();
                liveListEntryDX.currEspdu = entityStatePduType;
                liveListEntryDX.rotationConverger = new OrderNQuat4dConverger(2, 200, null);
                liveListEntryDX.translationConverger = new OrderNVector3dConverger(2, 200, null);
                HeaderType headerType = entityStatePduType.getPduHeader();
                liveListEntryDX.espduTimestamp = headerType.getTimestamp();
                liveListEntryDX.closeEnough = false;
                liveListEntryDX.avgTime = 0.01f;
                liveListEntryDX.newPackets = true;
                this.liveList.add(liveListEntryDX);
                break;
            }
            case 1: {
                System.out.println("*** Now WRITER: " + this);
                LiveListEntryDX liveListEntryDX = (LiveListEntryDX)this.liveList.head;
                LiveListEntryDX liveListEntryDX2 = (LiveListEntryDX)this.liveList.head;
                while (liveListEntryDX != null) {
                    if (liveListEntryDX.node == vRMLDISNodeType) {
                        this.liveList.remove(liveListEntryDX, liveListEntryDX2);
                        break;
                    }
                    liveListEntryDX2 = liveListEntryDX;
                    liveListEntryDX = (LiveListEntryDX)liveListEntryDX.next;
                }
                WriterListEntryDX writerListEntryDX = new WriterListEntryDX(vRMLDISNodeType);
                this.writerList.add(writerListEntryDX);
            }
        }
    }

    private void DRPosition(EntityStatePduType entityStatePduType, float f, float[] fArray) {
        float f2 = f * f;
        Vector3Double vector3Double = entityStatePduType.getEntityLocation();
        Vector3Float vector3Float = entityStatePduType.getEntityLinearVelocity();
        DeadReckoningParametersType deadReckoningParametersType = entityStatePduType.getDeadReckoningParameters();
        Vector3Float vector3Float2 = deadReckoningParametersType.getEntityLinearAcceleration();
        fArray[0] = (float)(vector3Double.getX() + (double)(f * vector3Float.getX()) + (double)(f2 * vector3Float2.getX()));
        fArray[1] = (float)(-vector3Double.getZ() - (double)(f * vector3Float.getZ()) - (double)(f2 * vector3Float2.getZ()));
        fArray[2] = (float)(vector3Double.getY() + (double)(f * vector3Float.getY()) + (double)(f2 * vector3Float2.getY()));
    }

    private void DROrientation(EntityStatePduType entityStatePduType, float f, float[] fArray) {
        EulerAnglesType eulerAnglesType = entityStatePduType.getEntityOrientation();
        DeadReckoningParametersType deadReckoningParametersType = entityStatePduType.getDeadReckoningParameters();
        Vector3Float vector3Float = deadReckoningParametersType.getEntityAngularVelocity();
        float f2 = eulerAnglesType.getPhi() + f * vector3Float.getX();
        float f3 = eulerAnglesType.getTheta() + f * vector3Float.getY();
        float f4 = eulerAnglesType.getPsi() + f * vector3Float.getZ();
        fArray[0] = -f4;
        fArray[1] = f2;
        fArray[2] = f3;
    }

    private void smooth3Floats(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2) {
        fArray3[0] = (fArray2[0] + fArray[0]) / 2.0f;
        fArray3[1] = (fArray2[1] + fArray[1]) / 2.0f;
        fArray3[2] = (fArray2[2] + fArray[2]) / 2.0f;
    }

    private float normalize2(float f) {
        float f2 = f;
        float f3 = (float)Math.PI * 2;
        while ((double)f2 > Math.PI) {
            f2 -= f3;
        }
        while ((double)f2 <= -Math.PI) {
            f2 += f3;
        }
        return f2;
    }

    private void fixEulers(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray2[i] + this.normalize2(this.normalize2(fArray[i]) - this.normalize2(fArray2[i]));
        }
    }

    private float SqrDeltaFloats(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += (fArray[i] - fArray2[i]) * (fArray[i] - fArray2[i]);
        }
        return f;
    }

    private void eulersToMatrix(double d, double d2, double d3, Matrix3d matrix3d) {
        this.psiMat.setIdentity();
        this.psiMat.rotY(-d3);
        this.thetaMat.rotZ(d2);
        this.phiMat.rotX(d);
        matrix3d.mul(this.phiMat, this.thetaMat);
        matrix3d.mul(this.psiMat);
    }
}

