/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.renderer.common.input.dis.RungeKuttaSolver;
import org.web3d.vrml.renderer.common.input.dis.Solver;
import org.web3d.vrml.renderer.common.input.dis.SolverTarget;

public class Vector3dVariable
implements SolverTarget {
    private Vector3d value = new Vector3d();
    private Vector3d[] derivatives;
    private long referenceTime;
    private Solver solver;
    double[] state;
    double[] results;

    public Vector3dVariable(int n, Solver solver) {
        this.derivatives = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.derivatives[i] = new Vector3d();
        }
        this.state = new double[3 + n * 3];
        this.results = new double[3 + this.derivatives.length * 3];
        this.solver = solver != null ? solver : new RungeKuttaSolver(this.state.length);
    }

    public void set(Vector3d vector3d, Vector3d[] vector3dArray, long l) {
        this.value.set((Tuple3d)vector3d);
        this.referenceTime = l;
        for (int i = 0; i < this.derivatives.length; ++i) {
            if (i < vector3dArray.length) {
                this.derivatives[i].set((Tuple3d)vector3dArray[i]);
                continue;
            }
            this.derivatives[i].set(0.0, 0.0, 0.0);
        }
    }

    public void set(Vector3dVariable vector3dVariable) {
        this.value.set((Tuple3d)vector3dVariable.value);
        this.referenceTime = vector3dVariable.referenceTime;
        for (int i = 0; i < this.derivatives.length; ++i) {
            this.derivatives[i].set((Tuple3d)vector3dVariable.derivatives[i]);
        }
    }

    public void interpolate(Vector3dVariable vector3dVariable, Vector3dVariable vector3dVariable2, double d, long l) {
        if (l > this.referenceTime) {
            vector3dVariable.makeCurrent(l);
            vector3dVariable2.makeCurrent(l);
            this.value.interpolate((Tuple3d)vector3dVariable.value, (Tuple3d)vector3dVariable2.value, d);
            for (int i = 0; i < this.derivatives.length; ++i) {
                this.derivatives[i].interpolate((Tuple3d)vector3dVariable.derivatives[i], (Tuple3d)vector3dVariable2.derivatives[i], d);
            }
            this.referenceTime = l;
        }
    }

    public void makeCurrent(long l) {
        if (l > this.referenceTime) {
            double d = (double)(l - this.referenceTime) / 1000.0;
            this.encodeState();
            this.solver.solve(this, this.state, d, 0.001, this.results);
            this.decodeState(this.results);
            this.referenceTime = l;
        }
    }

    public void encodeState() {
        this.state[0] = this.value.x;
        this.state[1] = this.value.y;
        this.state[2] = this.value.z;
        int n = 3;
        int n2 = 0;
        while (n < this.state.length) {
            this.state[n] = this.derivatives[n2].x;
            this.state[n + 1] = this.derivatives[n2].y;
            this.state[n + 2] = this.derivatives[n2].z;
            n += 3;
            ++n2;
        }
    }

    public void decodeState(double[] dArray) {
        this.value.x = dArray[0];
        this.value.y = dArray[1];
        this.value.z = dArray[2];
        int n = 3;
        int n2 = 0;
        while (n < dArray.length) {
            this.derivatives[n2].set(dArray[n], dArray[n + 1], dArray[n + 2]);
            n += 3;
            ++n2;
        }
    }

    public void getValue(Vector3d vector3d) {
        vector3d.set((Tuple3d)this.value);
    }

    public void getDerivatives(Vector3d[] vector3dArray) {
        for (int i = 0; i < vector3dArray.length; ++i) {
            if (i < this.derivatives.length) {
                vector3dArray[i].set((Tuple3d)this.derivatives[i]);
                continue;
            }
            vector3dArray[i].set(0.0, 0.0, 0.0);
        }
    }

    public void getRatesOfChange(double[] dArray, double d, double[] dArray2) {
        for (int i = 0; i < dArray.length - 3; i += 3) {
            dArray2[i] = dArray[i + 3];
            dArray2[i + 1] = dArray[i + 4];
            dArray2[i + 2] = dArray[i + 5];
        }
        dArray2[i] = 0.0;
        dArray2[i + 1] = 0.0;
        dArray2[i + 2] = 0.0;
    }
}

