/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.movie;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import org.web3d.vrml.renderer.common.input.movie.Renderer;
import org.web3d.vrml.renderer.common.input.movie.VideoStreamHandler;

public class VideoRenderer
extends Renderer
implements javax.media.renderer.VideoRenderer {
    private VideoFormat[] supportedFormats;
    private BufferedImage image;
    private int imageWidth;
    private int imageHeight;
    private int imageLineStride;
    private VideoStreamHandler streamHandler;
    private boolean started;
    private boolean callbacksEnabled = true;
    static /* synthetic */ Class array$I;

    public VideoRenderer(VideoStreamHandler videoStreamHandler) {
        this.streamHandler = videoStreamHandler;
        this.started = false;
        int n = 0xFF0000;
        int n2 = 65280;
        int n3 = 255;
        RGBFormat rGBFormat = new RGBFormat(null, -1, array$I == null ? (array$I = VideoRenderer.class$("[I")) : array$I, -1.0f, 32, n, n2, n3, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[1];
        this.supportedFormats[0] = rGBFormat;
    }

    public void enableCallbacks(boolean bl) {
        this.callbacksEnabled = bl;
    }

    public String getName() {
        return "Xj3D Video Renderer";
    }

    public Component getComponent() {
        return null;
    }

    public boolean setComponent(Component component) {
        return false;
    }

    public void setBounds(Rectangle rectangle) {
    }

    public Rectangle getBounds() {
        return null;
    }

    public Format setInputFormat(Format format) {
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        this.imageLineStride = rGBFormat.getLineStride();
        if (this.image == null || n != this.imageWidth || n2 != this.imageHeight) {
            this.imageWidth = n;
            this.imageHeight = n2;
            this.image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.streamHandler.videoStreamFormat(this.imageWidth, this.imageHeight);
        }
        RGBFormat rGBFormat2 = new RGBFormat(dimension, rGBFormat.getMaxDataLength(), rGBFormat.getDataType(), rGBFormat.getFrameRate(), rGBFormat.getBitsPerPixel(), rGBFormat.getRedMask(), rGBFormat.getGreenMask(), rGBFormat.getBlueMask(), rGBFormat.getPixelStride(), rGBFormat.getLineStride(), 0, rGBFormat.getEndian());
        return rGBFormat2;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public int process(Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        if (nArray != null) {
            this.image.setRGB(0, 0, this.imageWidth, this.imageHeight, nArray, 0, this.imageLineStride);
            this.streamHandler.videoStreamFrame(this.image);
        }
        return 0;
    }

    public void stop() {
        if (this.callbacksEnabled && this.started) {
            this.started = false;
            this.streamHandler.videoStreamStop();
        }
    }

    public void start() {
        if (this.callbacksEnabled && !this.started) {
            this.started = true;
            this.streamHandler.videoStreamStart();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

