/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;

public abstract class AbstractDynamicFieldNode
implements VRMLNodeType {
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String METADATA_PROTO_MSG = "Proto does not describe a Metadata object";
    protected static final String METADATA_NODE_MSG = "Node does not describe a Metadata object";
    protected static final String FIELD_CLASH_MSG = "The same field has been declared twice in this node, but the data types or access types are different.";
    protected ErrorReporter errorReporter;
    protected final Map fieldIndexMap;
    protected final List fieldDeclList;
    protected final String nodeName;
    protected final VRMLFieldData fieldData;
    protected FrameStateManager stateManager;
    protected int fieldCount;
    protected boolean isVrml97;
    protected boolean inSetup;
    private VRMLNodeListener nodeListener;
    protected int refCount;
    private int[] nodeFields;
    protected VRMLNodeType vfMetadata;
    protected VRMLProtoInstance pMetadata;

    public AbstractDynamicFieldNode(String string) {
        this.nodeName = string;
        this.fieldIndexMap = new HashMap();
        this.fieldDeclList = new ArrayList();
        this.fieldData = new VRMLFieldData();
        this.fieldCount = 0;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void allEventsComplete() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public synchronized int updateRefCount(boolean bl) {
        int n = this.refCount++;
        return n;
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public void setMetadataObject(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType == null) {
            this.vfMetadata = null;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLMetadataObjectNodeType) {
            this.vfMetadata = vRMLNodeType;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLMetadataObjectNodeType)) {
                throw new InvalidFieldValueException(METADATA_PROTO_MSG);
            }
            this.vfMetadata = vRMLNodeType2;
            this.pMetadata = vRMLProtoInstance;
        } else {
            throw new InvalidFieldValueException(METADATA_NODE_MSG);
        }
    }

    public VRMLNodeType getMetadataObject() {
        return this.vfMetadata;
    }

    public void setupFinished() {
        int n;
        VRMLFieldDeclaration vRMLFieldDeclaration;
        int n2;
        int n3 = this.fieldDeclList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n2);
            n = vRMLFieldDeclaration.getFieldType();
            if (n != 12 && n != 11) continue;
            ++n4;
        }
        if (n4 == 0) {
            return;
        }
        this.nodeFields = new int[n4];
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n2);
            n = vRMLFieldDeclaration.getFieldType();
            if (n != 12 && n != 11) continue;
            this.nodeFields[n4++] = this.getFieldIndex(vRMLFieldDeclaration.getName());
        }
        if (this.pMetadata != null) {
            this.pMetadata.setupFinished();
        } else if (this.vfMetadata != null) {
            this.vfMetadata.setupFinished();
        }
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)this.fieldIndexMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return this.nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return (VRMLFieldDeclaration)this.fieldDeclList.get(n);
    }

    public int getNumFields() {
        return this.fieldDeclList.size();
    }

    protected void checkNodeType(VRMLNodeType vRMLNodeType) {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals(this.nodeName)) {
            throw new IllegalArgumentException("The supplied node cannot be copied as it's type is wrong. The type supplied is type");
        }
    }

    public boolean isVRML97() {
        return this.isVrml97;
    }

    protected void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.get(string);
        if (n != null) {
            VRMLFieldDeclaration vRMLFieldDeclaration2 = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType() || vRMLFieldDeclaration.getAccessType() != vRMLFieldDeclaration.getAccessType()) {
                throw new FieldExistsException(FIELD_CLASH_MSG, string);
            }
        }
        this.fieldIndexMap.put(string, new Integer(this.fieldCount));
        this.fieldDeclList.add(vRMLFieldDeclaration);
        int n2 = this.fieldCount++;
        return n2;
    }

    public void deleteField(int n) throws InvalidFieldException, IndexOutOfBoundsException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException();
        }
        this.fieldDeclList.set(n, null);
        this.fieldIndexMap.remove(vRMLFieldDeclaration.getName());
    }

    public void deleteField(VRMLFieldDeclaration vRMLFieldDeclaration) throws InvalidFieldException, IndexOutOfBoundsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.remove(string);
        if (n == null) {
            throw new InvalidFieldException("No field here", string);
        }
        this.fieldDeclList.set(n, null);
    }

    public List getAllFields() {
        ArrayList arrayList = new ArrayList();
        int n = this.fieldDeclList.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.fieldDeclList.get(i);
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }
}

