/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;

public abstract class AbstractNode
implements VRMLNodeType {
    public static final int FIELD_METADATA = 0;
    public static final int LAST_NODE_INDEX = 0;
    private static final String VRML_META_MSG = "The metadata field is not valid in VRML97";
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String INIT_ONLY_WRITE_MSG = "You have attempted to write to an initializeOnly field: ";
    protected static final String METADATA_PROTO_MSG = "Proto does not describe a Metadata object";
    protected static final String METADATA_NODE_MSG = "Node does not describe a Metadata object";
    protected final String nodeName;
    protected final VRMLFieldData fieldData;
    private final IntHashMap userData;
    protected ErrorReporter errorReporter;
    protected boolean[] hasChanged;
    protected boolean inSetup;
    protected boolean isDEF;
    protected boolean isStatic;
    protected int vrmlMajorVersion;
    protected int vrmlMinorVersion;
    protected FrameStateManager stateManager;
    private VRMLNodeListener nodeListener;
    protected int refCount;
    protected VRMLNodeType vfMetadata;
    protected VRMLProtoInstance pMetadata;

    public AbstractNode(String string) {
        this.nodeName = string;
        this.userData = new IntHashMap();
        this.fieldData = new VRMLFieldData();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.inSetup = true;
        this.isDEF = false;
    }

    public void allEventsComplete() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public int[] getSecondaryType() {
        return TypeConstants.NO_SECONDARY_TYPE;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.vrmlMajorVersion = n;
        this.vrmlMinorVersion = n2;
        this.isStatic = bl;
    }

    public abstract int[] getNodeFieldIndices();

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException(this.getClass().getName() + " Invalid index in getUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException(this.getClass().getName() + " Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    public void setMetadataObject(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.vrmlMajorVersion == 2) {
            throw new InvalidFieldException(VRML_META_MSG);
        }
        if (vRMLNodeType == null) {
            this.vfMetadata = null;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLMetadataObjectNodeType) {
            this.vfMetadata = vRMLNodeType;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLMetadataObjectNodeType)) {
                throw new InvalidFieldValueException(METADATA_PROTO_MSG);
            }
            this.vfMetadata = vRMLNodeType2;
            this.pMetadata = vRMLProtoInstance;
        } else {
            throw new InvalidFieldValueException(METADATA_NODE_MSG);
        }
        if (!this.inSetup) {
            this.hasChanged[0] = true;
            this.fireFieldChanged(0);
        }
    }

    public VRMLNodeType getMetadataObject() {
        if (this.pMetadata != null) {
            return this.pMetadata;
        }
        return this.vfMetadata;
    }

    public boolean isSetupFinished() {
        return !this.inSetup;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        if (this.pMetadata != null) {
            this.pMetadata.setupFinished();
        } else if (this.vfMetadata != null) {
            this.vfMetadata.setupFinished();
        }
        this.inSetup = false;
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public synchronized int updateRefCount(boolean bl) {
        int n = this.refCount++;
        return n;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public boolean hasFieldChanged(int n) {
        boolean bl = false;
        if (n < 0 || n > this.hasChanged.length - 1) {
            return bl;
        }
        bl = this.hasChanged[n];
        this.hasChanged[n] = false;
        return bl;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            if (n == 0) {
                if (this.pMetadata != null) {
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.pMetadata);
                } else {
                    vRMLNodeType.setValue(n2, this.vfMetadata);
                }
            } else {
                System.out.println("Invalid field for AbstractNode.sendRoute");
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        if (n != 0) {
            throw new InvalidFieldException("Invalid Index: " + n + " " + this);
        }
        this.fieldData.clear();
        this.fieldData.nodeValue = this.pMetadata != null ? this.pMetadata : this.vfMetadata;
        this.fieldData.dataType = (short)7;
        return this.fieldData;
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(int): Invalid Index: " + n);
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(int[]): Invalid Index: " + n);
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(boolean): Invalid Index: " + n);
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(boolean[]): Invalid Index: " + n);
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(float): Invalid Index: " + n);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(float[]): Invalid Index: " + n);
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(long): Invalid Index: " + n);
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(long[]): Invalid Index: " + n);
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(double): Invalid Index: " + n);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(double[]): Invalid Index: " + n);
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(String): Invalid Index: " + n);
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(String): Invalid Index: " + n);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (n != 0) {
            throw new InvalidFieldException(this.getClass().getName() + " setValue(VRMLNode): Invalid Index: " + n);
        }
        this.setMetadataObject(vRMLNodeType);
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        throw new InvalidFieldException(this.getClass().getName() + " setValue(VRMLNode[]): Invalid Index: " + n);
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        System.out.println(this.nodeName + " notifyExtern ProtoLoaded not implemented.");
    }

    protected void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void checkNodeType(VRMLNodeType vRMLNodeType) {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals(this.nodeName)) {
            throw new IllegalArgumentException("The supplied node cannot be copied as it's type is wrong. The type supplied is type");
        }
    }

    protected static void checkSecondaryType(VRMLNodeType vRMLNodeType, int n, String string) {
        int[] nArray = vRMLNodeType.getSecondaryType();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new InvalidFieldValueException(string);
        }
    }

    protected static void checkSecondaryType(VRMLNodeType vRMLNodeType, int[] nArray, String string) {
        int[] nArray2 = vRMLNodeType.getSecondaryType();
        boolean bl = false;
        int n = nArray2.length;
        int n2 = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (nArray2[i] != nArray[j]) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            throw new InvalidFieldValueException(string);
        }
    }
}

