/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import java.util.ArrayList;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLBindableNodeListener;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseBindableNode
extends AbstractNode
implements VRMLBindableNodeType,
VRMLTimeDependentNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{5, 52};
    protected static final int FIELD_BIND = 1;
    protected static final int FIELD_BIND_TIME = 2;
    protected static final int FIELD_IS_BOUND = 3;
    protected static final int LAST_BINDABLE_INDEX = 3;
    protected double vfBindTime;
    protected boolean vfIsBound = false;
    protected boolean isOnStack;
    private ArrayList listeners = new ArrayList();
    private VRMLClock vrmlClock;
    private boolean notifyPending = false;

    protected BaseBindableNode(String string) {
        super(string);
    }

    protected void copy(VRMLBindableNodeType vRMLBindableNodeType) {
        this.vfBindTime = vRMLBindableNodeType.getBindTime();
        this.vfIsBound = vRMLBindableNodeType.getIsBound();
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
        if (this.notifyPending) {
            this.vfBindTime = this.vrmlClock.getTime();
            if (!this.inSetup) {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                if (this.listeners.size() != 0) {
                    this.fireIsBoundChanged(this.vfIsBound);
                }
            }
        }
    }

    public void setOnStack(boolean bl) {
        this.isOnStack = bl;
    }

    public void setBind(boolean bl, boolean bl2, double d) {
        if (!bl && !this.isOnStack) {
            return;
        }
        this.vfIsBound = bl;
        this.vfBindTime = d;
        if (!this.inSetup) {
            if (bl2) {
                this.fireIsBoundChanged(this.vfIsBound);
            }
            this.hasChanged[3] = true;
            this.hasChanged[2] = true;
            this.fireFieldChanged(3);
            this.fireFieldChanged(2);
        }
    }

    public boolean getIsBound() {
        return this.vfIsBound;
    }

    public double getBindTime() {
        return this.vfBindTime;
    }

    public void addBindableNodeListener(VRMLBindableNodeListener vRMLBindableNodeListener) {
        if (vRMLBindableNodeListener == null || this.listeners.contains(vRMLBindableNodeListener)) {
            return;
        }
        boolean bl = this.listeners.size() == 0 && this.notifyPending;
        this.listeners.add(vRMLBindableNodeListener);
        if (bl) {
            this.fireIsBoundChanged(this.vfIsBound);
        }
    }

    public void removeBindableNodeListener(VRMLBindableNodeListener vRMLBindableNodeListener) {
        if (vRMLBindableNodeListener == null || !this.listeners.contains(vRMLBindableNodeListener)) {
            return;
        }
        this.listeners.remove(vRMLBindableNodeListener);
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfIsBound;
                this.fieldData.dataType = 1;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfBindTime;
                this.fieldData.dataType = (short)5;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfBindTime);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfIsBound);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (this.vrmlClock != null) {
                    this.setBind(bl, true, this.vrmlClock.getTime());
                    break;
                }
                this.notifyPending = true;
                this.setBind(bl, true, 0.0);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    protected void fireIsBoundChanged(boolean bl) {
        int n = this.listeners.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            try {
                VRMLBindableNodeListener vRMLBindableNodeListener = (VRMLBindableNodeListener)this.listeners.get(i);
                vRMLBindableNodeListener.nodeIsBound((VRMLNodeType)this, bl);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending node bound message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.notifyPending = false;
    }
}

