/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import java.util.ArrayList;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometricPropertyNodeType;
import org.web3d.vrml.nodes.VRMLNodeComponentListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseComponentGeometryNode
extends AbstractNode
implements VRMLComponentGeometryNodeType,
VRMLNodeComponentListener {
    protected static final int FIELD_COORD = 1;
    protected static final int FIELD_COLOR = 2;
    protected static final int FIELD_NORMAL = 3;
    protected static final int FIELD_TEXCOORD = 4;
    protected static final int FIELD_SOLID = 5;
    protected static final int FIELD_CCW = 6;
    protected static final int FIELD_COLORPERVERTEX = 7;
    protected static final int FIELD_NORMALPERVERTEX = 8;
    protected static final int FIELD_FOG_COORD = 9;
    protected static final int FIELD_ATTRIBS = 10;
    protected static final int LAST_GEOMETRY_INDEX = 10;
    protected static final int COORDS_CHANGED = 1;
    protected static final int NORMALS_CHANGED = 2;
    protected static final int TEXCOORDS_CHANGED = 4;
    protected static final int COLORS_CHANGED = 8;
    protected static final int FOG_CHANGED = 16;
    protected static final int ATTRIB_CHANGED = 32;
    protected static final int UNLIT_COLORS_CHANGED = 64;
    protected static final int COORDS_INDEX_CHANGED = 256;
    protected static final int NORMALS_INDEX_CHANGED = 512;
    protected static final int TEXCOORDS_INDEX_CHANGED = 1024;
    protected static final int COLORS_INDEX_CHANGED = 2048;
    protected static final int FOG_INDEX_CHANGED = 4096;
    protected static final int ATTRIB_INDEX_CHANGED = 8192;
    protected static final String BAD_PROTO_MSG = "Proto does not describe a GeometryComponent object";
    protected static final String BAD_NODE_MSG = "Node does not describe a GeometryComponent object";
    protected static final String COORD_PROTO_MSG = "Proto does not describe a X3DCoordinateNode object";
    protected static final String COORD_NODE_MSG = "Node does not describe a X3DCoordinateNode object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a X3DColorNode object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a X3DColorNode object";
    protected static final String FOG_PROTO_MSG = "Proto does not describe a FogCoordinate object";
    protected static final String FOG_NODE_MSG = "Node does not describe a FogCoordinate object";
    protected static final String ATTRIB_PROTO_MSG = "Proto does not describe a VertexAttributes object";
    protected static final String ATTRIB_NODE_MSG = "Node does not describe a VertexAttributes object";
    protected VRMLProtoInstance pColor;
    protected VRMLColorNodeType vfColor;
    protected VRMLProtoInstance pCoord;
    protected VRMLCoordinateNodeType vfCoord;
    protected VRMLProtoInstance pNormal;
    protected VRMLNormalNodeType vfNormal;
    protected VRMLProtoInstance pTexCoord;
    protected VRMLTextureCoordinateNodeType vfTexCoord;
    protected VRMLProtoInstance pFogCoord;
    protected VRMLGeometricPropertyNodeType vfFogCoord;
    protected boolean vfColorPerVertex = true;
    protected boolean vfNormalPerVertex = true;
    protected boolean vfSolid = true;
    protected boolean vfCcw = true;
    protected int changeFlags;
    protected ArrayList vfAttribs = new ArrayList(1);
    protected boolean localColors = false;
    protected ArrayList localColorsListeners = new ArrayList(1);

    protected BaseComponentGeometryNode(String string) {
        super(string);
    }

    public boolean hasLocalColors() {
        return this.localColors;
    }

    public boolean hasLocalColorAlpha() {
        return this.vfColor != null && this.vfColor.getNumColorComponents() == 4;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
        if (localColorsListener != null) {
            this.localColorsListeners.add(localColorsListener);
        }
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
        this.localColorsListeners.remove(localColorsListener);
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
        System.out.println("TexCoordGenMode changes not implemented");
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public int getNumSets() {
        if (this.vfTexCoord == null) {
            return 0;
        }
        return this.vfTexCoord.getNumSets();
    }

    public String getTexCoordGenMode(int n) {
        if (this.vfTexCoord == null) {
            return null;
        }
        return this.vfTexCoord.getTexCoordGenMode(n);
    }

    protected void copy(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType) {
        this.vfSolid = vRMLComponentGeometryNodeType.isSolid();
        this.vfCcw = vRMLComponentGeometryNodeType.isCCW();
        this.vfColorPerVertex = vRMLComponentGeometryNodeType.hasColorPerVertex();
        this.vfNormalPerVertex = vRMLComponentGeometryNodeType.hasNormalPerVertex();
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return this.vfCcw;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public VRMLNodeType[] getComponents() {
        int n = 5;
        if (this.vfCoord == null && this.pCoord == null) {
            --n;
        }
        if (this.vfNormal == null && this.pNormal == null) {
            --n;
        }
        if (this.vfTexCoord == null && this.pTexCoord == null) {
            --n;
        }
        if (this.vfColor == null && this.pColor == null) {
            --n;
        }
        if (this.vfFogCoord == null && this.pFogCoord == null) {
            --n;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        n = 0;
        if (this.pCoord != null) {
            vRMLNodeTypeArray[n++] = this.pCoord;
        } else if (this.vfCoord != null) {
            vRMLNodeTypeArray[n++] = this.vfCoord;
        }
        if (this.pNormal != null) {
            vRMLNodeTypeArray[n++] = this.pNormal;
        } else if (this.vfNormal != null) {
            vRMLNodeTypeArray[n++] = this.vfNormal;
        }
        if (this.pTexCoord != null) {
            vRMLNodeTypeArray[n++] = this.pTexCoord;
        } else if (this.vfTexCoord != null) {
            vRMLNodeTypeArray[n++] = this.vfTexCoord;
        }
        if (this.pColor != null) {
            vRMLNodeTypeArray[n++] = this.pColor;
        } else if (this.vfColor != null) {
            vRMLNodeTypeArray[n++] = this.vfColor;
        }
        if (this.pFogCoord != null) {
            vRMLNodeTypeArray[n++] = this.pFogCoord;
        } else if (this.vfFogCoord != null) {
            vRMLNodeTypeArray[n++] = this.vfFogCoord;
        }
        return vRMLNodeTypeArray;
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        if (vRMLNodeTypeArray == null) {
            this.pCoord = null;
            this.pColor = null;
            this.pNormal = null;
            this.pTexCoord = null;
            this.pFogCoord = null;
            this.vfCoord = null;
            this.vfColor = null;
            this.vfNormal = null;
            this.vfTexCoord = null;
            this.vfFogCoord = null;
            this.setCoordinateNode(null);
            this.setColorNode(null);
            this.setNormalNode(null);
            this.setTexCoordNode(null);
            this.setFogCoordinateNode(null);
        } else {
            block6: for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                VRMLProtoInstance vRMLProtoInstance;
                VRMLNodeType vRMLNodeType = vRMLNodeTypeArray[i];
                if (vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                } else {
                    vRMLProtoInstance = null;
                }
                switch (vRMLNodeType.getPrimaryType()) {
                    case 11: {
                        this.pCoord = vRMLProtoInstance;
                        this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType;
                        if (this.vfCoord != null) {
                            this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                        }
                        this.changeFlags |= 1;
                        continue block6;
                    }
                    case 34: {
                        this.pNormal = vRMLProtoInstance;
                        this.vfNormal = (VRMLNormalNodeType)vRMLNodeType;
                        if (this.vfNormal != null) {
                            this.vfNormal.addComponentListener((VRMLNodeComponentListener)this);
                        }
                        this.changeFlags |= 2;
                        continue block6;
                    }
                    case 48: {
                        this.pTexCoord = vRMLProtoInstance;
                        this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType;
                        if (this.vfTexCoord != null) {
                            this.vfTexCoord.addComponentListener((VRMLNodeComponentListener)this);
                        }
                        this.changeFlags |= 4;
                        continue block6;
                    }
                    case 9: {
                        this.pColor = vRMLProtoInstance;
                        this.vfColor = (VRMLColorNodeType)vRMLNodeType;
                        if (this.vfColor != null) {
                            this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                            if (!this.localColors) {
                                this.fireLocalColorsChanged(true);
                            }
                            this.localColors = true;
                        } else {
                            if (this.localColors) {
                                this.fireLocalColorsChanged(false);
                            }
                            this.localColors = false;
                        }
                        this.changeFlags |= 8;
                        continue block6;
                    }
                    default: {
                        this.pFogCoord = vRMLProtoInstance;
                        this.vfFogCoord = (VRMLGeometricPropertyNodeType)vRMLNodeType;
                        if (this.vfFogCoord != null) {
                            this.vfFogCoord.addComponentListener((VRMLNodeComponentListener)this);
                        }
                        this.changeFlags |= 0x10;
                    }
                }
            }
            if (!this.inSetup) {
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            }
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        switch (vRMLNodeType.getPrimaryType()) {
            case 11: {
                this.setComponent(1, vRMLNodeType);
                break;
            }
            case 34: {
                this.setComponent(3, vRMLNodeType);
                break;
            }
            case 48: {
                this.setComponent(4, vRMLNodeType);
                break;
            }
            case 9: {
                this.setComponent(2, vRMLNodeType);
                break;
            }
            default: {
                this.setComponent(9, vRMLNodeType);
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public boolean hasColorPerVertex() {
        return this.vfColorPerVertex;
    }

    public boolean hasNormalPerVertex() {
        return this.vfNormalPerVertex;
    }

    public boolean requiresUnlitColor() {
        return false;
    }

    public void setUnlitColor(float[] fArray) {
    }

    public int getPrimaryType() {
        return 58;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pCoord != null) {
            this.pCoord.setupFinished();
        } else if (this.vfCoord != null) {
            this.vfCoord.setupFinished();
        }
        if (this.pColor != null) {
            this.pColor.setupFinished();
        } else if (this.vfColor != null) {
            this.vfColor.setupFinished();
        }
        if (this.pTexCoord != null) {
            this.pTexCoord.setupFinished();
        } else if (this.vfTexCoord != null) {
            this.vfTexCoord.setupFinished();
        }
        if (this.pNormal != null) {
            this.pNormal.setupFinished();
        } else if (this.vfNormal != null) {
            this.vfNormal.setupFinished();
        }
        if (this.pFogCoord != null) {
            this.pFogCoord.setupFinished();
        } else if (this.vfFogCoord != null) {
            this.vfFogCoord.setupFinished();
        }
        int n = this.vfAttribs.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfAttribs.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        this.fieldData.clear();
        switch (n) {
            case 5: {
                this.fieldData.booleanValue = this.vfSolid;
                this.fieldData.dataType = 1;
                break;
            }
            case 6: {
                this.fieldData.booleanValue = this.vfCcw;
                this.fieldData.dataType = 1;
                break;
            }
            case 7: {
                this.fieldData.booleanValue = this.vfColorPerVertex;
                this.fieldData.dataType = 1;
                break;
            }
            case 8: {
                this.fieldData.booleanValue = this.vfNormalPerVertex;
                this.fieldData.dataType = 1;
                break;
            }
            case 1: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pCoord != null ? this.pCoord : this.vfCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pColor != null ? this.pColor : this.vfColor;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pNormal != null ? this.pNormal : this.vfNormal;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pTexCoord != null ? this.pTexCoord : this.vfTexCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pFogCoord != null ? this.pFogCoord : this.vfFogCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 10: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfAttribs.size()];
                this.vfAttribs.toArray(vRMLNodeTypeArray);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = vRMLNodeTypeArray;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    if (this.pColor != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pColor);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfColor);
                    break;
                }
                case 1: {
                    if (this.pCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfCoord);
                    break;
                }
                case 3: {
                    if (this.pNormal != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pNormal);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfNormal);
                    break;
                }
                case 4: {
                    if (this.pTexCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pTexCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfTexCoord);
                    break;
                }
                case 9: {
                    if (this.pFogCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pFogCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfFogCoord);
                    break;
                }
                case 10: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfAttribs.size()];
                    this.vfAttribs.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, this.vfAttribs.size());
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    System.out.println("Cannot route initializeOnly fields");
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: ");
        }
        switch (n) {
            case 6: {
                this.vfCcw = bl;
                break;
            }
            case 5: {
                this.vfSolid = bl;
                break;
            }
            case 8: {
                this.vfNormalPerVertex = bl;
                break;
            }
            case 7: {
                this.vfColorPerVertex = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                this.setComponent(n, vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
    }

    protected void setNormalNode(VRMLNormalNodeType vRMLNormalNodeType) {
    }

    protected void setTexCoordNode(VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType) {
    }

    protected void setFogCoordinateNode(VRMLGeometricPropertyNodeType vRMLGeometricPropertyNodeType) {
    }

    private void setComponent(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        if (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
            vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
        } else {
            vRMLProtoInstance = null;
        }
        switch (n) {
            case 1: {
                if (this.vfCoord != null) {
                    this.vfCoord.removeComponentListener((VRMLNodeComponentListener)this);
                }
                this.pCoord = vRMLProtoInstance;
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord != null) {
                    this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 1;
                this.setCoordinateNode(this.vfCoord);
                break;
            }
            case 3: {
                if (this.vfNormal != null) {
                    this.vfNormal.removeComponentListener((VRMLNodeComponentListener)this);
                }
                this.pNormal = vRMLProtoInstance;
                this.vfNormal = (VRMLNormalNodeType)vRMLNodeType2;
                if (this.vfNormal != null) {
                    this.vfNormal.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 2;
                this.setNormalNode(this.vfNormal);
                break;
            }
            case 4: {
                if (this.vfTexCoord != null) {
                    this.vfTexCoord.removeComponentListener((VRMLNodeComponentListener)this);
                }
                this.pTexCoord = vRMLProtoInstance;
                this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
                if (this.vfTexCoord != null) {
                    this.vfTexCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 4;
                this.setTexCoordNode(this.vfTexCoord);
                break;
            }
            case 2: {
                if (this.vfColor != null) {
                    this.vfColor.removeComponentListener((VRMLNodeComponentListener)this);
                }
                this.pColor = vRMLProtoInstance;
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                    if (!this.localColors) {
                        this.fireLocalColorsChanged(true);
                    }
                    this.localColors = true;
                } else {
                    if (this.localColors) {
                        this.fireLocalColorsChanged(false);
                    }
                    this.localColors = false;
                }
                this.changeFlags |= 8;
                this.setColorNode(this.vfColor);
                break;
            }
            default: {
                if (this.vfFogCoord != null) {
                    this.vfFogCoord.removeComponentListener((VRMLNodeComponentListener)this);
                }
                this.pFogCoord = vRMLProtoInstance;
                this.vfFogCoord = (VRMLGeometricPropertyNodeType)vRMLNodeType2;
                if (this.vfFogCoord != null) {
                    this.vfFogCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 0x10;
                this.setFogCoordinateNode(this.vfFogCoord);
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void fireLocalColorsChanged(boolean bl) {
        int n = this.localColorsListeners.size();
        boolean bl2 = this.vfColor != null && this.vfColor.getNumColorComponents() == 4;
        for (int i = 0; i < n; ++i) {
            try {
                LocalColorsListener localColorsListener = (LocalColorsListener)this.localColorsListeners.get(i);
                localColorsListener.localColorsChanged(bl, bl2);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending localColorsChanged message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

