/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.j3d.geom.IntersectionUtils;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public abstract class BaseDragSensorNode
extends BaseSensorNode
implements VRMLDragSensorNodeType {
    protected static final int FIELD_AUTOOFFSET = 3;
    protected static final int FIELD_TRACKPOINT_CHANGED = 4;
    protected static final int FIELD_DESCRIPTION = 5;
    protected static final int FIELD_IS_OVER = 6;
    protected static final int LAST_DRAG_SENSOR_INDEX = 6;
    protected static IntersectionUtils intersectionUtils = new IntersectionUtils();
    protected static float[] wkPoint = new float[3];
    protected boolean vfAutoOffset = true;
    protected float[] vfTrackPointChanged = new float[3];
    protected String vfDescription;
    protected boolean vfIsOver = false;
    protected float[] initialPosition = new float[3];

    protected BaseDragSensorNode(String string) {
        super(string);
    }

    protected void copy(VRMLDragSensorNodeType vRMLDragSensorNodeType) {
        super.copy((VRMLSensorNodeType)vRMLDragSensorNodeType);
        try {
            int n = vRMLDragSensorNodeType.getFieldIndex("autoOffset");
            VRMLFieldData vRMLFieldData = vRMLDragSensorNodeType.getFieldValue(n);
            this.vfAutoOffset = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public void notifySensorDragStart(float[] fArray, float[] fArray2) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = true;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
        this.initialPosition[0] = fArray[0];
        this.initialPosition[1] = fArray[1];
        this.initialPosition[2] = fArray[2];
    }

    public void notifySensorDragChange(float[] fArray, float[] fArray2) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = false;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
        this.processDrag(fArray, fArray2);
    }

    public void notifySensorDragEnd(float[] fArray, float[] fArray2) {
        if (!this.vfEnabled) {
            return;
        }
        this.processDrag(fArray, fArray2);
    }

    public boolean requiresPointOnly() {
        return true;
    }

    public void setIsOver(boolean bl) {
        this.vfIsOver = bl;
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    public boolean getIsOver() {
        return this.vfIsOver;
    }

    public void setAutoOffset(boolean bl) {
        this.vfAutoOffset = bl;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public boolean getAutoOffset() {
        return this.vfAutoOffset;
    }

    public float[] getTrackPointChanged() {
        return this.vfTrackPointChanged;
    }

    public int getPrimaryType() {
        return 13;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        this.fieldData.clear();
        switch (n) {
            case 3: {
                this.fieldData.booleanValue = this.vfAutoOffset;
                this.fieldData.dataType = 1;
                break;
            }
            case 6: {
                this.fieldData.booleanValue = this.vfIsOver;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.floatArrayValue = this.vfTrackPointChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfAutoOffset);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfIsOver);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfTrackPointChanged, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setAutoOffset(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 5: {
                this.setDescription(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected abstract void processDrag(float[] var1, float[] var2);
}

