/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import java.util.ArrayList;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLBoundedNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseGroupingNode
extends AbstractNode
implements VRMLGroupingNodeType,
VRMLBoundedNodeType {
    protected static final int FIELD_CHILDREN = 1;
    protected static final int FIELD_ADDCHILDREN = 2;
    protected static final int FIELD_REMOVECHILDREN = 3;
    protected static final int FIELD_BBOX_CENTER = 4;
    protected static final int FIELD_BBOX_SIZE = 5;
    protected static final int LAST_GROUP_INDEX = 5;
    protected static final String USE_BIND_MSG = "New node contains bindables when this grouping node is already USEd. Ignoring the request";
    protected ArrayList vfChildren;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
    protected int childCount = 0;
    protected boolean hasBindables = false;
    protected int shareCount = 0;
    private VRMLNodeType[] nodeTmp;

    protected BaseGroupingNode(String string) {
        super(string);
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfChildren = new ArrayList();
    }

    protected void copy(VRMLGroupingNodeType vRMLGroupingNodeType) {
        float[] fArray = vRMLGroupingNodeType.getBboxCenter();
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
        fArray = vRMLGroupingNodeType.getBboxSize();
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public VRMLNodeType[] getChildren() {
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfChildren.size()];
        this.vfChildren.toArray(vRMLNodeTypeArray);
        return vRMLNodeTypeArray;
    }

    public void setChildren(VRMLNodeType[] vRMLNodeTypeArray) {
        this.clearChildren();
        if (vRMLNodeTypeArray == null) {
            return;
        }
        this.childCount = 0;
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.addChildNode(vRMLNodeTypeArray[i]);
        }
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public void setChildren(VRMLNodeType vRMLNodeType) {
        this.clearChildren();
        this.childCount = 0;
        if (vRMLNodeType != null) {
            this.addChildNode(vRMLNodeType);
        }
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public void addChild(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType != null) {
            this.addChildNode(vRMLNodeType);
        }
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public int getChildrenSize() {
        return this.vfChildren.size();
    }

    public boolean containsBindableNodes() {
        return this.hasBindables;
    }

    public boolean isShared() {
        return this.shareCount > 1;
    }

    public void setShared(boolean bl) {
        this.shareCount = bl ? ++this.shareCount : --this.shareCount;
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.vfChildren.get(i);
            if (!(e instanceof VRMLGroupingNodeType)) continue;
            ((VRMLGroupingNodeType)e).setShared(bl);
        }
    }

    public void setDEF() {
        this.isDEF = true;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfChildren.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public int getPrimaryType() {
        return 22;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                int n2 = this.vfChildren.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n2) {
                    this.nodeTmp = new VRMLNodeType[n2];
                }
                this.vfChildren.toArray(this.nodeTmp);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.nodeTmp;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = n2;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxSize;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    int n3 = this.vfChildren.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfChildren.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 4: {
                this.setBboxCenter(fArray);
                break;
            }
            case 5: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType);
                    vRMLNodeType.updateRefCount(true);
                }
                bl = true;
                break;
            }
            case 2: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: addChildren");
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType);
                    vRMLNodeType.updateRefCount(true);
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: removeChildren");
                }
                if (vRMLNodeType != null) {
                    this.removeChildNode(vRMLNodeType);
                    vRMLNodeType.updateRefCount(false);
                }
                bl = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup && bl) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                    vRMLNodeTypeArray[i].updateRefCount(true);
                }
                break;
            }
            case 2: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: addChildren");
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                    vRMLNodeTypeArray[i].updateRefCount(true);
                }
                break;
            }
            case 3: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set an inputOnly field in a file: removehildren");
                }
                for (int i = 0; i < n2; ++i) {
                    this.removeChildNode(vRMLNodeTypeArray[i]);
                    vRMLNodeTypeArray[i].updateRefCount(false);
                }
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxCenter");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxSize");
        }
        FieldValidator.checkBBoxSize((String)this.getVRMLNodeName(), (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfChildren.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            if (this.nodeTmp[i] instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)this.nodeTmp[i]).setShared(false);
            }
            this.nodeTmp[i].updateRefCount(false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes((VRMLNode[])this.nodeTmp);
        }
        this.childCount = 0;
        this.vfChildren.clear();
        this.hasBindables = false;
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        boolean bl;
        boolean bl2 = bl = vRMLNodeType instanceof VRMLBindableNodeType || vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes();
        if (this.shareCount > 1 && bl) {
            throw new InvalidFieldValueException(USE_BIND_MSG);
        }
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(true);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeType2).setShared(true);
            }
        }
        if (bl) {
            this.hasBindables = true;
        }
        ++this.childCount;
        this.vfChildren.add(vRMLNodeType);
        if (!this.inSetup) {
            this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(false);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeType2).setShared(false);
            }
        }
        --this.childCount;
        if (!this.inSetup) {
            this.vfChildren.remove(vRMLNodeType);
        }
        if (!this.inSetup) {
            this.stateManager.registerRemovedNode((VRMLNode)vRMLNodeType);
        }
    }
}

