/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;

public abstract class BaseIndexedGeometryNode
extends BaseComponentGeometryNode {
    protected static final int FIELD_COLORINDEX = 11;
    protected static final int FIELD_SET_COLORINDEX = 12;
    protected static final int FIELD_COORDINDEX = 13;
    protected static final int FIELD_SET_COORDINDEX = 14;
    protected static final int FIELD_TEXCOORDINDEX = 15;
    protected static final int FIELD_SET_TEXCOORDINDEX = 16;
    protected static final int FIELD_NORMALINDEX = 17;
    protected static final int FIELD_SET_NORMALINDEX = 18;
    protected static final int LAST_INDEXEDGEOMETRY_INDEX = 18;
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coord object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coord object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    protected static final String NORMAL_PROTO_MSG = "Proto does not describe a Normal object";
    protected static final String NORMAL_NODE_MSG = "Node does not describe a Normal object";
    protected static final String TEXCOORD_PROTO_MSG = "Proto does not describe a TexCoord object";
    protected static final String TEXCOORD_NODE_MSG = "Node does not describe a TexCoord object";
    protected int[] vfColorIndex;
    protected int numColorIndex = 0;
    protected int[] vfCoordIndex = FieldConstants.EMPTY_MFINT32;
    protected int numCoordIndex = 0;
    protected int[] vfNormalIndex;
    protected int numNormalIndex = 0;
    protected int[] vfTexCoordIndex;
    protected int numTexCoordIndex = 0;

    protected BaseIndexedGeometryNode(String string) {
        super(string);
        this.vfColorIndex = FieldConstants.EMPTY_MFINT32;
        this.vfNormalIndex = FieldConstants.EMPTY_MFINT32;
        this.vfTexCoordIndex = FieldConstants.EMPTY_MFINT32;
        this.changeFlags = 0;
    }

    protected void copy(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType) {
        super.copy(vRMLComponentGeometryNodeType);
        try {
            int n = vRMLComponentGeometryNodeType.getFieldIndex("colorIndex");
            VRMLFieldData vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfColorIndex = new int[vRMLFieldData.numElements];
                this.numColorIndex = vRMLFieldData.numElements;
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfColorIndex, 0, vRMLFieldData.numElements);
            }
            n = vRMLComponentGeometryNodeType.getFieldIndex("coordIndex");
            vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfCoordIndex = new int[vRMLFieldData.numElements];
                this.numCoordIndex = vRMLFieldData.numElements;
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfCoordIndex, 0, vRMLFieldData.numElements);
            }
            if ((n = vRMLComponentGeometryNodeType.getFieldIndex("normalIndex")) >= 0) {
                vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
                if (vRMLFieldData.numElements != 0) {
                    this.vfNormalIndex = new int[vRMLFieldData.numElements];
                    this.numNormalIndex = vRMLFieldData.numElements;
                    System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfNormalIndex, 0, vRMLFieldData.numElements);
                }
            }
            if ((n = vRMLComponentGeometryNodeType.getFieldIndex("texCoordIndex")) >= 0) {
                vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
                if (vRMLFieldData.numElements != 0) {
                    this.vfTexCoordIndex = new int[vRMLFieldData.numElements];
                    this.numTexCoordIndex = vRMLFieldData.numElements;
                    System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfTexCoordIndex, 0, vRMLFieldData.numElements);
                }
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 13: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfCoordIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numCoordIndex;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfColorIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numColorIndex;
                break;
            }
            case 17: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfNormalIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numNormalIndex;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfTexCoordIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numTexCoordIndex;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        if (n <= 10) {
            super.sendRoute(d, n, vRMLNodeType, n2);
            return;
        }
        switch (n) {
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                System.err.println("These are fields. Can't be routed");
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (nArray != null && n2 == 0) {
            nArray = null;
        }
        if (!this.inSetup) {
            switch (n) {
                case 14: {
                    this.vfCoordIndex = nArray;
                    this.numCoordIndex = n2;
                    this.changeFlags |= 0x100;
                    break;
                }
                case 12: {
                    this.vfColorIndex = nArray;
                    this.numColorIndex = n2;
                    this.changeFlags |= 0x800;
                    break;
                }
                case 18: {
                    this.vfNormalIndex = nArray;
                    this.numNormalIndex = n2;
                    this.changeFlags |= 0x200;
                    break;
                }
                case 16: {
                    this.vfTexCoordIndex = nArray;
                    this.numTexCoordIndex = n2;
                    this.changeFlags |= 0x400;
                    break;
                }
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    throw new InvalidFieldAccessException("Attempting to write an initializeOnly field at runtime");
                }
                default: {
                    super.setValue(n, nArray, n2);
                }
            }
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            switch (n) {
                case 13: {
                    this.vfCoordIndex = nArray;
                    this.numCoordIndex = n2;
                    break;
                }
                case 11: {
                    this.vfColorIndex = nArray;
                    this.numColorIndex = n2;
                    break;
                }
                case 17: {
                    this.vfNormalIndex = nArray;
                    this.numNormalIndex = n2;
                    break;
                }
                case 15: {
                    this.vfTexCoordIndex = nArray;
                    this.numTexCoordIndex = n2;
                    break;
                }
                case 12: 
                case 14: 
                case 16: 
                case 18: {
                    throw new InvalidFieldAccessException("Attempting to write an initializeOnly at setup time");
                }
                default: {
                    super.setValue(n, nArray, n2);
                }
            }
        }
    }

    protected void setCoordIndex(int[] nArray, int n) {
        this.vfCoordIndex = nArray;
        this.numCoordIndex = n;
        this.changeFlags |= 0x100;
    }

    protected void setNormalIndex(int[] nArray, int n) {
        this.vfNormalIndex = nArray;
        this.numNormalIndex = n;
        this.changeFlags |= 0x200;
    }

    protected void setColorIndex(int[] nArray, int n) {
        this.vfColorIndex = nArray;
        this.numColorIndex = n;
        this.changeFlags |= 0x800;
    }

    protected void setTexCoordIndex(int[] nArray, int n) {
        this.vfTexCoordIndex = nArray;
        this.numTexCoordIndex = n;
        this.changeFlags |= 0x400;
    }
}

