/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeComponentListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;

public abstract class BaseIndexedTriangleGeometryNode
extends BaseComponentGeometryNode {
    protected static final int FIELD_INDEX = 11;
    protected static final int FIELD_SET_INDEX = 12;
    protected static final int LAST_INDEXEDTRIANGLEGEOMETRY_INDEX = 12;
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coord object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coord object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    protected static final String NORMAL_PROTO_MSG = "Proto does not describe a Normal object";
    protected static final String NORMAL_NODE_MSG = "Node does not describe a Normal object";
    protected static final String TEXCOORD_PROTO_MSG = "Proto does not describe a TexCoord object";
    protected static final String TEXCOORD_NODE_MSG = "Node does not describe a TexCoord object";
    protected int[] vfIndex = FieldConstants.EMPTY_MFINT32;
    protected int numIndex = 0;
    protected GeometryData geomData;

    protected BaseIndexedTriangleGeometryNode(String string) {
        super(string);
        this.changeFlags = 0;
    }

    protected void copy(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType) {
        super.copy(vRMLComponentGeometryNodeType);
        try {
            int n = vRMLComponentGeometryNodeType.getFieldIndex("index");
            VRMLFieldData vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfIndex = new int[vRMLFieldData.numElements];
                this.numIndex = vRMLFieldData.numElements;
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfIndex, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    protected abstract void buildImpl();

    public void allEventsComplete() {
        this.buildImpl();
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 11: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numIndex;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        switch (n) {
            case 11: {
                System.err.println("These are fields. Can't be routed");
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (!this.inSetup) {
            switch (n) {
                case 12: {
                    this.setIndex(nArray, n2);
                    break;
                }
                case 11: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: index");
                }
                default: {
                    super.setValue(n, nArray, n2);
                }
            }
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            switch (n) {
                case 11: {
                    this.setIndex(nArray, n2);
                    break;
                }
                case 12: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: index");
                }
                default: {
                    super.setValue(n, nArray, n2);
                }
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException(COLOR_PROTO_MSG);
                }
                this.changeFlags |= 8;
                this.buildImpl();
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException(COORD_PROTO_MSG);
                }
                this.changeFlags |= 1;
                this.buildImpl();
                break;
            }
            case 3: {
                if (vRMLNodeType.getPrimaryType() != 34) {
                    throw new InvalidFieldValueException(NORMAL_PROTO_MSG);
                }
                this.changeFlags |= 2;
                this.buildImpl();
                break;
            }
            case 4: {
                if (vRMLNodeType.getPrimaryType() != 48) {
                    throw new InvalidFieldValueException(TEXCOORD_PROTO_MSG);
                }
                this.changeFlags |= 4;
                this.buildImpl();
                break;
            }
            default: {
                System.out.println("BaseIndexedTriangleFanSet: Unknown field for notifyExternProtoLoaded");
            }
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        boolean bl = false;
        switch (n) {
            case 1: {
                if (vRMLNodeType == null) {
                    this.pCoord = null;
                    if (this.vfCoord != null) {
                        this.vfCoord.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pCoord.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                        this.pCoord = null;
                        throw new InvalidFieldValueException(COORD_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                    throw new InvalidFieldValueException(COORD_NODE_MSG);
                }
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord != null) {
                    this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 1;
                bl = true;
                break;
            }
            case 3: {
                if (vRMLNodeType == null) {
                    this.pNormal = null;
                    if (this.vfNormal != null) {
                        this.vfNormal.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pNormal = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pNormal.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLNormalNodeType)) {
                        this.pNormal = null;
                        throw new InvalidFieldValueException(NORMAL_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLNormalNodeType)) {
                    System.out.println("node: " + vRMLNodeType2);
                    throw new InvalidFieldValueException(NORMAL_NODE_MSG);
                }
                this.vfNormal = (VRMLNormalNodeType)vRMLNodeType2;
                if (this.vfNormal != null) {
                    this.vfNormal.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 2;
                bl = true;
                break;
            }
            case 2: {
                if (vRMLNodeType == null) {
                    this.pColor = null;
                    if (this.vfColor != null) {
                        this.vfColor.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pColor = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pColor.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                        this.pColor = null;
                        throw new InvalidFieldValueException(COLOR_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                    throw new InvalidFieldValueException(COLOR_NODE_MSG);
                }
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 8;
                bl = true;
                break;
            }
            case 4: {
                if (vRMLNodeType == null) {
                    this.pTexCoord = null;
                    if (this.vfTexCoord != null) {
                        this.vfTexCoord.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pTexCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pTexCoord.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                        this.pTexCoord = null;
                        throw new InvalidFieldValueException(TEXCOORD_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                    throw new InvalidFieldValueException(TEXCOORD_NODE_MSG);
                }
                this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
                if (this.vfTexCoord != null) {
                    this.vfTexCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 4;
                bl = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup && bl) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        this.changeFlags |= 1;
        this.buildImpl();
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (this.inSetup) {
            return;
        }
        this.changeFlags |= 8;
        this.buildImpl();
    }

    protected void setTextureCoordinateNode(VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        this.changeFlags |= 4;
        this.buildImpl();
    }

    protected void setNormalNode(VRMLNormalNodeType vRMLNormalNodeType) {
        this.changeFlags |= 2;
        this.buildImpl();
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType == this.vfCoord) {
            this.changeFlags |= 1;
            this.buildImpl();
        } else if (vRMLNodeType == this.vfColor) {
            this.changeFlags |= 8;
            this.buildImpl();
        } else if (vRMLNodeType == this.vfNormal) {
            this.changeFlags |= 2;
            this.buildImpl();
        } else if (vRMLNodeType == this.vfTexCoord) {
            this.changeFlags |= 4;
            this.buildImpl();
        } else {
            System.out.println("BaseIndexedTriangleSet: Unknown field for fieldChanged");
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    protected void setIndex(int[] nArray, int n) {
        if (this.vfIndex.length < n) {
            this.vfIndex = new int[n];
        }
        System.arraycopy(nArray, 0, this.vfIndex, 0, n);
        this.numIndex = n;
        this.changeFlags |= 0x100;
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void updateCoordinateArray() {
        if (this.vfCoord == null) {
            this.geomData.vertexCount = 0;
        } else {
            this.geomData.vertexCount = this.vfCoord.getNumPoints() / 3;
            this.geomData.coordinates = this.vfCoord.getPointRef();
        }
    }

    protected void updateNormalArray() {
        if (this.vfNormal != null && this.vfNormalPerVertex) {
            this.geomData.normals = this.vfNormal.getVectorRef();
        }
    }

    protected void updateColorArray() {
        if (this.vfColor != null) {
            int n = this.vfColor.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = this.vfColor.getFieldValue(n);
            this.geomData.colors = (float[])(vRMLFieldData.numElements != 0 ? vRMLFieldData.floatArrayValue : null);
        }
    }
}

