/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseInterpolatorNode
extends AbstractNode
implements VRMLInterpolatorNodeType {
    protected static final int FIELD_KEY = 1;
    protected static final int FIELD_KEY_VALUE = 2;
    protected static final int FIELD_FRACTION = 3;
    protected static final int FIELD_VALUE = 4;
    protected static final int LAST_INTERPOLATOR_INDEX = 4;
    protected float vfFraction = 0.0f;
    protected float[] vfKey = FieldConstants.EMPTY_MFFLOAT;
    protected int numKey;

    public BaseInterpolatorNode(String string) {
        super(string);
    }

    protected void copy(VRMLInterpolatorNodeType vRMLInterpolatorNodeType) {
        float[] fArray = vRMLInterpolatorNodeType.getKey();
        this.numKey = vRMLInterpolatorNodeType.getNumKey();
        this.vfKey = new float[this.numKey];
        System.arraycopy(fArray, 0, this.vfKey, 0, this.numKey);
    }

    public int getPrimaryType() {
        return 25;
    }

    public float getFraction() {
        return this.vfFraction;
    }

    public float[] getKey() {
        return this.vfKey;
    }

    public int getNumKey() {
        return this.numKey;
    }

    public void setKey(float[] fArray, int n) {
        this.numKey = n;
        if (this.vfKey.length < n) {
            this.vfKey = new float[n];
        }
        if (this.numKey != 0) {
            System.arraycopy(fArray, 0, this.vfKey, 0, n);
        }
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfKey;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numKey;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfFraction;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfKey, this.numKey);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setKey(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }
}

