/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseLightNode
extends AbstractNode
implements VRMLLightNodeType {
    protected static final int FIELD_AMBIENT_INTENSITY = 1;
    protected static final int FIELD_COLOR = 2;
    protected static final int FIELD_INTENSITY = 3;
    protected static final int FIELD_ON = 4;
    protected static final int LAST_LIGHT_INDEX = 4;
    protected float vfAmbientIntensity;
    protected float[] vfColor;
    protected float vfIntensity;
    protected boolean vfOn;

    protected BaseLightNode(String string) {
        super(string);
        this.hasChanged = new boolean[5];
        this.vfAmbientIntensity = 0.0f;
        this.vfColor = new float[]{1.0f, 1.0f, 1.0f};
        this.vfIntensity = 1.0f;
        this.vfOn = true;
    }

    protected void copy(VRMLLightNodeType vRMLLightNodeType) {
        this.vfAmbientIntensity = vRMLLightNodeType.getAmbientIntensity();
        float[] fArray = vRMLLightNodeType.getColor();
        this.vfColor[0] = fArray[0];
        this.vfColor[1] = fArray[1];
        this.vfColor[2] = fArray[2];
        this.vfIntensity = vRMLLightNodeType.getIntensity();
        this.vfOn = vRMLLightNodeType.getOn();
    }

    public float getAmbientIntensity() {
        return this.vfAmbientIntensity;
    }

    public float[] getColor() {
        float[] fArray = new float[]{this.vfColor[0], this.vfColor[1], this.vfColor[2]};
        return fArray;
    }

    public float getIntensity() {
        return this.vfIntensity;
    }

    public boolean getOn() {
        return this.vfOn;
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Light.ambientIntensity", (float)f);
        this.vfAmbientIntensity = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Light.setColor", (float[])fArray);
        this.vfColor[0] = fArray[0];
        this.vfColor[1] = fArray[1];
        this.vfColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public void setIntensity(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Light.intensity", (float)f);
        this.vfIntensity = f;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setOn(boolean bl) {
        this.vfOn = bl;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public int getPrimaryType() {
        return 27;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfAmbientIntensity;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfOn;
                this.fieldData.dataType = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfIntensity;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfAmbientIntensity);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfColor, 3);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfIntensity);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfOn);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Light sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Light sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.setOn(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setAmbientIntensity(f);
                break;
            }
            case 3: {
                this.setIntensity(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }
}

