/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseMetadataObjectNode
extends AbstractNode
implements VRMLMetadataObjectNodeType {
    protected static final int FIELD_NAME = 1;
    protected static final int FIELD_REFERENCE = 2;
    protected static final int LAST_METADATA_INDEX = 2;
    protected String vfName;
    protected String vfReference;

    protected BaseMetadataObjectNode(String string) {
        super(string);
    }

    protected void copy(VRMLMetadataObjectNodeType vRMLMetadataObjectNodeType) {
        this.vfReference = vRMLMetadataObjectNodeType.getReference();
        this.vfName = vRMLMetadataObjectNodeType.getName();
    }

    public String getName() {
        return this.vfName;
    }

    public void setName(String string) {
        this.vfName = string;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public String getReference() {
        return this.vfReference;
    }

    public void setReference(String string) {
        this.vfReference = string;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public int getPrimaryType() {
        return 72;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        this.fieldData.clear();
        switch (n) {
            case 1: {
                this.fieldData.stringValue = this.vfName;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 2: {
                this.fieldData.stringValue = this.vfReference;
                this.fieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfReference);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setName(string);
                break;
            }
            case 2: {
                this.setReference(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }
}

