/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.j3d.geom.GeometryData;
import org.j3d.geom.TriangulationUtils;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;

public class GeometryUtils {
    private boolean cached = false;
    GeometryHolder geomData;
    private int[] lfColorIndex;
    private int[] lfCoordIndex;
    private int[] lfNormalIndex;
    private int[] lfTexCoordIndex;
    private int[] tsCoordIndex;
    private int[] tsNormalIndex;
    private int[] tsColorIndex;
    private int[] tsTexCoordIndex;
    private int[] triangleOutput;
    private int[] normalOutput;
    private int[] colorOutput;
    private int[] texCoordOutput;
    private int[][] vertexToFace;
    private int[] vertexUsers;
    private int[] rawVerticesPerFace;
    private float[] lfColor;
    private float[] lfCoord;
    private float[] lfNormal;
    private float[] lfTexCoord;
    private float[][] texCoords;
    private float[][] faceNormals;
    private int[] vfColorIndex;
    private int numColorIndex;
    private int[] vfCoordIndex;
    private int numCoordIndex;
    private int[] vfNormalIndex;
    private int numNormalIndex;
    private int[] vfTexCoordIndex;
    private int numTexCoordIndex;
    private VRMLColorNodeType vfColor;
    private VRMLCoordinateNodeType vfCoord;
    private VRMLNormalNodeType vfNormal;
    private VRMLTextureCoordinateNodeType vfTexCoord;
    private float[] min;
    private float[] max;
    private boolean vfCcw;
    private boolean vfConvex;
    private boolean vfColorPerVertex;
    private boolean vfNormalPerVertex;
    private float vfCreaseAngle;
    private int maxIndexValue;
    private int changeFlags;
    private int polygonCount;
    private int triangleCount;
    private int maxPolySize;
    private int maxIndexCount;
    private int triCnt;
    private int quadCnt;
    private int ngonCnt;
    private int numColorComponents;
    private int numTextureDimensions;
    private float[] normalTmp;
    private TriangulationUtils triangulator;
    private double cosCreaseAngle;

    public void reset() {
        this.lfColorIndex = null;
        this.lfCoordIndex = null;
        this.lfNormalIndex = null;
        this.lfTexCoordIndex = null;
        this.tsCoordIndex = null;
        this.tsNormalIndex = null;
        this.tsColorIndex = null;
        this.tsTexCoordIndex = null;
        this.triangleOutput = null;
        this.normalOutput = null;
        this.colorOutput = null;
        this.texCoordOutput = null;
        this.vertexToFace = null;
        this.vertexUsers = null;
        this.rawVerticesPerFace = null;
        this.lfColor = null;
        this.lfCoord = null;
        this.lfNormal = null;
        this.lfTexCoord = null;
        this.texCoords = null;
        this.faceNormals = null;
        this.vfColorIndex = null;
        this.vfCoordIndex = null;
        this.vfNormalIndex = null;
        this.vfTexCoordIndex = null;
        this.vfColor = null;
        this.vfCoord = null;
        this.vfNormal = null;
        this.vfTexCoord = null;
        this.min = null;
        this.max = null;
        this.normalTmp = null;
        this.triangulator = null;
        this.cached = false;
    }

    public void copyData(GeometryHolder geometryHolder, GeometryData geometryData) {
        geometryData.geometryType = geometryHolder.geometryType;
        geometryData.geometrySubType = geometryHolder.geometrySubType;
        geometryData.geometryComponents = geometryHolder.geometryComponents;
        geometryData.vertexCount = geometryHolder.vertexCount;
        geometryData.coordinates = geometryHolder.coordinates;
        geometryData.normals = geometryHolder.normals;
        geometryData.indexesCount = geometryHolder.indexesCount;
        geometryData.indexes = geometryHolder.indexes;
        geometryData.numStrips = geometryHolder.numStrips;
        geometryData.stripCounts = geometryHolder.stripCounts;
        if (geometryHolder.textureCoordinates != null) {
            geometryData.textureCoordinates = geometryHolder.textureCoordinates[0];
        }
        geometryData.colors = geometryHolder.colors;
        geometryData.normalIndexes = geometryHolder.normalIndexes;
        geometryData.texCoordIndexes = geometryHolder.texCoordIndexes;
        geometryData.colorIndexes = geometryHolder.colorIndexes;
    }

    public boolean generateTriangleArrays(int n, boolean bl, boolean bl2, VRMLCoordinateNodeType vRMLCoordinateNodeType, VRMLColorNodeType vRMLColorNodeType, VRMLNormalNodeType vRMLNormalNodeType, VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType, int[] nArray, int n2, int[] nArray2, int[] nArray3, int[] nArray4, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f, boolean bl7, GeometryHolder geometryHolder) {
        int n3;
        int n4;
        int n5;
        boolean bl8 = bl7;
        this.geomData = geometryHolder;
        this.changeFlags = n;
        this.vfCoord = vRMLCoordinateNodeType;
        this.vfColor = vRMLColorNodeType;
        this.vfNormal = vRMLNormalNodeType;
        this.vfTexCoord = vRMLTextureCoordinateNodeType;
        this.vfCoordIndex = nArray;
        this.numCoordIndex = n2;
        this.vfNormalIndex = nArray3;
        this.vfColorIndex = nArray2;
        this.vfTexCoordIndex = nArray4;
        this.vfCcw = bl3;
        this.vfConvex = bl4;
        this.vfColorPerVertex = bl5;
        this.vfNormalPerVertex = bl6;
        this.vfCreaseAngle = f;
        if ((double)f > Math.PI) {
            f = (float)Math.PI;
        }
        this.cosCreaseAngle = Math.cos(f);
        if (!this.vfConvex) {
            this.normalTmp = new float[3];
            this.triangulator = new TriangulationUtils();
        }
        geometryHolder.geometryType = 1;
        if (!this.cached) {
            bl7 = true;
        }
        if (nArray == null || vRMLCoordinateNodeType == null || !bl7 && n == 0) {
            return bl8;
        }
        int n6 = vRMLCoordinateNodeType.getNumPoints();
        if (n6 < 3) {
            return bl8;
        }
        if (this.lfCoord == null || this.lfCoord.length < n6) {
            this.lfCoord = new float[n6];
        }
        if ((n & 1) != 0 || bl7) {
            geometryHolder.vertexCount = n6 / 3;
            this.lfCoord = vRMLCoordinateNodeType.getPointRef();
        }
        if ((n & 8) != 0 || bl7) {
            if (vRMLColorNodeType != null) {
                n6 = vRMLColorNodeType.getNumColors();
                if (this.lfColor == null || this.lfColor.length < n6) {
                    this.lfColor = new float[n6];
                }
                vRMLColorNodeType.getColor(this.lfColor);
            } else if (!bl7) {
                System.out.println("OGL.IFS not handling clearing colors");
            }
        }
        if ((n & 2) != 0 || bl7) {
            if (vRMLNormalNodeType != null) {
                n6 = vRMLNormalNodeType.getNumNormals();
                if (this.lfNormal == null || this.lfNormal.length < n6) {
                    this.lfNormal = new float[n6];
                }
                vRMLNormalNodeType.getVector(this.lfNormal);
            } else if (!bl7) {
                System.out.println("OGL.IFS not handling clearing normals");
            }
        }
        int n7 = this.maxIndexCount;
        boolean bl9 = false;
        boolean bl10 = false;
        if ((n & 0x100) != 0 || bl7) {
            this.buildIndexList(11);
            this.buildIndexList(15);
            this.buildIndexList(17);
            n5 = this.lfCoord.length;
            if (this.vertexUsers == null || this.vertexUsers.length < n5) {
                this.vertexUsers = new int[n5];
            }
            for (n4 = 0; n4 < n5; ++n4) {
                this.vertexUsers[n4] = 0;
            }
            this.maxPolySize = n4 = this.checkMaxPolySize();
            switch (n4) {
                case 0: {
                    n7 = 0;
                    System.out.println("zero sized polygons!");
                    return bl8;
                }
                case 1: 
                case 2: {
                    System.out.println("No valid polygons. Max size " + n4);
                    return bl8;
                }
                case 3: {
                    n7 = this.polygonCount * 3;
                    break;
                }
                case 4: {
                    n7 = this.polygonCount * 6;
                    break;
                }
                default: {
                    n7 = this.triCnt * 3 + this.quadCnt * 6 + this.ngonCnt * (n4 - 2) * 3;
                }
            }
            if (!(this.vfConvex || this.triangleOutput != null && this.triangleOutput.length >= this.maxPolySize * 3)) {
                this.triangleOutput = new int[this.maxPolySize * 3];
                this.normalOutput = new int[this.maxPolySize * 3];
                this.colorOutput = new int[this.maxPolySize * 3];
                this.texCoordOutput = new int[this.maxPolySize * 3];
            }
            int n8 = this.maxIndexValue = (n3 = vRMLCoordinateNodeType.getNumPoints()) > n7 ? n3 : n7;
            if (this.tsCoordIndex == null || this.tsCoordIndex.length < this.maxIndexValue) {
                this.tsCoordIndex = new int[this.maxIndexValue];
                this.tsNormalIndex = new int[this.maxIndexValue];
                this.tsTexCoordIndex = new int[this.maxIndexValue];
                if (vRMLColorNodeType != null) {
                    this.tsColorIndex = new int[this.maxIndexValue];
                }
            }
            this.rebuildFaceLists(true);
        } else if (!this.vfConvex && (n & 1) != 0) {
            if (!(this.vfConvex || this.triangleOutput != null && this.triangleOutput.length >= this.maxPolySize * 3)) {
                this.triangleOutput = new int[this.maxPolySize * 3];
            }
            this.rebuildFaceLists(true);
        } else {
            if ((n & 0x200) != 0) {
                this.buildIndexList(17);
            }
            if ((n & 0x800) != 0) {
                this.buildIndexList(11);
            }
            if ((n & 0x400) != 0) {
                this.buildIndexList(15);
            }
            this.rebuildFaceLists(false);
        }
        if (n7 > this.maxIndexCount) {
            this.maxIndexCount = n7;
            bl8 = true;
        }
        if ((n & 1) != 0 || bl7) {
            this.updateCoordinateArray();
        }
        if ((n & 1) != 0 && vRMLNormalNodeType == null || (n & 2) != 0 || bl7) {
            if (vRMLNormalNodeType == null) {
                if (bl2) {
                    this.generateNormals();
                }
            } else {
                this.updateNormalArray();
            }
        }
        if ((n & 4) != 0 || bl7) {
            if (vRMLTextureCoordinateNodeType == null) {
                if (bl) {
                    this.generateTextureCoordinates();
                }
            } else {
                int n9;
                int n10;
                n4 = n5 = vRMLTextureCoordinateNodeType.getNumSets();
                for (n3 = 0; n3 < n5; ++n3) {
                    if (n3 == vRMLTextureCoordinateNodeType.isShared(n3)) continue;
                    --n4;
                }
                n3 = vRMLTextureCoordinateNodeType.getSize(0);
                int n11 = vRMLTextureCoordinateNodeType.getNumTextureComponents();
                for (n10 = 1; n10 < n5; ++n10) {
                    n9 = vRMLTextureCoordinateNodeType.getSize(n10);
                    if (n3 <= n9) continue;
                    n3 = n9;
                }
                if (n3 < geometryHolder.vertexCount * n11) {
                    n3 = geometryHolder.vertexCount * n11;
                }
                if (this.lfTexCoord == null || this.lfTexCoord.length < n3) {
                    this.lfTexCoord = new float[n3];
                }
                geometryHolder.numTexSets = n5;
                geometryHolder.numUniqueTexSets = n4;
                geometryHolder.textureCoordinates = new float[n4][geometryHolder.vertexCount * n11];
                n10 = 0;
                for (n9 = 0; n9 < n5; ++n9) {
                    if (n10 != vRMLTextureCoordinateNodeType.isShared(n9)) continue;
                    vRMLTextureCoordinateNodeType.getPoint(n9, this.lfTexCoord);
                    this.updateTexCoordinateArray(n10++, n5);
                }
            }
        }
        if ((n & 8) != 0 || bl9 && vRMLColorNodeType != null) {
            this.numColorComponents = vRMLColorNodeType != null ? vRMLColorNodeType.getNumColorComponents() : 0;
            this.updateColorArray();
        }
        nArray2 = null;
        nArray = null;
        nArray3 = null;
        nArray4 = null;
        vRMLColorNodeType = null;
        vRMLCoordinateNodeType = null;
        vRMLNormalNodeType = null;
        vRMLTextureCoordinateNodeType = null;
        this.cached = true;
        return bl8;
    }

    public void getCounts(int[] nArray) {
        nArray[0] = this.triCnt;
        nArray[1] = this.quadCnt;
        nArray[2] = this.ngonCnt;
        nArray[3] = this.maxIndexCount;
    }

    private void buildIndexList(int n) {
        int[] nArray;
        boolean bl;
        int[] nArray2;
        switch (n) {
            case 17: {
                nArray2 = this.vfNormalIndex;
                bl = this.vfNormalPerVertex;
                break;
            }
            case 11: {
                nArray2 = this.vfColorIndex;
                bl = this.vfColorPerVertex;
                break;
            }
            case 15: {
                nArray2 = this.vfTexCoordIndex;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Dud index field");
            }
        }
        if (!bl) {
            nArray = new int[this.numCoordIndex];
            if (nArray2 != null && nArray2.length != 0) {
                int n2 = 0;
                for (int i = 0; i < this.numCoordIndex; ++i) {
                    if (this.vfCoordIndex[i] != -1) {
                        nArray[i] = nArray2[n2];
                        continue;
                    }
                    nArray[i] = -1;
                    ++n2;
                }
            } else {
                int n3 = 0;
                for (int i = 0; i < this.numCoordIndex; ++i) {
                    if (this.vfCoordIndex[i] != -1) {
                        nArray[i] = n3;
                        continue;
                    }
                    nArray[i] = -1;
                    ++n3;
                }
            }
        } else {
            nArray = nArray2 != null && nArray2.length != 0 ? nArray2 : this.vfCoordIndex;
        }
        switch (n) {
            case 17: {
                this.lfNormalIndex = nArray;
                break;
            }
            case 11: {
                this.lfColorIndex = nArray;
                break;
            }
            case 15: {
                this.lfTexCoordIndex = nArray;
            }
        }
    }

    private int checkMaxPolySize() {
        int n = 0;
        int n2 = 0;
        this.polygonCount = 0;
        for (int i = 0; i < this.numCoordIndex; ++i) {
            if (this.vfCoordIndex[i] == -1) {
                if (n == 3) {
                    ++this.triCnt;
                } else if (n == 4) {
                    ++this.quadCnt;
                } else {
                    ++this.ngonCnt;
                }
                if (n > n2) {
                    n2 = n;
                }
                n = 0;
                ++this.polygonCount;
                continue;
            }
            ++n;
            int n3 = this.vfCoordIndex[i];
            this.vertexUsers[n3] = this.vertexUsers[n3] + 1;
        }
        if (this.numCoordIndex != 0 && this.vfCoordIndex[this.numCoordIndex - 1] != -1) {
            if (n == 3) {
                ++this.triCnt;
            } else if (n == 4) {
                ++this.quadCnt;
            } else {
                ++this.ngonCnt;
            }
            if (n > n2) {
                n2 = n;
            }
            ++this.polygonCount;
        }
        return n2;
    }

    private void generateTextureCoordinates() {
        if (this.min == null) {
            this.min = new float[3];
        }
        if (this.max == null) {
            this.max = new float[3];
        }
        this.min[0] = Float.POSITIVE_INFINITY;
        this.min[1] = Float.POSITIVE_INFINITY;
        this.min[2] = Float.POSITIVE_INFINITY;
        this.max[0] = Float.NEGATIVE_INFINITY;
        this.max[1] = Float.NEGATIVE_INFINITY;
        this.max[2] = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.geomData.vertexCount; ++i) {
            float f = this.geomData.coordinates[i * 3];
            if (f < this.min[0]) {
                this.min[0] = f;
            }
            if (f > this.max[0]) {
                this.max[0] = f;
            }
            if ((f = this.geomData.coordinates[i * 3 + 1]) < this.min[1]) {
                this.min[1] = f;
            }
            if (f > this.max[1]) {
                this.max[1] = f;
            }
            if ((f = this.geomData.coordinates[i * 3 + 2]) < this.min[2]) {
                this.min[2] = f;
            }
            if (!(f > this.max[2])) continue;
            this.max[2] = f;
        }
        float f = (this.min[0] < 0.0f ? -this.min[0] : this.min[0]) + (this.max[0] < 0.0f ? -this.max[0] : this.max[0]);
        float f2 = (this.min[1] < 0.0f ? -this.min[1] : this.min[1]) + (this.max[1] < 0.0f ? -this.max[1] : this.max[1]);
        float f3 = (this.min[2] < 0.0f ? -this.min[2] : this.min[2]) + (this.max[2] < 0.0f ? -this.max[2] : this.max[2]);
        int n = 0;
        int n2 = f >= f2 ? (f >= f3 ? 0 : 2) : (f2 >= f3 ? 1 : 2);
        float f4 = 1.0f;
        float f5 = 1.0f;
        switch (n2) {
            case 0: {
                n = f2 >= f3 ? 1 : 2;
                f4 = 1.0f / f;
                f5 = 1.0f / f;
                break;
            }
            case 1: {
                n = f >= f3 ? 0 : 2;
                f4 = 1.0f / f2;
                f5 = 1.0f / f2;
                break;
            }
            case 2: {
                n = f >= f2 ? 0 : 1;
                f4 = 1.0f / f3;
                f5 = 1.0f / f3;
            }
        }
        float f6 = -this.min[n2];
        float f7 = -this.min[n];
        this.geomData.numTexSets = 1;
        this.geomData.numUniqueTexSets = 1;
        int n3 = this.geomData.vertexCount * 2;
        if (this.geomData.textureCoordinates == null || this.geomData.textureCoordinates[0].length < n3) {
            this.geomData.textureCoordinates = new float[1][n3];
        }
        for (int i = 0; i < this.geomData.vertexCount; ++i) {
            float f8 = (this.geomData.coordinates[i * 3 + n2] + f6) * f4;
            float f9 = (this.geomData.coordinates[i * 3 + n] + f7) * f5;
            this.geomData.textureCoordinates[0][i * 2] = f8;
            this.geomData.textureCoordinates[0][i * 2 + 1] = f9;
        }
    }

    private void generateNormals() {
        int n;
        for (n = 0; n < this.triangleCount; ++n) {
            int n2 = n * 3 * 3;
            this.createFaceNormal(this.geomData.coordinates, n2, 3, this.faceNormals[n]);
        }
        int n3 = this.triangleCount * 9;
        if (this.vfCreaseAngle == 0.0f) {
            if (this.geomData.normals == null || this.geomData.normals.length < n3) {
                this.geomData.normals = new float[n3];
            }
            for (n = 0; n < this.triangleCount; ++n) {
                this.geomData.normals[n * 9] = this.faceNormals[n][0];
                this.geomData.normals[n * 9 + 1] = this.faceNormals[n][1];
                this.geomData.normals[n * 9 + 2] = this.faceNormals[n][2];
                this.geomData.normals[n * 9 + 3] = this.faceNormals[n][0];
                this.geomData.normals[n * 9 + 4] = this.faceNormals[n][1];
                this.geomData.normals[n * 9 + 5] = this.faceNormals[n][2];
                this.geomData.normals[n * 9 + 6] = this.faceNormals[n][0];
                this.geomData.normals[n * 9 + 7] = this.faceNormals[n][1];
                this.geomData.normals[n * 9 + 8] = this.faceNormals[n][2];
            }
        } else {
            if (this.geomData.normals == null || this.geomData.normals.length < n3) {
                this.geomData.normals = new float[n3];
            }
            int n4 = 0;
            for (n = 0; n < this.triangleCount; ++n) {
                float f = this.faceNormals[n][0];
                float f2 = this.faceNormals[n][1];
                float f3 = this.faceNormals[n][2];
                for (int i = 0; i < 3; ++i) {
                    double d;
                    n4 = this.tsCoordIndex[n * 3 + i];
                    float f4 = f;
                    float f5 = f2;
                    float f6 = f3;
                    int[] nArray = this.vertexToFace[n4];
                    boolean bl = false;
                    int n5 = nArray == null ? 0 : nArray.length;
                    for (int j = 0; j < n5; ++j) {
                        float f7;
                        int n6 = nArray[j];
                        if (n6 == n || !((f7 = this.faceNormals[n6][0] * f + this.faceNormals[n6][1] * f2 + this.faceNormals[n6][2] * f3) < 1.01f) || !((double)f7 >= this.cosCreaseAngle)) continue;
                        bl = true;
                        f4 += this.faceNormals[n6][0];
                        f5 += this.faceNormals[n6][1];
                        f6 += this.faceNormals[n6][2];
                    }
                    if (bl && (d = (double)(f4 * f4 + f5 * f5 + f6 * f6)) != 0.0) {
                        d = 1.0 / Math.sqrt(d);
                        f4 = (float)((double)f4 * d);
                        f5 = (float)((double)f5 * d);
                        f6 = (float)((double)f6 * d);
                    }
                    this.geomData.normals[n * 9 + i * 3] = f4;
                    this.geomData.normals[n * 9 + i * 3 + 1] = f5;
                    this.geomData.normals[n * 9 + i * 3 + 2] = f6;
                }
            }
        }
    }

    private void rebuildFaceLists(boolean bl) {
        int n;
        int n2;
        if (bl || (this.changeFlags & 0x100) != 0) {
            if (this.rawVerticesPerFace == null || this.rawVerticesPerFace.length < this.polygonCount) {
                this.rawVerticesPerFace = new int[this.polygonCount];
            }
            this.rawVerticesPerFace[0] = 0;
            n2 = 0;
            for (n = 0; n < this.numCoordIndex; ++n) {
                if (this.vfCoordIndex[n] != -1) {
                    int n3 = n2;
                    this.rawVerticesPerFace[n3] = this.rawVerticesPerFace[n3] + 1;
                    continue;
                }
                if (++n2 >= this.polygonCount) continue;
                this.rawVerticesPerFace[n2] = 0;
            }
            if (this.lfCoordIndex == null || this.lfCoordIndex.length < this.numCoordIndex) {
                this.lfCoordIndex = new int[this.numCoordIndex];
            }
            System.arraycopy(this.vfCoordIndex, 0, this.lfCoordIndex, 0, this.numCoordIndex);
        }
        if (this.vfConvex) {
            this.buildConvexPolygons(bl);
        } else {
            this.buildConcavePolygons(bl);
        }
        if (bl || (this.changeFlags & 0x100) != 0) {
            if (this.faceNormals == null || this.faceNormals.length < this.triangleCount) {
                this.faceNormals = new float[this.triangleCount][3];
            }
            this.maxIndexValue = 0;
            for (n = 0; n < this.numCoordIndex; ++n) {
                if (this.vfCoordIndex[n] <= this.maxIndexValue) continue;
                this.maxIndexValue = this.vfCoordIndex[n];
            }
            n2 = this.triangleCount * 3;
            if (this.vertexToFace == null || this.vertexToFace.length < this.maxIndexValue + 1) {
                this.vertexToFace = new int[this.maxIndexValue + 1][];
            }
            int[] nArray = new int[this.maxIndexValue + 1];
            for (n = 0; n < n2; ++n) {
                int n4 = this.tsCoordIndex[n];
                nArray[n4] = nArray[n4] + 1;
            }
            for (n = 0; n < this.maxIndexValue + 1; ++n) {
                if (this.vertexToFace[n] != null && this.vertexToFace[n].length >= nArray[n]) continue;
                this.vertexToFace[n] = new int[nArray[n]];
            }
            for (n = 0; n < this.maxIndexValue + 1; ++n) {
                nArray[n] = 0;
            }
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                int n6 = this.tsCoordIndex[n];
                int n7 = nArray[n6];
                this.vertexToFace[n6][n7] = n5++;
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
                if (n % 3 != 2) continue;
            }
        }
    }

    private void buildConvexPolygons(boolean bl) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (bl || (this.changeFlags & 0x100) != 0) {
            for (n2 = 0; n2 < this.lfCoordIndex.length; ++n2) {
                if (this.rawVerticesPerFace[n4] < 3) {
                    n2 += this.rawVerticesPerFace[n4];
                    ++n4;
                    continue;
                }
                for (n = 0; n < this.rawVerticesPerFace[n4] - 2; ++n) {
                    if (n2 + 3 + n > this.lfCoordIndex.length) {
                        System.out.println("Invalid coord index in IndexedFaceSet");
                        n = this.rawVerticesPerFace[n4] - 2;
                        break;
                    }
                    this.tsCoordIndex[n3] = this.lfCoordIndex[n2];
                    this.tsCoordIndex[n3 + 1] = this.lfCoordIndex[n2 + 1 + n];
                    this.tsCoordIndex[n3 + 2] = this.lfCoordIndex[n2 + 2 + n];
                    n3 += 3;
                }
                n2 += n + 2;
                ++n4;
            }
            this.triangleCount = n3 / 3;
        }
        if (bl || (this.changeFlags & 0x200) != 0) {
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < this.lfCoordIndex.length; ++n2) {
                if (this.rawVerticesPerFace[n4] < 3) {
                    n2 += this.rawVerticesPerFace[n4];
                    ++n4;
                    continue;
                }
                for (n = 0; n < this.rawVerticesPerFace[n4] - 2; ++n) {
                    if (n2 + 3 + n > this.lfNormalIndex.length) {
                        System.out.println("Invalid normal index in IndexedFaceSet");
                        n = this.rawVerticesPerFace[n4] - 2;
                        break;
                    }
                    this.tsNormalIndex[n3] = this.lfNormalIndex[n2];
                    this.tsNormalIndex[n3 + 1] = this.lfNormalIndex[n2 + 1 + n];
                    this.tsNormalIndex[n3 + 2] = this.lfNormalIndex[n2 + 2 + n];
                    n3 += 3;
                }
                n2 += n + 2;
                ++n4;
            }
        }
        if (bl || (this.changeFlags & 0x400) != 0) {
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < this.lfCoordIndex.length; ++n2) {
                if (this.rawVerticesPerFace[n4] < 3) {
                    n2 += this.rawVerticesPerFace[n4];
                    ++n4;
                    continue;
                }
                for (n = 0; n < this.rawVerticesPerFace[n4] - 2; ++n) {
                    if (n2 + 3 + n > this.lfTexCoordIndex.length) {
                        System.out.println("Invalid texture index in IndexedFaceSet");
                        n = this.rawVerticesPerFace[n4] - 2;
                        break;
                    }
                    this.tsTexCoordIndex[n3] = this.lfTexCoordIndex[n2];
                    this.tsTexCoordIndex[n3 + 1] = this.lfTexCoordIndex[n2 + 1 + n];
                    this.tsTexCoordIndex[n3 + 2] = this.lfTexCoordIndex[n2 + 2 + n];
                    n3 += 3;
                }
                n2 += n + 2;
                ++n4;
            }
        }
        if (this.vfColor != null && (bl || (this.changeFlags & 0x800) != 0)) {
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < this.lfCoordIndex.length; ++n2) {
                if (this.rawVerticesPerFace[n4] < 3) {
                    n2 += this.rawVerticesPerFace[n4];
                    ++n4;
                    continue;
                }
                for (n = 0; n < this.rawVerticesPerFace[n4] - 2; ++n) {
                    if (n2 + 3 + n > this.lfColorIndex.length) {
                        System.out.println("Invalid color index in IndexedFaceSet");
                        n = this.rawVerticesPerFace[n4] - 2;
                        break;
                    }
                    this.tsColorIndex[n3] = this.lfColorIndex[n2];
                    this.tsColorIndex[n3 + 1] = this.lfColorIndex[n2 + 1 + n];
                    this.tsColorIndex[n3 + 2] = this.lfColorIndex[n2 + 2 + n];
                    n3 += 3;
                }
                n2 += n + 2;
                ++n4;
            }
        }
    }

    private void buildConcavePolygons(boolean bl) {
        if (this.maxPolySize < 4) {
            this.buildConvexPolygons(bl);
            return;
        }
        if (bl || (this.changeFlags & 0x100) != 0) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.lfCoordIndex.length; ++i) {
                if (this.rawVerticesPerFace[n2] < 3) {
                    i += this.rawVerticesPerFace[n2];
                    ++n2;
                    continue;
                }
                this.createFaceNormal(this.lfCoord, this.lfCoordIndex, i, this.rawVerticesPerFace[n2], this.normalTmp);
                int n3 = this.triangulator.triangulateConcavePolygon(this.lfCoord, i, this.rawVerticesPerFace[n2], this.lfCoordIndex, i, this.lfNormalIndex, i, this.lfColorIndex, i, this.lfTexCoordIndex, this.triangleOutput, this.normalOutput, this.colorOutput, this.texCoordOutput, this.normalTmp);
                if (n3 < 0) {
                    System.out.print("Invalid poly face is ");
                    System.out.println(n2);
                    System.out.print("index list is ");
                    for (int j = 0; j < this.rawVerticesPerFace[n2]; ++j) {
                        System.out.print(this.lfCoordIndex[i + j]);
                        System.out.print(' ');
                    }
                    System.out.println(-1);
                    n3 = -n3;
                }
                for (int j = 0; j < n3; ++j) {
                    this.tsCoordIndex[n] = this.triangleOutput[j * 3];
                    this.tsCoordIndex[n + 1] = this.triangleOutput[j * 3 + 1];
                    this.tsCoordIndex[n + 2] = this.triangleOutput[j * 3 + 2];
                    this.tsNormalIndex[n] = this.normalOutput[j * 3];
                    this.tsNormalIndex[n + 1] = this.normalOutput[j * 3 + 1];
                    this.tsNormalIndex[n + 2] = this.normalOutput[j * 3 + 2];
                    this.tsTexCoordIndex[n] = this.texCoordOutput[j * 3];
                    this.tsTexCoordIndex[n + 1] = this.texCoordOutput[j * 3 + 1];
                    this.tsTexCoordIndex[n + 2] = this.texCoordOutput[j * 3 + 2];
                    if (this.vfColor != null) {
                        this.tsColorIndex[n] = this.colorOutput[j * 3];
                        this.tsColorIndex[n + 1] = this.colorOutput[j * 3 + 1];
                        this.tsColorIndex[n + 2] = this.colorOutput[j * 3 + 2];
                    }
                    n += 3;
                }
                i += this.rawVerticesPerFace[n2];
                ++n2;
            }
            this.triangleCount = n / 3;
        }
    }

    private void updateCoordinateArray() {
        int n = this.triangleCount * 3;
        int n2 = 0;
        if (this.geomData.coordinates == null || this.geomData.coordinates.length < n * 3) {
            this.geomData.coordinates = new float[n * 3];
        }
        for (int i = 0; i < n; ++i) {
            int n3 = this.tsCoordIndex[i] * 3;
            this.geomData.coordinates[n2++] = this.lfCoord[n3];
            this.geomData.coordinates[n2++] = this.lfCoord[n3 + 1];
            this.geomData.coordinates[n2++] = this.lfCoord[n3 + 2];
        }
        this.geomData.vertexCount = n;
    }

    private void updateColorArray() {
        int n = this.triangleCount * 3;
        boolean bl = false;
        if (this.geomData.colors == null || this.geomData.colors.length < n * this.numColorComponents) {
            this.geomData.colors = new float[n * this.numColorComponents];
        }
        switch (this.numColorComponents) {
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < n; ++i) {
                    int n2 = this.tsColorIndex[i] * 3;
                    if (n2 + 3 > this.lfColor.length || n2 < 0) {
                        System.out.println("Invalid color index in IndexedFaceSet");
                        this.geomData.colors = null;
                        return;
                    }
                    this.geomData.colors[i * 3] = this.lfColor[n2];
                    this.geomData.colors[i * 3 + 1] = this.lfColor[n2 + 1];
                    this.geomData.colors[i * 3 + 2] = this.lfColor[n2 + 2];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n; ++i) {
                    int n3 = this.tsColorIndex[i] * 4;
                    if (n3 + 4 > this.lfColor.length || n3 < 0) {
                        System.out.println("Invalid color index in IndexedFaceSet");
                        this.geomData.colors = null;
                        return;
                    }
                    this.geomData.colors[i * 4] = this.lfColor[n3];
                    this.geomData.colors[i * 4 + 1] = this.lfColor[n3 + 1];
                    this.geomData.colors[i * 4 + 2] = this.lfColor[n3 + 2];
                    this.geomData.colors[i * 4 + 3] = this.lfColor[n3 + 3];
                }
                break;
            }
        }
    }

    private void updateNormalArray() {
        int n = this.triangleCount * 3;
        boolean bl = false;
        if (this.geomData.normals == null || this.geomData.normals.length < n * 3) {
            this.geomData.normals = new float[n * 3];
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.tsNormalIndex[i] * 3;
            if (n2 + 3 > this.lfNormal.length || n2 < 0) {
                System.out.println("Invalid normal index in IndexedFaceSet");
                this.geomData.colors = null;
                return;
            }
            this.geomData.normals[i * 3] = this.lfNormal[n2];
            this.geomData.normals[i * 3 + 1] = this.lfNormal[n2 + 1];
            this.geomData.normals[i * 3 + 2] = this.lfNormal[n2 + 2];
        }
    }

    private void updateTexCoordinateArray(int n, int n2) {
        int n3;
        int n4 = this.triangleCount * 3;
        boolean bl = false;
        int n5 = 0;
        this.numTextureDimensions = this.vfTexCoord != null ? this.vfTexCoord.getNumTextureComponents() : 2;
        n5 = this.geomData.vertexCount * this.numTextureDimensions;
        if (this.geomData.textureCoordinates == null || this.geomData.textureCoordinates.length < n2) {
            this.geomData.textureCoordinates = new float[n2][];
            for (n3 = 0; n3 < n2; ++n3) {
                this.geomData.textureCoordinates[n3] = new float[n5];
            }
        }
        if (this.geomData.textureCoordinates[n].length < n5) {
            this.geomData.textureCoordinates[n] = new float[n5];
        }
        switch (this.numTextureDimensions) {
            case 2: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n6 = this.tsTexCoordIndex[n3] * 2;
                    if (n6 > this.lfTexCoord.length - 2 || n6 < 0) {
                        System.out.println("Invalid index in texture coordinate, ignoring");
                        continue;
                    }
                    this.geomData.textureCoordinates[n][n3 * 2] = this.lfTexCoord[n6];
                    this.geomData.textureCoordinates[n][n3 * 2 + 1] = this.lfTexCoord[n6 + 1];
                }
                break;
            }
            case 3: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n7 = this.tsTexCoordIndex[n3] * 3;
                    this.geomData.textureCoordinates[n][n3 * 3] = this.lfTexCoord[n7];
                    this.geomData.textureCoordinates[n][n3 * 3 + 1] = this.lfTexCoord[n7 + 1];
                    this.geomData.textureCoordinates[n][n3 * 3 + 2] = this.lfTexCoord[n7 + 2];
                }
                break;
            }
            case 4: {
                for (n3 = 0; n3 < n4; ++n3) {
                    int n8 = this.tsTexCoordIndex[n3] * 4;
                    this.geomData.textureCoordinates[n][n3 * 4] = this.lfTexCoord[n8];
                    this.geomData.textureCoordinates[n][n3 * 4 + 1] = this.lfTexCoord[n8 + 1];
                    this.geomData.textureCoordinates[n][n3 * 4 + 2] = this.lfTexCoord[n8 + 2];
                    this.geomData.textureCoordinates[n][n3 * 4 + 3] = this.lfTexCoord[n8 + 3];
                }
                break;
            }
        }
    }

    private void createFaceNormal(float[] fArray, int n, int n2, float[] fArray2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n3 = n;
        int n4 = n + 1;
        int n5 = n + 2;
        for (int i = 0; i < n2 - 1; ++i) {
            f += (fArray[n4] - fArray[n4 + 3]) * (fArray[n5] + fArray[n5 + 3]);
            f2 += (fArray[n5] - fArray[n5 + 3]) * (fArray[n3] + fArray[n3 + 3]);
            f3 += (fArray[n3] - fArray[n3 + 3]) * (fArray[n4] + fArray[n4 + 3]);
            n4 += 3;
            n3 += 3;
            n5 += 3;
        }
        fArray2[0] = f += (fArray[n4] - fArray[n + 1]) * (fArray[n5] + fArray[n + 2]);
        fArray2[1] = f2 += (fArray[n5] - fArray[n + 2]) * (fArray[n3] + fArray[n]);
        fArray2[2] = f3 += (fArray[n3] - fArray[n]) * (fArray[n4] + fArray[n + 1]);
        double d = f * f + f2 * f2 + f3 * f3;
        if (d != 0.0) {
            d = (double)(this.vfCcw ? 1 : -1) / Math.sqrt(d);
            fArray2[0] = (float)((double)fArray2[0] * d);
            fArray2[1] = (float)((double)fArray2[1] * d);
            fArray2[2] = (float)((double)fArray2[2] * d);
        }
    }

    private void createFaceNormal(float[] fArray, int[] nArray, int n, int n2, float[] fArray2) {
        int n3;
        int n4;
        int n5;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n6 = nArray[n] * 3;
        int n7 = n6 + 1;
        int n8 = n6 + 2;
        for (int i = 0; i < n2 - 1; ++i) {
            n5 = nArray[n + i + 1] * 3;
            n4 = n5 + 1;
            n3 = n5 + 2;
            f += (fArray[n7] - fArray[n4]) * (fArray[n8] + fArray[n3]);
            f2 += (fArray[n8] - fArray[n3]) * (fArray[n6] + fArray[n5]);
            f3 += (fArray[n6] - fArray[n5]) * (fArray[n7] + fArray[n4]);
            n6 = n5;
            n7 = n4;
            n8 = n3;
        }
        n5 = nArray[n] * 3;
        n4 = n5 + 1;
        n3 = n5 + 2;
        fArray2[0] = f += (fArray[n7] - fArray[n4]) * (fArray[n8] + fArray[n3]);
        fArray2[1] = f2 += (fArray[n8] - fArray[n3]) * (fArray[n6] + fArray[n5]);
        fArray2[2] = f3 += (fArray[n6] - fArray[n5]) * (fArray[n7] + fArray[n4]);
        double d = f * f + f2 * f2 + f3 * f3;
        if (d != 0.0) {
            d = (double)(this.vfCcw ? 1 : -1) / Math.sqrt(d);
            fArray2[0] = (float)((double)fArray2[0] * d);
            fArray2[1] = (float)((double)fArray2[1] * d);
            fArray2[2] = (float)((double)fArray2[2] * d);
        }
    }
}

