/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseWorldRoot
extends AbstractNode
implements VRMLWorldRootNodeType {
    private static final int FIELD_CHILDREN = 1;
    private static final int FIELD_BBOX_CENTER = 2;
    private static final int FIELD_BBOX_SIZE = 3;
    private static final int LAST_WORLD_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    private static final String NON_CHILD_PROTO_MSG = "Proto at the root of the scene graph is not a valid X3DChildNode: ";
    private static final String NON_CHILD_NODE_MSG = "Node at the root of the scene graph is not a valid X3DChildNode: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private float[] bboxSize;
    private float[] bboxCenter;
    protected ArrayList vfChildren = new ArrayList();
    protected int childCount = 0;
    private BasicScene scene;

    public BaseWorldRoot() {
        super("WorldRoot");
        this.bboxSize = new float[]{-1.0f, -1.0f, -1.0f};
        this.bboxCenter = new float[3];
        this.hasChanged = new boolean[4];
    }

    public void setContainedScene(BasicScene basicScene) {
        if (basicScene == null) {
            throw new NullPointerException("Scene instance is null");
        }
        this.scene = basicScene;
    }

    public void setBboxCenter(float[] fArray) {
        this.bboxCenter[0] = fArray[0];
        this.bboxCenter[1] = fArray[1];
        this.bboxCenter[2] = fArray[2];
    }

    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    public void setBboxSize(float[] fArray) {
        this.bboxSize[0] = fArray[0];
        this.bboxSize[1] = fArray[1];
        this.bboxSize[2] = fArray[2];
    }

    public float[] getBboxSize() {
        return this.bboxSize;
    }

    public BasicScene getContainedScene() {
        return this.scene;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.childCount = this.vfChildren.size();
        for (int i = 0; i < this.childCount; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfChildren.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 57;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.bboxSize;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.bboxCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 1: {
                this.fieldData.clear();
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfChildren.size()];
                this.vfChildren.toArray(vRMLNodeTypeArray);
                this.fieldData.nodeArrayValue = vRMLNodeTypeArray;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = this.childCount;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public VRMLNodeType[] getChildren() {
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfChildren.size()];
        this.vfChildren.toArray(vRMLNodeTypeArray);
        return vRMLNodeTypeArray;
    }

    public void setChildren(VRMLNodeType[] vRMLNodeTypeArray) {
        this.clearChildren();
        this.hasChanged[1] = true;
        if (vRMLNodeTypeArray == null) {
            return;
        }
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.addChildNode(vRMLNodeTypeArray[i]);
        }
    }

    public void addChild(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType != null) {
            this.addChildNode(vRMLNodeType);
        }
        this.hasChanged[1] = true;
    }

    public void removeChild(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType == null) {
            return;
        }
        this.removeChildNode(vRMLNodeType);
        this.hasChanged[1] = true;
    }

    public void setChildren(VRMLNodeType vRMLNodeType) {
        this.clearChildren();
        if (vRMLNodeType != null) {
            this.addChildNode(vRMLNodeType);
        }
        this.hasChanged[1] = true;
    }

    public int getChildrenSize() {
        return this.vfChildren.size();
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ");
        }
        switch (n) {
            case 2: {
                this.setBboxCenter(fArray);
                break;
            }
            case 3: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType2);
                }
                this.hasChanged[1] = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                this.hasChanged[1] = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void clearChildren() {
        this.childCount = 0;
        this.vfChildren.clear();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLChildNodeType)) {
                throw new InvalidFieldValueException(NON_CHILD_PROTO_MSG + vRMLNodeType.getVRMLNodeName());
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLChildNodeType)) {
            throw new InvalidFieldValueException(NON_CHILD_NODE_MSG + vRMLNodeType.getVRMLNodeName());
        }
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
        this.vfChildren.add(vRMLNodeType);
        ++this.childCount;
        if (!this.inSetup) {
            this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(false);
        }
        this.vfChildren.remove(vRMLNodeType);
        --this.childCount;
        if (!this.inSetup) {
            if (this.stateManager == null) {
                System.out.println("StateManager null on removeChild");
            } else {
                this.stateManager.registerRemovedNode((VRMLNode)vRMLNodeType);
            }
        }
    }

    static {
        nodeFields = new int[]{1};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseWorldRoot.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseWorldRoot.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFVec3f", "bboxCenter");
        BaseWorldRoot.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        fieldMap.put("bboxSize", new Integer(3));
        fieldMap.put("bboxCenter", new Integer(2));
        Integer n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
    }
}

