/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.enveffects;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseFogCoordinate
extends BaseGeometricPropertyNode {
    protected static final int FIELD_DEPTH = 1;
    protected static final int LAST_COORDINATE_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfDepth = FieldConstants.EMPTY_MFFLOAT;
    protected int numDepth;

    public BaseFogCoordinate() {
        super("FogCoordinate");
        this.hasChanged = new boolean[2];
    }

    public BaseFogCoordinate(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("depth");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfDepth = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfDepth, 0, vRMLFieldData.numElements);
                this.numDepth = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setDepth(float[] fArray, int n) {
        if (n > this.vfDepth.length) {
            this.vfDepth = new float[n];
        }
        this.numDepth = n;
        System.arraycopy(fArray, 0, this.vfDepth, 0, this.numDepth);
        if (!this.inSetup) {
            this.fireComponentChanged(1);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public int getNumDepth() {
        return this.numDepth;
    }

    public void getDepth(float[] fArray) {
        if (this.vfDepth != null) {
            System.arraycopy(this.vfDepth, 0, fArray, 0, this.numDepth);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 11;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfDepth;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numDepth;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfDepth, this.numDepth);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setDepth(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseFogCoordinate.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseFogCoordinate.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFFloat", "depth");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("depth", n);
        fieldMap.put("set_depth", n);
        fieldMap.put("depth_changed", n);
    }
}

