/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.eventutils;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseBooleanFilter
extends AbstractNode
implements VRMLChildNodeType {
    protected static final int FIELD_SET_BOOLEAN = 1;
    protected static final int FIELD_INPUT_FALSE = 2;
    protected static final int FIELD_INPUT_TRUE = 3;
    protected static final int FIELD_INPUT_NEGATE = 4;
    protected static final int LAST_BOOLEAN_FILTER_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private boolean lastBool;

    public BaseBooleanFilter() {
        super("BooleanFilter");
        this.hasChanged = new boolean[5];
        this.lastBool = false;
    }

    public BaseBooleanFilter(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.booleanValue = true;
                this.fieldData.dataType = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = true;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.booleanValue = !this.lastBool;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, true);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, true);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, !this.lastBool);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseBooleanFilter.sendRoute: InvalidField: " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseBooleanFilter.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setBoolean(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    private void setBoolean(boolean bl) {
        this.lastBool = bl;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
            if (bl) {
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
            } else {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseBooleanFilter.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_boolean");
        BaseBooleanFilter.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "inputFalse");
        BaseBooleanFilter.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "inputTrue");
        BaseBooleanFilter.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFBool", "inputNegate");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("set_boolean", n);
        n = new Integer(2);
        fieldMap.put("inputFalse", n);
        n = new Integer(3);
        fieldMap.put("inputTrue", n);
        n = new Integer(4);
        fieldMap.put("inputNegate", n);
    }
}

