/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.eventutils;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseBooleanTrigger
extends AbstractNode
implements VRMLChildNodeType {
    protected static final int FIELD_SET_TRIGGER_TIME = 1;
    protected static final int FIELD_TRIGGER_TRUE = 2;
    protected static final int LAST_BOOLEAN_TRIGGER_INDEX = 2;
    protected static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;

    public BaseBooleanTrigger() {
        super("BooleanTrigger");
        this.hasChanged = new boolean[3];
    }

    public BaseBooleanTrigger(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.booleanValue = true;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, true);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseBooleanTrigger.sendRoute: InvalidField: " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseBooleanTrigger.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setTriggerTime();
                break;
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    private void setTriggerTime() {
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(9);
        BaseBooleanTrigger.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBooleanTrigger.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFTime", "set_triggerTime");
        BaseBooleanTrigger.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "triggerTrue");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("set_triggerTime", n);
        n = new Integer(2);
        fieldMap.put("triggerTrue", n);
    }
}

