/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.device.DeviceState;
import org.web3d.vrml.device.GamepadDevice;
import org.web3d.vrml.device.GamepadState;
import org.web3d.vrml.device.InputDevice;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.extensions.BaseHIDSensor;

public class BaseGamepadSensor
extends BaseHIDSensor {
    private static final int FIELD_RUMBLER_X = 19;
    private static final int FIELD_RUMBLER_Y = 20;
    private static final int FIELD_L1_BUTTON = 21;
    private static final int FIELD_R1_BUTTON = 22;
    private static final int FIELD_LEFT_HAT_X = 23;
    private static final int FIELD_LEFT_HAT_Y = 24;
    private static final int FIELD_RIGHT_STICK_X = 25;
    private static final int FIELD_RIGHT_STICK_Y = 26;
    private static final int FIELD_START_BUTTON = 27;
    private static final int FIELD_THROTTLE_SLIDER = 28;
    private static final int FIELD_FEATURES_AVAILABLE = 29;
    private static final int FIELD_LEFT_STICK_X = 30;
    private static final int FIELD_LEFT_STICK_Y = 31;
    private static final int LAST_GAMEPAD_SENSOR_INDEX = 31;
    private static final int NUM_FIELDS = 32;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private String[] vfFeaturesAvailable;
    private float vfRumblerX;
    private float vfRumblerY;
    private float vfLeftStickX;
    private float vfLeftStickY;
    private float vfLeftHatX;
    private float vfLeftHatY;
    private float vfRightStickX;
    private float vfRightStickY;
    private boolean vfL1Button;
    private boolean vfR1Button;
    private boolean vfStartButton;
    private float vfThrottleSlider;
    private GamepadDevice realdevice;

    public BaseGamepadSensor() {
        super("GamepadSensor");
        this.hasChanged = new boolean[32];
        this.vfFeaturesAvailable = FieldConstants.EMPTY_MFSTRING;
        this.vfRumblerX = 0.0f;
        this.vfRumblerY = 0.0f;
        this.vfLeftStickX = 0.0f;
        this.vfLeftStickY = 0.0f;
        this.vfLeftHatX = 0.0f;
        this.vfLeftHatY = 0.0f;
        this.vfRightStickX = 0.0f;
        this.vfRightStickY = 0.0f;
        this.vfL1Button = false;
        this.vfR1Button = false;
        this.vfStartButton = false;
        this.vfThrottleSlider = -1.0f;
    }

    public BaseGamepadSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy(vRMLNodeType);
    }

    public void setDevice(InputDevice inputDevice) {
        this.realdevice = (GamepadDevice)inputDevice;
    }

    public void update(DeviceState deviceState) {
        GamepadState gamepadState = (GamepadState)deviceState;
        if (gamepadState.leftStickX_changed) {
            this.vfLeftStickX = gamepadState.leftStickX;
            this.hasChanged[30] = true;
            this.fireFieldChanged(30);
        }
        if (gamepadState.leftStickY_changed) {
            this.vfLeftStickY = gamepadState.leftStickY;
            this.hasChanged[31] = true;
            this.fireFieldChanged(31);
        }
        if (gamepadState.rightStickX_changed) {
            this.vfRightStickX = gamepadState.rightStickX;
            this.hasChanged[25] = true;
            this.fireFieldChanged(25);
        }
        if (gamepadState.rightStickY_changed) {
            this.vfRightStickY = gamepadState.rightStickY;
            this.hasChanged[26] = true;
            this.fireFieldChanged(26);
        }
        if (gamepadState.leftHatX_changed) {
            this.vfLeftHatX = gamepadState.leftHatX;
            this.hasChanged[23] = true;
            this.fireFieldChanged(23);
        }
        if (gamepadState.leftHatY_changed) {
            this.vfLeftHatY = gamepadState.leftHatY;
            this.hasChanged[24] = true;
            this.fireFieldChanged(24);
        }
        if (gamepadState.l1Button_changed) {
            this.vfL1Button = gamepadState.l1Button;
            this.hasChanged[21] = true;
            this.fireFieldChanged(21);
        }
        if (gamepadState.r1Button_changed) {
            this.vfR1Button = gamepadState.r1Button;
            this.hasChanged[22] = true;
            this.fireFieldChanged(22);
        }
        if (gamepadState.startButton_changed) {
            this.vfStartButton = gamepadState.startButton;
            this.hasChanged[27] = true;
            this.fireFieldChanged(27);
        }
        if (gamepadState.throttleSlider_changed) {
            this.vfThrottleSlider = gamepadState.throttleSlider;
            this.hasChanged[28] = true;
            this.fireFieldChanged(28);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 31) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 29: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfFeaturesAvailable;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfFeaturesAvailable.length;
                break;
            }
            case 30: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfLeftStickX;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 31: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfLeftStickY;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 25: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRightStickX;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 26: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRightStickY;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 23: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfLeftHatX;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 24: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfLeftHatY;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 28: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfThrottleSlider;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 21: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfL1Button;
                this.fieldData.dataType = 1;
                break;
            }
            case 22: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfR1Button;
                this.fieldData.dataType = 1;
                break;
            }
            case 27: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfStartButton;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 30: {
                    vRMLNodeType.setValue(n2, this.vfLeftStickX);
                    break;
                }
                case 31: {
                    vRMLNodeType.setValue(n2, this.vfLeftStickY);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfLeftHatX);
                    break;
                }
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfLeftHatY);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfRightStickX);
                    break;
                }
                case 26: {
                    vRMLNodeType.setValue(n2, this.vfRightStickY);
                    break;
                }
                case 28: {
                    vRMLNodeType.setValue(n2, this.vfThrottleSlider);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfL1Button);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfR1Button);
                    break;
                }
                case 27: {
                    vRMLNodeType.setValue(n2, this.vfStartButton);
                    break;
                }
                case 29: {
                    vRMLNodeType.setValue(n2, this.vfFeaturesAvailable, this.vfFeaturesAvailable.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 19: {
                this.setRumblerX(f);
                break;
            }
            case 20: {
                this.setRumblerY(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    protected void setRumblerX(float f) {
        if (this.realdevice != null) {
            this.realdevice.setRumblerX(f);
        }
    }

    protected void setRumblerY(float f) {
        if (this.realdevice != null) {
            this.realdevice.setRumblerY(f);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[32];
        fieldMap = new HashMap(32);
        BaseGamepadSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGamepadSensor.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseGamepadSensor.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFString", "name");
        BaseGamepadSensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseGamepadSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "MFFloat", "axisValue");
        BaseGamepadSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFFloat", "axisMinValue");
        BaseGamepadSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFFloat", "axisMaxValue");
        BaseGamepadSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "MFString", "axisName");
        BaseGamepadSensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "MFFloat", "axisResolution");
        BaseGamepadSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "MFBool", "axisWrap");
        BaseGamepadSensor.fieldDecl[14] = new VRMLFieldDeclaration(4, "MFFloat", "outputMinValue");
        BaseGamepadSensor.fieldDecl[15] = new VRMLFieldDeclaration(4, "MFFloat", "outputMaxValue");
        BaseGamepadSensor.fieldDecl[13] = new VRMLFieldDeclaration(4, "MFString", "outputName");
        BaseGamepadSensor.fieldDecl[16] = new VRMLFieldDeclaration(4, "MFFloat", "outputResolution");
        BaseGamepadSensor.fieldDecl[17] = new VRMLFieldDeclaration(4, "MFBool", "outputWrap");
        BaseGamepadSensor.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFInt32", "numAxes");
        BaseGamepadSensor.fieldDecl[12] = new VRMLFieldDeclaration(4, "SFInt32", "numOutputs");
        BaseGamepadSensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFString", "manufacturerName");
        BaseGamepadSensor.fieldDecl[19] = new VRMLFieldDeclaration(1, "SFFloat", "rumblerX");
        BaseGamepadSensor.fieldDecl[20] = new VRMLFieldDeclaration(1, "SFFloat", "rumblerY");
        BaseGamepadSensor.fieldDecl[29] = new VRMLFieldDeclaration(4, "MFString", "featuresAvailable");
        BaseGamepadSensor.fieldDecl[30] = new VRMLFieldDeclaration(4, "SFFloat", "leftStickX");
        BaseGamepadSensor.fieldDecl[31] = new VRMLFieldDeclaration(4, "SFFloat", "leftStickY");
        BaseGamepadSensor.fieldDecl[23] = new VRMLFieldDeclaration(4, "SFFloat", "leftHatX");
        BaseGamepadSensor.fieldDecl[24] = new VRMLFieldDeclaration(4, "SFFloat", "leftHatY");
        BaseGamepadSensor.fieldDecl[25] = new VRMLFieldDeclaration(4, "SFFloat", "rightStickX");
        BaseGamepadSensor.fieldDecl[26] = new VRMLFieldDeclaration(4, "SFFloat", "rightStickY");
        BaseGamepadSensor.fieldDecl[21] = new VRMLFieldDeclaration(4, "SFBool", "l1Button");
        BaseGamepadSensor.fieldDecl[22] = new VRMLFieldDeclaration(4, "SFBool", "r1Button");
        BaseGamepadSensor.fieldDecl[27] = new VRMLFieldDeclaration(4, "SFBool", "startButton");
        BaseGamepadSensor.fieldDecl[28] = new VRMLFieldDeclaration(4, "SFFloat", "throttleSlider");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        n = new Integer(18);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("isActive", n);
        fieldMap.put("isActive_changed", n);
        n = new Integer(2);
        fieldMap.put("outputValue", n);
        fieldMap.put("outputValue_changed", n);
        n = new Integer(4);
        fieldMap.put("axisValue", n);
        fieldMap.put("axisValue_changed", n);
        n = new Integer(5);
        fieldMap.put("axisMinValue", n);
        fieldMap.put("axisMinValue_changed", n);
        n = new Integer(6);
        fieldMap.put("axisMaxValue", n);
        fieldMap.put("axisMaxValue_changed", n);
        n = new Integer(7);
        fieldMap.put("axisName", n);
        fieldMap.put("axisName_changed", n);
        n = new Integer(8);
        fieldMap.put("axisResolution", n);
        fieldMap.put("axisResolution_changed", n);
        n = new Integer(9);
        fieldMap.put("axisWrap", n);
        fieldMap.put("axisWrap_changed", n);
        n = new Integer(14);
        fieldMap.put("outputMinValue", n);
        fieldMap.put("outputMinValue_changed", n);
        n = new Integer(15);
        fieldMap.put("outputMaxValue", n);
        fieldMap.put("outputMaxValue_changed", n);
        n = new Integer(13);
        fieldMap.put("outputName", n);
        fieldMap.put("outputName_changed", n);
        n = new Integer(16);
        fieldMap.put("outputResolution", n);
        fieldMap.put("outputResolution_changed", n);
        n = new Integer(17);
        fieldMap.put("outputWrap", n);
        fieldMap.put("outputWrap_changed", n);
        n = new Integer(11);
        fieldMap.put("numAxes", n);
        fieldMap.put("numAxes_changed", n);
        n = new Integer(12);
        fieldMap.put("numOutputs", n);
        fieldMap.put("numOutputs_changed", n);
        n = new Integer(29);
        fieldMap.put("featuresAvailable", n);
        fieldMap.put("featuresAvailable_changed", n);
        n = new Integer(10);
        fieldMap.put("manufacturerName", n);
        fieldMap.put("manufacturerName_changed", n);
        n = new Integer(30);
        fieldMap.put("leftStickX", n);
        fieldMap.put("leftStickX_changed", n);
        n = new Integer(31);
        fieldMap.put("leftStickY", n);
        fieldMap.put("leftStickY_changed", n);
        n = new Integer(25);
        fieldMap.put("rightStickX", n);
        fieldMap.put("rightStickX_changed", n);
        n = new Integer(26);
        fieldMap.put("rightStickY", n);
        fieldMap.put("rightStickY_changed", n);
        n = new Integer(23);
        fieldMap.put("leftHatX", n);
        fieldMap.put("leftHatX_changed", n);
        n = new Integer(24);
        fieldMap.put("leftHatY", n);
        fieldMap.put("leftHatY_changed", n);
        n = new Integer(19);
        fieldMap.put("rumblerX", n);
        fieldMap.put("rumblerX_changed", n);
        n = new Integer(20);
        fieldMap.put("rumblerY", n);
        fieldMap.put("rumblerY_changed", n);
        n = new Integer(21);
        fieldMap.put("l1Button", n);
        fieldMap.put("l1Button_changed", n);
        n = new Integer(22);
        fieldMap.put("r1Button", n);
        fieldMap.put("r1Button_changed", n);
        n = new Integer(27);
        fieldMap.put("startButton", n);
        fieldMap.put("startButton_changed", n);
        n = new Integer(28);
        fieldMap.put("throttleSlider", n);
        fieldMap.put("throttleSlider_changed", n);
    }
}

