/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseHIDSensor
extends AbstractNode
implements VRMLDeviceSensorNodeType {
    protected static final int FIELD_NAME = 1;
    protected static final int FIELD_OUTPUT_VALUE = 2;
    protected static final int FIELD_IS_ACTIVE = 3;
    protected static final int FIELD_AXIS_VALUE = 4;
    protected static final int FIELD_AXIS_MIN_VALUE = 5;
    protected static final int FIELD_AXIS_MAX_VALUE = 6;
    protected static final int FIELD_AXIS_NAME = 7;
    protected static final int FIELD_AXIS_RESOLUTION = 8;
    protected static final int FIELD_AXIS_WRAP = 9;
    protected static final int FIELD_MANUFACTURER_NAME = 10;
    protected static final int FIELD_NUM_AXES = 11;
    protected static final int FIELD_NUM_OUTPUTS = 12;
    protected static final int FIELD_OUTPUT_NAME = 13;
    protected static final int FIELD_OUTPUT_MIN_VALUE = 14;
    protected static final int FIELD_OUTPUT_MAX_VALUE = 15;
    protected static final int FIELD_OUTPUT_RESOLUTION = 16;
    protected static final int FIELD_OUTPUT_WRAP = 17;
    protected static final int FIELD_ENABLED = 18;
    protected static final int LAST_HIDSENSOR_INDEX = 18;
    private static final int NUM_FIELDS = 19;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfEnabled;
    protected String vfName;
    protected boolean vfIsActive;
    protected float[] vfAxisValue;
    protected float[] vfAxisMinValue;
    protected float[] vfAxisMaxValue;
    protected String[] vfAxisName;
    protected float[] vfAxisResolution;
    protected boolean[] vfAxisWrap;
    protected String vfManufacturerName;
    protected int vfNumAxes;
    protected int vfNumOutputs;
    protected float[] vfOutputValue;
    protected float[] vfOutputMinValue;
    protected float[] vfOutputMaxValue;
    protected String[] vfOutputName;
    protected float[] vfOutputResolution;
    protected boolean[] vfOutputWrap;

    public BaseHIDSensor(String string) {
        super(string);
        this.hasChanged = new boolean[19];
        this.vfEnabled = true;
        this.vfIsActive = false;
        this.vfAxisValue = FieldConstants.EMPTY_MFFLOAT;
        this.vfAxisMinValue = FieldConstants.EMPTY_MFFLOAT;
        this.vfAxisMaxValue = FieldConstants.EMPTY_MFFLOAT;
        this.vfAxisName = FieldConstants.EMPTY_MFSTRING;
        this.vfAxisResolution = FieldConstants.EMPTY_MFFLOAT;
        this.vfAxisWrap = FieldConstants.EMPTY_MFBOOL;
        this.vfOutputMinValue = FieldConstants.EMPTY_MFFLOAT;
        this.vfOutputMaxValue = FieldConstants.EMPTY_MFFLOAT;
        this.vfOutputName = FieldConstants.EMPTY_MFSTRING;
        this.vfOutputResolution = FieldConstants.EMPTY_MFFLOAT;
        this.vfOutputWrap = FieldConstants.EMPTY_MFBOOL;
        this.vfNumAxes = 0;
        this.vfNumOutputs = 0;
    }

    protected void copy(VRMLNodeType vRMLNodeType) {
        try {
            int n = vRMLNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getName() {
        return this.vfName;
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 18) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 78;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 18: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfEnabled;
                this.fieldData.dataType = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfIsActive;
                this.fieldData.dataType = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfManufacturerName;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 1: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfName;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAxisValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfAxisValue.length;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAxisMinValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfAxisMinValue.length;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAxisMaxValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfAxisMaxValue.length;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfAxisName;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfAxisName.length;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.booleanArrayValue = this.vfAxisWrap;
                this.fieldData.dataType = (short)8;
                this.fieldData.numElements = this.vfAxisWrap.length;
                break;
            }
            case 14: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOutputMinValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfOutputMinValue.length;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOutputMaxValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfOutputMaxValue.length;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfOutputName;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfOutputName.length;
                break;
            }
            case 17: {
                this.fieldData.clear();
                this.fieldData.booleanArrayValue = this.vfOutputWrap;
                this.fieldData.dataType = (short)8;
                this.fieldData.numElements = this.vfOutputWrap.length;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfNumAxes;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfNumOutputs;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfManufacturerName);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfNumAxes);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfNumOutputs);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAxisValue, this.vfAxisValue.length);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfAxisMinValue, this.vfAxisMinValue.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfAxisMaxValue, this.vfAxisMaxValue.length);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfAxisName, this.vfAxisName.length);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfAxisResolution, this.vfAxisResolution.length);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfAxisWrap, this.vfAxisWrap.length);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfOutputValue, this.vfOutputValue.length);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfOutputMinValue, this.vfOutputMinValue.length);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfOutputMaxValue, this.vfOutputMaxValue.length);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfOutputName, this.vfOutputName.length);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfOutputResolution, this.vfOutputResolution.length);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfOutputWrap, this.vfOutputWrap.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 18: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setName(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                this.hasChanged[18] = true;
                this.fireFieldChanged(18);
            }
        }
    }

    protected void setName(String string) {
        this.vfName = string;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }
}

