/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseLocalFog
extends AbstractNode
implements VRMLFogNodeType {
    private static final String UNKNOWN_TYPE_MSG = "The fog type provided is not recognised";
    private static final String NEGATIVE_RANGE_MSG = "The fog visibility range is negative";
    protected static final int FIELD_ENABLED = 1;
    protected static final int FIELD_COLOR = 2;
    protected static final int FIELD_FOGTYPE = 3;
    protected static final int FIELD_VISIBILITY_RANGE = 4;
    public static final int LAST_FOG_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    protected static final String LINEAR_TYPE = "LINEAR";
    protected static final String EXPONENTIAL_TYPE = "EXPONENTIAL";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static HashMap typeMap;
    private static int[] nodeFields;
    protected float vfVisibilityRange;
    protected String vfFogType;
    protected float[] vfColor;
    protected int fogType;
    protected boolean vfEnabled;

    protected BaseLocalFog() {
        super("LocalFog");
        this.hasChanged = new boolean[5];
        this.vfVisibilityRange = 0.0f;
        this.vfFogType = LINEAR_TYPE;
        this.vfColor = new float[]{1.0f, 1.0f, 1.0f};
        this.vfEnabled = true;
        this.fogType = 1;
    }

    protected BaseLocalFog(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("visibilityRange");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVisibilityRange = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("fogType");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFogType = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.vfColor[0];
        fArray[1] = this.vfColor[1];
        fArray[2] = this.vfColor[2];
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"LocalFog.color", (float[])fArray);
        this.vfColor[0] = fArray[0];
        this.vfColor[1] = fArray[1];
        this.vfColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public float getVisibilityRange() {
        return this.vfVisibilityRange;
    }

    public void setVisibilityRange(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEGATIVE_RANGE_MSG);
        }
        this.vfVisibilityRange = f;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public int getFogType() {
        return this.fogType;
    }

    public void setFogType(int n) throws InvalidFieldValueException {
        if (n < 0 && n > 2) {
            throw new InvalidFieldValueException(UNKNOWN_TYPE_MSG);
        }
        this.fogType = n;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Setting DEF out of node setup");
        }
        this.isDEF = true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 18;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfVisibilityRange;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfFogType;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 1: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfEnabled;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfColor, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfVisibilityRange);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfFogType);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("LocalFog sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("LocalFog sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setVisibilityRange(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setFogType(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setFogType(String string) throws InvalidFieldValueException {
        if (!string.equals(LINEAR_TYPE) && !string.equals(EXPONENTIAL_TYPE)) {
            throw new InvalidFieldValueException(UNKNOWN_TYPE_MSG);
        }
        this.vfFogType = string;
        Integer n = (Integer)typeMap.get(string);
        this.setFogType(n);
    }

    protected void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseLocalFog.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLocalFog.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseLocalFog.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BaseLocalFog.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "visibilityRange");
        BaseLocalFog.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFString", "fogType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(4);
        fieldMap.put("visibilityRange", n);
        fieldMap.put("set_visibilityRange", n);
        fieldMap.put("visibilityRange_changed", n);
        fieldMap.put("fogType", new Integer(3));
        typeMap = new HashMap();
        typeMap.put(LINEAR_TYPE, new Integer(1));
        typeMap.put(EXPONENTIAL_TYPE, new Integer(2));
    }
}

